/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

class EclipseAuthenticator
extends Authenticator {
    private final IProxyService service;

    EclipseAuthenticator(IProxyService s) {
        this.service = s;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        IProxyData[] data = this.service.getProxyData();
        if (data == null) {
            return null;
        }
        IProxyData[] iProxyDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData d = iProxyDataArray[n2];
            if (d.getUserId() != null && d.getHost() != null && d.getPort() == this.getRequestingPort() && this.hostMatches(d)) {
                return this.auth(d);
            }
            ++n2;
        }
        return null;
    }

    private PasswordAuthentication auth(IProxyData d) {
        String user = d.getUserId();
        String pass = d.getPassword();
        char[] passChar = pass != null ? pass.toCharArray() : new char[]{};
        return new PasswordAuthentication(user, passChar);
    }

    private boolean hostMatches(IProxyData d) {
        try {
            InetAddress dHost = InetAddress.getByName(d.getHost());
            InetAddress rHost = this.getRequestingSite();
            if (rHost == null) {
                rHost = InetAddress.getByName(this.getRequestingHost());
            }
            return dHost.equals(rHost);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }
}

