/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.concurrency;

import io.takari.filemanager.FileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.io.FileProcessor;

@Named
@Singleton
public class LockingFileProcessor
implements FileProcessor {
    private FileManager fileManager;

    @Inject
    public LockingFileProcessor(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public boolean mkdirs(File directory) {
        return this.fileManager.mkdirs(directory);
    }

    public void write(File target, String data) throws IOException {
        this.fileManager.write(target, data);
    }

    public void write(File target, InputStream source) throws IOException {
        this.fileManager.write(target, source);
    }

    public void move(File source, File target) throws IOException {
        this.fileManager.move(source, target);
    }

    public void copy(File source, File target) throws IOException {
        this.fileManager.copy(source, target);
    }

    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        return this.fileManager.copy(source, target, (FileManager.ProgressListener)new ProgressListenerAdapter(listener));
    }

    static class ProgressListenerAdapter
    implements FileManager.ProgressListener {
        private FileProcessor.ProgressListener listener;

        public ProgressListenerAdapter(FileProcessor.ProgressListener listener) {
            this.listener = listener;
        }

        public void progressed(ByteBuffer buffer) throws IOException {
            this.listener.progressed(buffer);
        }
    }
}

