/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.wb.core.model.JavaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyToComponentsSupport {
    private final Map<String, Set<JavaInfo>> m_keyToComponents = Maps.newTreeMap();

    public KeyToComponentsSupport(boolean useListener) {
    }

    public KeyToComponentsSupport getCopy(boolean useListener) {
        KeyToComponentsSupport copy = new KeyToComponentsSupport(useListener);
        for (Map.Entry<String, Set<JavaInfo>> entry : this.m_keyToComponents.entrySet()) {
            String key = entry.getKey();
            Set<JavaInfo> components = entry.getValue();
            HashSet<JavaInfo> componentsCopy = new HashSet<JavaInfo>(components);
            copy.m_keyToComponents.put(key, componentsCopy);
        }
        return copy;
    }

    public Set<JavaInfo> getComponentsByKey(String key) {
        Set<JavaInfo> components = this.m_keyToComponents.get(key);
        if (components != null) {
            return components;
        }
        return Collections.emptySet();
    }

    public void add(JavaInfo component, String key) {
        Set components = this.m_keyToComponents.get(key);
        if (components == null) {
            components = Sets.newHashSet();
            this.m_keyToComponents.put(key, components);
        }
        components.add(component);
    }

    public void rename(String oldKey, String newKey) {
        Set<JavaInfo> sourceComponents = this.m_keyToComponents.remove(oldKey);
        if (sourceComponents != null) {
            Set<JavaInfo> targetComponents = this.m_keyToComponents.get(newKey);
            if (targetComponents == null) {
                this.m_keyToComponents.put(newKey, sourceComponents);
            } else {
                targetComponents.addAll(sourceComponents);
            }
        }
    }

    public void remove(String key) {
        this.m_keyToComponents.remove(key);
    }

    public void remove(JavaInfo component, String key) {
        Set<JavaInfo> components = this.m_keyToComponents.get(key);
        components.remove((Object)component);
    }
}

