/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.CoreNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTree;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    @NonNull
    private final String ssid;
    private final HistoryTree sht;
    private volatile boolean fFinishedBuilding = false;

    protected boolean isFinishedBuilding() {
        return this.fFinishedBuilding;
    }

    protected void setFinishedBuilding(boolean isFinishedBuilding) {
        this.fFinishedBuilding = isFinishedBuilding;
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime, int blockSize, int maxChildren) throws IOException {
        this.ssid = ssid;
        HTConfig conf = new HTConfig(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.sht = new HistoryTree(conf);
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime) throws IOException {
        this(ssid, newStateFile, providerVersion, startTime, 65536, 50);
    }

    public HistoryTreeBackend(@NonNull String ssid, File existingStateFile, int providerVersion) throws IOException {
        this.ssid = ssid;
        this.sht = new HistoryTree(existingStateFile, providerVersion);
        this.fFinishedBuilding = true;
    }

    protected HistoryTree getSHT() {
        return this.sht;
    }

    @Override
    public String getSSID() {
        return this.ssid;
    }

    @Override
    public long getStartTime() {
        return this.sht.getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.sht.getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        this.sht.insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.sht.closeTree(endTime);
        this.fFinishedBuilding = true;
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.sht.supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.sht.supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.sht.supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.sht.deleteFile();
    }

    @Override
    public void dispose() {
        if (this.fFinishedBuilding) {
            this.sht.closeFile();
        } else {
            this.sht.deleteFile();
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        HTNode currentNode = this.sht.getRootNode();
        currentNode.writeInfoFromNode(stateInfo, t);
        try {
            while (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.sht.selectNextChild((CoreNode)currentNode, t);
                currentNode.writeInfoFromNode(stateInfo, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        return this.getRelevantInterval(t, attributeQuark);
    }

    private void checkValidTime(long t) {
        long treeStart = this.sht.getTreeStart();
        long treeEnd = this.sht.getTreeEnd();
        if (t < treeStart || t > treeEnd) {
            throw new TimeRangeException(String.valueOf(this.ssid) + " Time:" + t + ", Start:" + treeStart + ", End:" + treeEnd);
        }
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        HTNode currentNode = this.sht.getRootNode();
        HTInterval interval = currentNode.getRelevantInterval(key, t);
        try {
            while (interval == null && currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.sht.selectNextChild((CoreNode)currentNode, t);
                interval = currentNode.getRelevantInterval(key, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
        return interval;
    }

    public long getFileSize() {
        return this.sht.getFileSize();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.sht.getNodeCount()) {
                HTNode node = this.sht.readNode(seq);
                total += node.getNodeUsagePercent();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        long ret = total / (long)this.sht.getNodeCount();
        assert (ret >= 0L && ret <= 100L);
        return (int)ret;
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        this.debugPrint(writer, false);
    }

    public void debugPrint(PrintWriter writer, boolean printIntervals) {
        writer.println("------------------------------");
        writer.println("State History Tree:\n");
        writer.println(this.sht.toString());
        writer.println("Average node utilization: " + this.getAverageNodeUsage());
        writer.println("");
        this.sht.debugPrintFullTree(writer, printIntervals);
    }
}

