/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;

public class RepositoryMapping {
    private final String containerPathString;
    private IPath containerPath;
    private final String gitDirPathString;
    private IPath gitDirPath;
    private IPath gitDirAbsolutePath;
    private Repository db;
    private String workdirPrefix;
    private IContainer container;
    private final RepositoryCache repositoryCache = Activator.getDefault().getRepositoryCache();

    static boolean isInitialKey(String key) {
        return key.endsWith(".gitdir");
    }

    public RepositoryMapping(@NonNull Properties p, @NonNull String initialKey) {
        int dot = initialKey.lastIndexOf(46);
        this.containerPathString = initialKey.substring(0, dot);
        this.gitDirPathString = p.getProperty(initialKey);
    }

    @Nullable
    public static RepositoryMapping create(@NonNull IContainer mappedContainer, @NonNull File gitDir) {
        IPath location = mappedContainer.getLocation();
        if (location == null) {
            return null;
        }
        return new RepositoryMapping(mappedContainer, location, gitDir);
    }

    private RepositoryMapping(@NonNull IContainer mappedContainer, @NonNull IPath location, @NonNull File gitDir) {
        IPath cLoc = location.removeTrailingSeparator();
        IPath gLoc = Path.fromOSString((String)gitDir.getAbsolutePath()).removeTrailingSeparator();
        IPath gLocParent = gLoc.removeLastSegments(1);
        this.container = mappedContainer;
        this.containerPathString = this.container.getProjectRelativePath().toPortableString();
        if (cLoc.isPrefixOf(gLoc)) {
            int matchingSegments = gLoc.matchingFirstSegments(cLoc);
            IPath remainder = gLoc.removeFirstSegments(matchingSegments);
            String device = remainder.getDevice();
            this.gitDirPathString = device == null ? remainder.toPortableString() : remainder.toPortableString().substring(device.length());
        } else if (gLocParent.isPrefixOf(cLoc)) {
            int cnt = cLoc.segmentCount() - cLoc.matchingFirstSegments(gLocParent);
            StringBuilder p = new StringBuilder("");
            while (cnt-- > 0) {
                p.append("../");
            }
            p.append(gLoc.segment(gLoc.segmentCount() - 1));
            this.gitDirPathString = p.toString();
        } else {
            this.gitDirPathString = gLoc.toPortableString();
        }
    }

    @NonNull
    public IPath getContainerPath() {
        if (this.containerPath == null) {
            this.containerPath = Path.fromPortableString((String)this.containerPathString);
        }
        return this.containerPath;
    }

    @NonNull
    IPath getGitDirPath() {
        if (this.gitDirPath == null) {
            this.gitDirPath = Path.fromPortableString((String)this.gitDirPathString);
        }
        return this.gitDirPath;
    }

    @Nullable
    public File getWorkTree() {
        Repository repo = this.getRepository();
        if (repo.isBare()) {
            return null;
        }
        return repo.getWorkTree();
    }

    synchronized void clear() {
        this.db = null;
        this.workdirPrefix = null;
        this.container = null;
    }

    public synchronized Repository getRepository() {
        return this.db;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public synchronized Repository getSubmoduleRepository(@NonNull IResource res) {
        IPath projectRelativePath = res.getProjectRelativePath();
        if (projectRelativePath == null) {
            return null;
        }
        String projectRelativePathStr = res.getProjectRelativePath().toString();
        try {
            if (this.db.isBare()) return this.db;
            if (!SubmoduleWalk.containsGitModulesFile((Repository)this.db)) return this.db;
            SubmoduleWalk sw = SubmoduleWalk.forIndex((Repository)this.db);
            do {
                if (sw.next()) continue;
                return this.db;
            } while (!projectRelativePathStr.startsWith(sw.getPath()));
            Repository subRepo = sw.getRepository();
            if (subRepo == null) {
                return null;
            }
            Repository cachedRepo = null;
            try {
                cachedRepo = this.repositoryCache.lookupRepository(subRepo.getDirectory());
                return cachedRepo;
            }
            finally {
                subRepo.close();
            }
        }
        catch (IOException e) {
            Activator.logWarning(CoreText.RepositoryMapping_ExceptionSubmoduleWalk, e);
        }
        return this.db;
    }

    synchronized void setRepository(Repository r) {
        this.db = r;
        File workTree = this.getWorkTree();
        if (workTree == null) {
            return;
        }
        this.workdirPrefix = workTree.getAbsolutePath();
        this.workdirPrefix = this.workdirPrefix.replace('\\', '/');
        if (!this.workdirPrefix.endsWith("/")) {
            this.workdirPrefix = String.valueOf(this.workdirPrefix) + "/";
        }
    }

    public synchronized IContainer getContainer() {
        return this.container;
    }

    synchronized void setContainer(IContainer c) {
        this.container = c;
    }

    public void fireRepositoryChanged() {
        GitProjectData.fireRepositoryChanged(this);
    }

    synchronized void store(Properties p) {
        p.setProperty(String.valueOf(this.containerPathString) + ".gitdir", this.gitDirPathString);
    }

    public String toString() {
        IPath absolutePath = this.getGitDirAbsolutePath();
        return "RepositoryMapping[" + this.format(this.containerPathString) + " -> '" + this.format(this.gitDirPathString) + "', absolute path: '" + this.format(absolutePath) + "' ]";
    }

    private String format(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (o.toString().length() == 0) {
            return "<empty>";
        }
        return o.toString();
    }

    @Nullable
    public String getRepoRelativePath(@NonNull IResource rsrc) {
        IPath location = rsrc.getLocation();
        if (location == null) {
            return null;
        }
        return this.getRepoRelativePath(location);
    }

    @Nullable
    public synchronized String getRepoRelativePath(@NonNull IPath location) {
        if (this.workdirPrefix == null) {
            return null;
        }
        int pfxLen = this.workdirPrefix.length();
        String p = location.toString();
        int pLen = p.length();
        if (pLen > pfxLen) {
            return p.substring(pfxLen);
        }
        if (pLen == pfxLen - 1) {
            return "";
        }
        return null;
    }

    @Nullable
    public static RepositoryMapping getMapping(@NonNull IResource resource) {
        if (ResourceUtil.isNonWorkspace(resource)) {
            return null;
        }
        if (resource.isLinked(512)) {
            IPath location = resource.getLocation();
            if (location == null) {
                return null;
            }
            return RepositoryMapping.getMapping(location);
        }
        return RepositoryMapping.getMapping(resource.getProject());
    }

    @Nullable
    public static RepositoryMapping getMapping(@Nullable IProject project) {
        GitProjectData data;
        if (project == null || ResourceUtil.isNonWorkspace((IResource)project)) {
            return null;
        }
        GitProvider rp = ResourceUtil.getGitProvider(project);
        if (rp == null) {
            data = GitProjectData.get(project);
            if (data == null) {
                return null;
            }
        } else {
            data = rp.getData();
        }
        if (data == null) {
            return null;
        }
        return data.getRepositoryMapping((IResource)project);
    }

    @Nullable
    public static RepositoryMapping getMapping(@NonNull IPath path) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Path bestWorkingTree = null;
        RepositoryMapping bestMapping = null;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            Path workingTree;
            File workTree;
            RepositoryMapping mapping;
            IProject project = iProjectArray[n2];
            if (!ResourceUtil.isNonWorkspace((IResource)project) && (mapping = RepositoryMapping.getMapping(project)) != null && (workTree = mapping.getWorkTree()) != null && (workingTree = new Path(workTree.toString())).isPrefixOf(path) && (bestWorkingTree == null || workingTree.segmentCount() > bestWorkingTree.segmentCount())) {
                bestWorkingTree = workingTree;
                bestMapping = mapping;
            }
            ++n2;
        }
        return bestMapping;
    }

    @Nullable
    public static RepositoryMapping findRepositoryMapping(@NonNull Repository repository) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping(project);
            if (mapping != null && mapping.getRepository() == repository) {
                return mapping;
            }
            ++n2;
        }
        return null;
    }

    public String getGitDir() {
        return this.gitDirPathString;
    }

    @Nullable
    public synchronized IPath getGitDirAbsolutePath() {
        if (this.gitDirAbsolutePath == null) {
            IPath cloc;
            IPath p = this.getGitDirPath();
            if (p.isAbsolute()) {
                this.gitDirAbsolutePath = p;
            } else if (this.container != null && (cloc = this.container.getLocation()) != null) {
                this.gitDirAbsolutePath = cloc.append(p);
            }
        }
        return this.gitDirAbsolutePath;
    }
}

