/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.ArrayList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.UstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.UstProviderPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class UstProviderComponent
extends TraceControlComponent {
    public static final String USTL_PROVIDER_ICON_FILE = "icons/obj16/targets.gif";
    private IUstProviderInfo fProviderInfo = null;

    public UstProviderComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(USTL_PROVIDER_ICON_FILE);
        this.setToolTip(Messages.TraceControl_ProviderDisplayName);
        this.fProviderInfo = new UstProviderInfo(name);
    }

    public void setUstProvider(IUstProviderInfo providerInfo) {
        this.fProviderInfo = providerInfo;
        IBaseEventInfo[] events = providerInfo.getEvents();
        ArrayList<ITraceControlComponent> eventComponents = new ArrayList<ITraceControlComponent>();
        int i = 0;
        while (i < events.length) {
            BaseEventComponent component = new BaseEventComponent(events[i].getName(), this);
            component.setEventInfo(events[i]);
            eventComponents.add(component);
            ++i;
        }
        this.setChildren(eventComponents);
        this.setName(String.valueOf(this.getName()) + " [PID=" + this.fProviderInfo.getPid() + "]");
    }

    public int getPid() {
        return this.fProviderInfo.getPid();
    }

    public void setPid(int pid) {
        this.fProviderInfo.setPid(pid);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new UstProviderPropertySource(this);
        }
        return null;
    }
}

