/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.IMoveToAddress;
import org.eclipse.cdt.debug.core.model.IMoveToLine;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class MoveToLine
implements IMoveToLine,
IMoveToAddress {
    private final IRunControl.IExecutionDMContext fContext;

    public MoveToLine(IRunControl.IExecutionDMContext context) {
        this.fContext = context;
    }

    public boolean canMoveToLine(final String fileName, final int lineNumber) {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            try {
                Query<Boolean> query = new Query<Boolean>(){

                    protected void execute(DataRequestMonitor<Boolean> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), MoveToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.canMoveToLine(MoveToLine.this.fContext, fileName, lineNumber, false, rm);
                        } else {
                            rm.setData((Object)false);
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                return (Boolean)query.get();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return false;
    }

    public void moveToLine(final String fileName, final int lineNumber) throws DebugException {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            Exception exception = null;
            try {
                Query<Object> query = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), MoveToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.moveToLine(MoveToLine.this.fContext, fileName, lineNumber, false, rm);
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "IRunControl2 service not available", null));
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                query.get();
            }
            catch (RejectedExecutionException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e;
            }
            if (exception != null) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Failed executing move to line", (Throwable)exception));
            }
        } else {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Debug session is not active", null));
        }
    }

    public boolean canMoveToAddress(final IAddress address) {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            try {
                Query<Boolean> query = new Query<Boolean>(){

                    protected void execute(DataRequestMonitor<Boolean> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), MoveToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.canMoveToAddress(MoveToLine.this.fContext, address, false, rm);
                        } else {
                            rm.setData((Object)false);
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                return (Boolean)query.get();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return false;
    }

    public void moveToAddress(final IAddress address) throws DebugException {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            Exception exception = null;
            try {
                Query<Object> query = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), MoveToLine.this.fContext.getSessionId());
                        IRunControl2 runControl = (IRunControl2)tracker.getService(IRunControl2.class);
                        if (runControl != null) {
                            runControl.moveToAddress(MoveToLine.this.fContext, address, false, rm);
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "IRunControl2 service not available", null));
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                query.get();
            }
            catch (RejectedExecutionException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e;
            }
            if (exception != null) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Failed executing move to line", (Throwable)exception));
            }
        } else {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Debug session is not active", null));
        }
    }
}

