/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractToolSettingUI;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionSettingsUI;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolSettingUI;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListContentProvider;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListElement;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListLabelProvider;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolSettingsPrefStore;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.PageLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class ToolSettingsTab
extends AbstractCBuildPropertyTab
implements IPreferencePageContainer {
    private static ToolListElement selectedElement;
    private TreeViewer optionList;
    private StyledText tipText;
    private StyleRange styleRange;
    private SashForm sashForm;
    private SashForm sashForm2;
    private Composite settingsPageContainer;
    private ScrolledComposite containerSC;
    private Map<String, List<AbstractToolSettingUI>> configToPageListMap;
    private IPreferenceStore settingsStore;
    private AbstractToolSettingUI currentSettingsPage;
    private ToolListContentProvider listprovider;
    private Object propertyObject;
    private IResourceInfo fInfo;
    private boolean displayFixedTip = CDTPrefUtil.getBool((String)"properties.option.tipbox.enable");
    private int[] defaultWeights = new int[]{4, 1};
    private int[] hideTipBoxWeights;

    public ToolSettingsTab() {
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.hideTipBoxWeights = nArray;
    }

    public void createControls(Composite par) {
        super.createControls(par);
        this.usercomp.setLayout((Layout)new GridLayout());
        this.configToPageListMap = new HashMap<String, List<AbstractToolSettingUI>>();
        this.settingsStore = ToolSettingsPrefStore.getDefault();
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        this.sashForm.setLayout((Layout)layout);
        if (!this.displayFixedTip) {
            this.createSelectionArea((Composite)this.sashForm);
            this.createEditArea((Composite)this.sashForm);
        } else {
            this.createSelectionArea((Composite)this.sashForm);
            this.sashForm2 = new SashForm((Composite)this.sashForm, 0);
            this.sashForm2.setOrientation(512);
            this.createEditArea((Composite)this.sashForm2);
            this.createTipArea((Composite)this.sashForm2);
            this.sashForm2.setWeights(this.defaultWeights);
        }
        this.usercomp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ToolSettingsTab.this.specificResize();
            }
        });
        this.propertyObject = this.page.getElement();
        this.setValues();
        this.specificResize();
    }

    private void specificResize() {
        Point p1 = this.optionList.getTree().computeSize(-1, -1);
        Point p2 = this.optionList.getTree().getSize();
        Point p3 = this.usercomp.getSize();
        p1.x += this.calcExtra();
        if (p3.x >= p1.x && (p1.x < p2.x || p2.x * 2 < p3.x)) {
            this.optionList.getTree().setSize(p1.x, p2.y);
            this.sashForm.setWeights(new int[]{p1.x, p3.x - p1.x});
        }
    }

    private int calcExtra() {
        int x = this.optionList.getTree().getBorderWidth() * 2;
        ScrollBar sb = this.optionList.getTree().getVerticalBar();
        if (sb != null && sb.isVisible()) {
            x += sb.getSize().x;
        }
        return x;
    }

    protected void createSelectionArea(Composite parent) {
        this.optionList = new TreeViewer(parent, 2820);
        this.optionList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ToolSettingsTab.this.handleOptionSelection();
            }
        });
        this.optionList.getControl().setLayoutData((Object)new GridData(1808));
        this.optionList.setLabelProvider((IBaseLabelProvider)new ToolListLabelProvider());
        this.optionList.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (parent instanceof IResourceConfiguration && element instanceof ITool) {
                    return !((ITool)element).getCustomBuildStep();
                }
                return true;
            }
        });
    }

    protected void updateTipText(String name, String tip) {
        if (this.tipText == null) {
            return;
        }
        this.tipText.setText(String.valueOf(name) + "\n\n" + tip);
        this.styleRange.length = name.length();
        this.tipText.setStyleRange(this.styleRange);
        this.tipText.update();
    }

    private void resetTipText() {
        if (this.tipText == null) {
            return;
        }
        this.tipText.setText(Messages.ToolSettingsTab_0);
        this.tipText.update();
    }

    private void displayOptionsForCategory(ToolListElement toolListElement) {
        selectedElement = toolListElement;
        IOptionCategory category = toolListElement.getOptionCategory();
        IHoldsOptions optionHolder = toolListElement.getHoldOptions();
        AbstractToolSettingUI oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List<AbstractToolSettingUI> pages = this.getPagesForConfig();
        for (AbstractToolSettingUI page : pages) {
            if (!page.isFor(optionHolder, category)) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = new BuildOptionSettingsUI(this, this.fInfo, optionHolder, category, this.displayFixedTip);
            boolean needToolTipBox = false;
            if (this.displayFixedTip) {
                needToolTipBox = ((BuildOptionSettingsUI)this.currentSettingsPage).needToolTipBox(optionHolder, category);
            }
            pages.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            this.currentSettingsPage.setToolTipBoxNeeded(needToolTipBox);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element != currentControl) {
                element.setVisible(false);
            }
            ++n2;
        }
        if (this.displayFixedTip) {
            if (!this.currentSettingsPage.isToolTipBoxNeeded()) {
                this.sashForm2.setWeights(this.hideTipBoxWeights);
                this.sashForm2.layout();
            } else {
                this.sashForm2.setWeights(this.defaultWeights);
                this.sashForm2.layout();
            }
        }
        this.currentSettingsPage.setVisible(true);
        this.currentSettingsPage.updateFields();
        if (oldPage != null && oldPage != this.currentSettingsPage) {
            oldPage.setVisible(false);
            this.resetTipText();
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private void displayOptionsForTool(ToolListElement toolListElement) {
        selectedElement = toolListElement;
        ITool tool = toolListElement.getTool();
        AbstractToolSettingUI oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List<AbstractToolSettingUI> pages = this.getPagesForConfig();
        for (AbstractToolSettingUI page : pages) {
            if (!page.isFor(tool, null)) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = new BuildToolSettingUI(this, this.fInfo, tool);
            pages.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element != currentControl) {
                element.setVisible(false);
            }
            ++n2;
        }
        if (this.displayFixedTip) {
            this.sashForm2.setWeights(this.hideTipBoxWeights);
            this.sashForm2.layout();
        }
        this.currentSettingsPage.setVisible(true);
        if (oldPage != null && oldPage != this.currentSettingsPage) {
            oldPage.storeSettings();
        }
        this.currentSettingsPage.setValues();
        if (oldPage != null && oldPage != this.currentSettingsPage) {
            oldPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private void createTipArea(Composite parent) {
        Font font;
        this.tipText = new StyledText(parent, 2634);
        this.tipText.setLayoutData((Object)new GridData(1808));
        this.tipText.setText(Messages.ToolSettingsTab_0);
        this.styleRange = new StyleRange();
        this.styleRange.start = 0;
        FontData data = new FontData();
        data.setHeight(10);
        data.setStyle(1);
        this.styleRange.font = font = new Font((Device)parent.getDisplay(), data);
    }

    protected void createEditArea(Composite parent) {
        int style = 768;
        if (this.displayFixedTip) {
            style |= 0x800;
        }
        this.containerSC = new ScrolledComposite(parent, style);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new PageLayout());
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.containerSC.setMinSize(this.settingsPageContainer.computeSize(-1, -1));
        this.settingsPageContainer.layout();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateData(this.page.getResDesc());
        }
        super.setVisible(visible);
    }

    protected void setValues() {
        if (this.listprovider == null) {
            IResource resource = (IResource)this.propertyObject;
            this.listprovider = new ToolListContentProvider(resource.getType());
            this.optionList.setContentProvider((IContentProvider)this.listprovider);
        }
        this.optionList.setInput((Object)this.fInfo);
        ToolListElement[] newElements = (ToolListElement[])this.listprovider.getElements(this.fInfo);
        this.optionList.expandAll();
        ITool primaryObject = null;
        if (selectedElement != null && newElements != null) {
            selectedElement = this.matchSelectionElement(selectedElement, newElements);
        }
        if (selectedElement == null) {
            ToolListElement toolListElement = selectedElement = newElements != null && newElements.length > 0 ? newElements[0] : null;
        }
        if (selectedElement != null) {
            primaryObject = selectedElement.getTool();
            if (primaryObject == null) {
                primaryObject = selectedElement.getOptionCategory();
            }
            if (primaryObject != null) {
                if (primaryObject instanceof IOptionCategory) {
                    ((ToolSettingsPrefStore)this.settingsStore).setSelection(this.getResDesc(), selectedElement, (IOptionCategory)primaryObject);
                }
                this.optionList.setSelection((ISelection)new StructuredSelection((Object)selectedElement), true);
            }
        }
    }

    private ToolListElement matchSelectionElement(ToolListElement currentElement, ToolListElement[] elements) {
        ToolListElement match = this.exactMatchSelectionElement(currentElement, elements);
        if (match == null) {
            match = this.equivalentMatchSelectionElement(currentElement, elements);
        }
        return match;
    }

    private ToolListElement exactMatchSelectionElement(ToolListElement currentElement, ToolListElement[] elements) {
        ToolListElement[] toolListElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ToolListElement e = toolListElementArray[n2];
            if (e == currentElement) {
                return currentElement;
            }
            if ((e = this.exactMatchSelectionElement(currentElement, e.getChildElements())) != null) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    private ToolListElement equivalentMatchSelectionElement(ToolListElement currentElement, ToolListElement[] elements) {
        ToolListElement[] toolListElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ToolListElement e = toolListElementArray[n2];
            if (e.isEquivalentTo(currentElement)) {
                return e;
            }
            if ((e = this.equivalentMatchSelectionElement(currentElement, e.getChildElements())) != null) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    private void handleOptionSelection() {
        if (this.optionList == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.optionList.getSelection();
        ToolListElement toolListElement = (ToolListElement)selection.getFirstElement();
        if (toolListElement != null) {
            IOptionCategory cat = toolListElement.getOptionCategory();
            if (cat == null) {
                cat = (IOptionCategory)toolListElement.getTool();
            }
            if (cat != null) {
                ((ToolSettingsPrefStore)this.settingsStore).setSelection(this.getResDesc(), toolListElement, cat);
            }
            if ((cat = toolListElement.getOptionCategory()) != null) {
                this.displayOptionsForCategory(toolListElement);
            } else {
                this.displayOptionsForTool(toolListElement);
            }
        }
    }

    protected void performDefaults() {
        if (this.page.isForProject()) {
            ManagedBuildManager.resetConfiguration((IProject)this.page.getProject(), (IConfiguration)this.getCfg());
        } else {
            ManagedBuildManager.resetOptionSettings((IResourceInfo)this.fInfo);
        }
        ITool[] tools = this.page.isForProject() ? this.getCfg().getFilteredTools() : this.getResCfg(this.getResDesc()).getTools();
        int i = 0;
        while (i < tools.length) {
            if (!tools[i].getCustomBuildStep()) {
                tools[i].setToolCommand(null);
                tools[i].setCommandLinePattern(null);
            }
            ++i;
        }
        selectedElement = null;
        this.setDirty(true);
        this.fInfo = this.getResCfg(this.getResDesc());
        this.setValues();
        this.handleOptionSelection();
    }

    private void copyHoldsOptions(IHoldsOptions src, IHoldsOptions dst, IResourceInfo res) {
        if (src instanceof ITool) {
            ITool t1 = (ITool)src;
            ITool t2 = (ITool)dst;
            if (t1.getCustomBuildStep()) {
                return;
            }
            t2.setToolCommand(t1.getToolCommand());
            t2.setCommandLinePattern(t1.getCommandLinePattern());
        }
        IOption[] op1 = src.getOptions();
        IOption[] op2 = dst.getOptions();
        int i = 0;
        while (i < op1.length) {
            this.setOption(op1[i], op2[i], dst, res);
            ++i;
        }
    }

    protected void addFilter(ViewerFilter filter) {
        this.optionList.addFilter(filter);
    }

    protected void setOption(IOption op1, IOption op2, IHoldsOptions dst, IResourceInfo res) {
        try {
            switch (op1.getValueType()) {
                case 0: {
                    boolean boolVal = op1.getBooleanValue();
                    ManagedBuildManager.setOption((IResourceInfo)res, (IHoldsOptions)dst, (IOption)op2, (boolean)boolVal);
                    break;
                }
                case 1: 
                case 12: {
                    String enumVal = op1.getStringValue();
                    String enumId = op1.getId(enumVal);
                    String out = enumId != null && enumId.length() > 0 ? enumId : enumVal;
                    ManagedBuildManager.setOption((IResourceInfo)res, (IHoldsOptions)dst, (IOption)op2, (String)out);
                    break;
                }
                case 2: {
                    ManagedBuildManager.setOption((IResourceInfo)res, (IHoldsOptions)dst, (IOption)op2, (String)op1.getStringValue());
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    String[] data = ((List)op1.getValue()).toArray(new String[0]);
                    ManagedBuildManager.setOption((IResourceInfo)res, (IHoldsOptions)dst, (IOption)op2, (String[])data);
                    break;
                }
            }
        }
        catch (BuildException buildException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected boolean containsDefaults() {
        ITool[] tools;
        IConfiguration parentCfg = this.fInfo.getParent().getParent();
        ITool[] iToolArray = tools = this.fInfo.getParent().getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (!tool.getCustomBuildStep()) {
                IOption[] options;
                ITool cfgTool = parentCfg.getToolChain().getTool(tool.getSuperClass().getId());
                if (cfgTool != null) {
                    if (!tool.getToolCommand().equals(cfgTool.getToolCommand())) {
                        return false;
                    }
                    if (!tool.getCommandLinePattern().equals(cfgTool.getCommandLinePattern())) {
                        return false;
                    }
                }
                IOption[] iOptionArray = options = tool.getOptions();
                int n3 = options.length;
                int n4 = 0;
                while (n4 < n3) {
                    block12: {
                        IOption option = iOptionArray[n4];
                        if (option.getParent() == tool) {
                            block11: {
                                IOption ext = option;
                                while (!ext.isExtensionElement() && (ext = ext.getSuperClass()) != null) {
                                }
                                if (ext != null && cfgTool != null) {
                                    IOption defaultOpt = cfgTool.getOptionBySuperClassId(ext.getId());
                                    try {
                                        Object defaultVal;
                                        Object value;
                                        if (defaultOpt == null || defaultOpt.getValueType() != option.getValueType() || !(value = option.getValue()).equals(defaultVal = defaultOpt.getValue())) break block11;
                                        break block12;
                                    }
                                    catch (BuildException buildException) {
                                        // empty catch block
                                    }
                                }
                            }
                            return false;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return true;
    }

    private List<AbstractToolSettingUI> getPagesForConfig() {
        if (this.getCfg() == null) {
            return null;
        }
        List<AbstractToolSettingUI> pages = this.configToPageListMap.get(this.getCfg().getId());
        if (pages == null) {
            pages = new ArrayList<AbstractToolSettingUI>();
            this.configToPageListMap.put(this.getCfg().getId(), pages);
        }
        return pages;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.settingsStore;
    }

    public void setDirty(boolean b) {
        List<AbstractToolSettingUI> pages = this.getPagesForConfig();
        if (pages == null) {
            return;
        }
        for (AbstractToolSettingUI page : pages) {
            if (page == null) continue;
            page.setDirty(b);
        }
    }

    public boolean isDirty() {
        List<AbstractToolSettingUI> pages = this.getPagesForConfig();
        if (pages == null) {
            return false;
        }
        for (AbstractToolSettingUI page : pages) {
            if (page == null || !page.isDirty()) continue;
            return true;
        }
        return false;
    }

    public BuildMacroProvider obtainMacroProvider() {
        return (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
    }

    public void updateData(ICResourceDescription cfgd) {
        this.fInfo = this.getResCfg(cfgd);
        this.setValues();
        this.specificResize();
        this.handleOptionSelection();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        ITool[] t2;
        ITool[] t1;
        IResourceInfo ri1 = this.getResCfg(src);
        IResourceInfo ri2 = this.getResCfg(dst);
        this.copyHoldsOptions((IHoldsOptions)ri1.getParent().getToolChain(), (IHoldsOptions)ri2.getParent().getToolChain(), ri2);
        if (ri1 instanceof IFolderInfo) {
            t1 = ((IFolderInfo)ri1).getFilteredTools();
            t2 = ((IFolderInfo)ri2).getFilteredTools();
        } else if (ri1 instanceof IFileInfo) {
            t1 = ((IFileInfo)ri1).getToolsToInvoke();
            t2 = ((IFileInfo)ri2).getToolsToInvoke();
        } else {
            return;
        }
        for (Map.Entry<ITool, ITool> pair : this.getToolCorrespondence(t1, t2).entrySet()) {
            this.copyHoldsOptions((IHoldsOptions)pair.getKey(), (IHoldsOptions)pair.getValue(), ri2);
        }
        this.setDirty(false);
        this.updateData(this.getResDesc());
    }

    private Map<ITool, ITool> getToolCorrespondence(ITool[] t1, ITool[] t2) {
        ITool real;
        ITool next;
        LinkedHashMap<ITool, ITool> result = new LinkedHashMap<ITool, ITool>();
        LinkedHashMap<ITool, List<ITool>> realT1Tools = new LinkedHashMap<ITool, List<ITool>>();
        ITool[] iToolArray = t1;
        int n = t1.length;
        int n2 = 0;
        while (n2 < n) {
            next = iToolArray[n2];
            real = ManagedBuildManager.getRealTool((ITool)next);
            ArrayList<ITool> list = (ArrayList<ITool>)realT1Tools.get(real);
            if (list == null) {
                realT1Tools.put(real, Collections.singletonList(next));
            } else {
                if (list.size() == 1) {
                    list = new ArrayList<ITool>(list);
                    realT1Tools.put(real, list);
                }
                list.add(next);
            }
            ++n2;
        }
        iToolArray = t2;
        n = t2.length;
        n2 = 0;
        while (n2 < n) {
            next = iToolArray[n2];
            real = ManagedBuildManager.getRealTool((ITool)next);
            List correspondents = (List)realT1Tools.get(real);
            if (correspondents != null) {
                result.put((ITool)correspondents.get(0), next);
                if (correspondents.size() == 1) {
                    realT1Tools.remove(real);
                } else {
                    correspondents.remove(0);
                }
            }
            ++n2;
        }
        return result;
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    public boolean canBeVisible() {
        IConfiguration cfg = this.getCfg();
        if (cfg instanceof MultiConfiguration) {
            return ((MultiConfiguration)cfg).isManagedBuildOn();
        }
        return cfg.getBuilder().isManagedBuildOn();
    }
}

