/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.EventIterator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;

public class TimeGraphEntry
implements ITimeGraphEntry {
    private ITimeGraphEntry fParent = null;
    private final List<ITimeGraphEntry> fChildren = new CopyOnWriteArrayList<ITimeGraphEntry>();
    private String fName;
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    @NonNull
    private List<ITimeEvent> fEventList = new ArrayList<ITimeEvent>();
    @NonNull
    private List<ITimeEvent> fZoomedEventList = new ArrayList<ITimeEvent>();
    private Comparator<ITimeGraphEntry> fComparator;

    public TimeGraphEntry(String name, long startTime, long endTime) {
        this.fName = name;
        this.fStartTime = startTime;
        this.fEndTime = endTime;
    }

    @Override
    public ITimeGraphEntry getParent() {
        return this.fParent;
    }

    protected void setParent(TimeGraphEntry entry) {
        this.fParent = entry;
    }

    protected void setParent(ITimeGraphEntry entry) {
        this.fParent = entry;
    }

    @Override
    public synchronized boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    @Override
    public synchronized List<? extends ITimeGraphEntry> getChildren() {
        return this.fChildren;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    public void updateEndTime(long endTime) {
        this.fEndTime = Math.max(endTime, this.fEndTime);
    }

    @Override
    public boolean hasTimeEvents() {
        return true;
    }

    public Iterator<ITimeEvent> getTimeEventsIterator() {
        if (this.hasTimeEvents()) {
            return new EventIterator(this.fEventList, this.fZoomedEventList);
        }
        return null;
    }

    public Iterator<ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
        if (!this.hasTimeEvents()) {
            return null;
        }
        return new EventIterator(this.fEventList, this.fZoomedEventList, startTime, stopTime);
    }

    public void addEvent(ITimeEvent event) {
        long start = event.getTime();
        long end = start + event.getDuration();
        int lastIndex = this.fEventList.size() - 1;
        if (lastIndex >= 0 && this.fEventList.get(lastIndex).getTime() == event.getTime()) {
            this.fEventList.set(lastIndex, event);
        } else {
            this.fEventList.add(event);
        }
        if (event instanceof NullTimeEvent) {
            return;
        }
        if (this.fStartTime == -1L || start < this.fStartTime) {
            this.fStartTime = start;
        }
        if (this.fEndTime == -1L || end > this.fEndTime) {
            this.fEndTime = end;
        }
    }

    public void setEventList(List<ITimeEvent> eventList) {
        this.fEventList = eventList != null ? eventList : new ArrayList<ITimeEvent>();
    }

    public void setZoomedEventList(List<ITimeEvent> eventList) {
        this.fZoomedEventList = eventList != null ? eventList : new ArrayList<ITimeEvent>();
    }

    public void addZoomedEvent(ITimeEvent event) {
        long lastStart;
        long start = event.getTime();
        long end = start + event.getDuration();
        int lastIndex = this.fZoomedEventList.size() - 1;
        long l = lastStart = lastIndex >= 0 ? this.fZoomedEventList.get(lastIndex).getTime() : Long.MIN_VALUE;
        if (start > lastStart) {
            this.fZoomedEventList.add(event);
        } else if (start == lastStart) {
            this.fZoomedEventList.set(lastIndex, event);
        }
        if (event instanceof NullTimeEvent) {
            return;
        }
        if (this.fStartTime == -1L || start < this.fStartTime) {
            this.fStartTime = start;
        }
        if (this.fEndTime == -1L || end > this.fEndTime) {
            this.fEndTime = end;
        }
    }

    public synchronized void addChild(TimeGraphEntry child) {
        this.addChild((ITimeGraphEntry)child);
    }

    public synchronized void addChild(ITimeGraphEntry child) {
        if (child instanceof TimeGraphEntry) {
            ((TimeGraphEntry)child).fParent = this;
        }
        if (this.fComparator == null) {
            this.fChildren.add(child);
        } else {
            int i = 0;
            while (i < this.fChildren.size()) {
                ITimeGraphEntry entry = this.fChildren.get(i);
                if (this.fComparator.compare(child, entry) < 0) break;
                ++i;
            }
            this.fChildren.add(i, child);
        }
    }

    public synchronized void addChild(int index, ITimeGraphEntry child) {
        if (child instanceof TimeGraphEntry) {
            ((TimeGraphEntry)child).fParent = this;
        }
        this.fChildren.add(index, child);
    }

    public synchronized void sortChildren(Comparator<ITimeGraphEntry> comparator) {
        this.fComparator = comparator;
        if (comparator == null) {
            return;
        }
        ITimeGraphEntry[] array = this.fChildren.toArray(new ITimeGraphEntry[0]);
        Arrays.sort(array, comparator);
        this.fChildren.clear();
        this.fChildren.addAll(Arrays.asList(array));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '(' + this.fName + ')';
    }
}

