/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class TimeEvent
implements ITimeEvent {
    protected ITimeGraphEntry fEntry;
    protected long fTime;
    protected long fDuration;
    private final int fValue;
    private static final int NOVALUE = Integer.MIN_VALUE;

    public TimeEvent(ITimeGraphEntry entry, long time, long duration) {
        this(entry, time, duration, Integer.MIN_VALUE);
    }

    public TimeEvent(ITimeGraphEntry entry, long time, long duration, int value) {
        this.fEntry = entry;
        this.fTime = time;
        this.fDuration = duration;
        this.fValue = value;
    }

    public int getValue() {
        return this.fValue;
    }

    public boolean hasValue() {
        return this.fValue != Integer.MIN_VALUE;
    }

    @Override
    public ITimeGraphEntry getEntry() {
        return this.fEntry;
    }

    @Override
    public long getTime() {
        return this.fTime;
    }

    @Override
    public long getDuration() {
        return this.fDuration;
    }

    @Override
    public ITimeEvent splitBefore(long splitTime) {
        return splitTime > this.fTime ? new TimeEvent(this.fEntry, this.fTime, Math.min(this.fDuration, splitTime - this.fTime), this.fValue) : null;
    }

    @Override
    public ITimeEvent splitAfter(long splitTime) {
        return splitTime < this.fTime + this.fDuration ? new TimeEvent(this.fEntry, Math.max(this.fTime, splitTime), this.fDuration - Math.max(0L, splitTime - this.fTime), this.fValue) : null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " start=" + this.fTime + " end=" + (this.fTime + this.fDuration) + " duration=" + this.fDuration + (this.hasValue() ? " value=" + this.fValue : "");
    }
}

