/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterDragSourceAdapter;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterDropTargetAdapter;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterTreeContentProvider;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterTreeLabelProvider;
import org.eclipse.ui.PlatformUI;

class FilterViewer
extends Composite {
    private TreeViewer fViewer;
    private Composite fComposite;
    private MenuManager fMenuManager;
    private boolean fIsDialog = false;

    public FilterViewer(Composite parent, int style) {
        this(parent, style, false);
    }

    public FilterViewer(Composite parent, int style, boolean isDialog) {
        super(parent, style);
        this.fIsDialog = isDialog;
        this.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
        SashForm sash = new SashForm((Composite)this, 256);
        this.fViewer = new TreeViewer((Composite)sash, 0);
        this.fViewer.setContentProvider((IContentProvider)new FilterTreeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new FilterTreeLabelProvider());
        this.fViewer.setInput((Object)new TmfFilterRootNode());
        this.fComposite = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fComposite.setLayout((Layout)gl);
        this.createContextMenu();
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ITmfFilterTreeNode node = (ITmfFilterTreeNode)selection.getFirstElement();
                    FilterViewer.this.updateFilterNodeComposite(node);
                    FilterViewer.this.highlightTreeItems(FilterViewer.this.fViewer.getTree().getSelection()[0].getItems());
                } else {
                    FilterViewer.this.updateFilterNodeComposite(null);
                }
            }
        });
        this.fViewer.getTree().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TmfFilterTreeNode root = (TmfFilterTreeNode)FilterViewer.this.fViewer.getInput();
                if (root == null || root.getChildrenCount() == 0) {
                    e.gc.setForeground(Display.getDefault().getSystemColor(2));
                    e.gc.drawText(Messages.FilterViewer_EmptyTreeHintText, 5, 0);
                }
            }
        });
        int operations = 3;
        DragSource dragSource = new DragSource((Control)this.fViewer.getTree(), operations);
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dragSource.addDragListener((DragSourceListener)new FilterDragSourceAdapter(this));
        DropTarget dropTarget = new DropTarget((Control)this.fViewer.getTree(), operations);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new FilterDropTargetAdapter(this));
    }

    private void createContextMenu() {
        this.fMenuManager = new MenuManager();
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FilterViewer.this.fillContextMenu(manager);
            }
        });
        Menu contextMenu = this.fMenuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(contextMenu);
    }

    public MenuManager getMenuManager() {
        return this.fMenuManager;
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITmfFilterTreeNode selectedNode;
        Object element;
        ISelection selection = this.fViewer.getSelection();
        ITmfFilterTreeNode filterTreeNode = null;
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfFilterTreeNode) {
            filterTreeNode = (ITmfFilterTreeNode)element;
        }
        if ((selectedNode = filterTreeNode) != null) {
            this.fillContextMenuForNode(selectedNode, manager);
        }
        manager.add((IContributionItem)new Separator("delete"));
        if (this.fIsDialog && selectedNode != null) {
            Action deleteAction = new Action(Messages.FilterViewer_DeleteActionText){

                public void run() {
                    selectedNode.remove();
                    FilterViewer.this.fViewer.refresh();
                }
            };
            deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            manager.add((IAction)deleteAction);
        }
        manager.add((IContributionItem)new Separator("edit"));
        if (this.fViewer.getInput() instanceof TmfFilterRootNode || filterTreeNode == null) {
            manager.add((IContributionItem)new Separator());
            ITmfFilterTreeNode root = (ITmfFilterTreeNode)this.fViewer.getInput();
            this.fillContextMenuForNode(root, manager);
        }
    }

    protected void fillContextMenuForNode(final ITmfFilterTreeNode node, IMenuManager manager) {
        for (final String child : node.getValidChildren()) {
            Action action = new Action(){

                public void run() {
                    TmfFilterNode newNode = null;
                    if ("FILTER".equals(child)) {
                        newNode = new TmfFilterNode(node, "");
                    } else if ("TRACETYPE".equals(child)) {
                        newNode = new TmfFilterTraceTypeNode(node);
                    } else if ("AND".equals(child)) {
                        newNode = new TmfFilterAndNode(node);
                    } else if ("OR".equals(child)) {
                        newNode = new TmfFilterOrNode(node);
                    } else if ("CONTAINS".equals(child)) {
                        newNode = new TmfFilterContainsNode(node);
                    } else if ("EQUALS".equals(child)) {
                        newNode = new TmfFilterEqualsNode(node);
                    } else if ("MATCHES".equals(child)) {
                        newNode = new TmfFilterMatchesNode(node);
                    } else if ("COMPARE".equals(child)) {
                        newNode = new TmfFilterCompareNode(node);
                    }
                    if (newNode != null) {
                        FilterViewer.this.fViewer.refresh();
                        FilterViewer.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newNode), true);
                    }
                }
            };
            if ("FILTER".equals(child)) {
                action.setText(String.valueOf(Messages.FilterViewer_NewPrefix) + " " + child);
            } else {
                action.setText(child);
            }
            manager.add((IAction)action);
        }
    }

    private void updateFilterNodeComposite(ITmfFilterTreeNode node) {
        Control[] controlArray = this.fComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (node instanceof TmfFilterNode) {
            new FilterNodeComposite(this.fComposite, (TmfFilterNode)node);
        } else if (node instanceof TmfFilterTraceTypeNode) {
            new FilterTraceTypeNodeComposite(this.fComposite, (TmfFilterTraceTypeNode)node);
        } else if (node instanceof TmfFilterAndNode) {
            new FilterAndNodeComposite(this.fComposite, (TmfFilterAndNode)node);
        } else if (node instanceof TmfFilterOrNode) {
            new FilterOrNodeComposite(this.fComposite, (TmfFilterOrNode)node);
        } else if (node instanceof TmfFilterContainsNode) {
            new FilterContainsNodeComposite(this.fComposite, (TmfFilterContainsNode)node);
        } else if (node instanceof TmfFilterEqualsNode) {
            new FilterEqualsNodeComposite(this.fComposite, (TmfFilterEqualsNode)node);
        } else if (node instanceof TmfFilterMatchesNode) {
            new FilterMatchesNodeComposite(this.fComposite, (TmfFilterMatchesNode)node);
        } else if (node instanceof TmfFilterCompareNode) {
            new FilterCompareNodeComposite(this.fComposite, (TmfFilterCompareNode)node);
        } else {
            new FilterBaseNodeComposite(this.fComposite);
        }
        this.fComposite.layout();
    }

    private void highlightTreeItems(TreeItem[] items) {
        this.resetTreeItems(this.fViewer.getTree().getItems());
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setForeground(Display.getCurrent().getSystemColor(9));
            ++n2;
        }
    }

    private void resetTreeItems(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setForeground(Display.getCurrent().getSystemColor(2));
            this.resetTreeItems(item.getItems());
            ++n2;
        }
    }

    public void setInput(ITmfFilterTreeNode root) {
        this.fViewer.setInput((Object)root);
        this.fViewer.expandAll();
        this.updateFilterNodeComposite(null);
    }

    public ITmfFilterTreeNode getInput() {
        return (ITmfFilterTreeNode)this.fViewer.getInput();
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void setSelection(ITmfFilterTreeNode node, boolean reveal) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), reveal);
    }

    public void setSelection(ITmfFilterTreeNode node) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node));
    }

    public ITmfFilterTreeNode getSelection() {
        Object element;
        ISelection selection = this.fViewer.getSelection();
        ITmfFilterTreeNode filterTreeNode = null;
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfFilterTreeNode) {
            filterTreeNode = (ITmfFilterTreeNode)element;
        }
        ITmfFilterTreeNode selectedNode = filterTreeNode;
        return selectedNode;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.removeSelectionChangedListener(listener);
    }

    public boolean setFocus() {
        return this.fViewer.getControl().setFocus();
    }

    public boolean isTreeInFocus() {
        return this.fViewer.getControl().isFocusControl();
    }

    TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    private static class AspectItem {
        public String label;
        public ITmfEventAspect eventAspect;
        public String traceTypeId;

        public AspectItem(String label) {
            this.label = label;
        }

        public AspectItem(String label, ITmfEventAspect eventAspect, String traceTypeId) {
            this.label = label;
            this.eventAspect = eventAspect;
            this.traceTypeId = traceTypeId;
        }
    }

    private class FilterAndNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterAndNode fNode;
        Button fNotButton;

        FilterAndNodeComposite(Composite parent, TmfFilterAndNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterAndNodeComposite.this.fNode.setNot(FilterAndNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterAndNodeComposite.this.fNode);
                }
            });
        }
    }

    private abstract class FilterAspectNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterAspectNode fAspectNode;
        Combo fTraceTypeCombo;
        Combo fAspectCombo;
        Label fFieldLabel;
        Text fFieldText;
        List<AspectItem> fAspectList;

        FilterAspectNodeComposite(Composite parent, TmfFilterAspectNode node) {
            super(parent);
            this.fAspectList = null;
            this.fAspectNode = node;
        }

        protected void createAspectControls() {
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_TypeLabel);
            final List<TraceTypeItem> traceTypeList = this.getTraceTypeList((ITmfFilterTreeNode)this.fAspectNode);
            this.fTraceTypeCombo = new Combo((Composite)this, 12);
            this.fTraceTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            for (TraceTypeItem traceType : traceTypeList) {
                this.fTraceTypeCombo.add(traceType.label);
            }
            if (this.fAspectNode.getTraceTypeId() == null) {
                this.fTraceTypeCombo.select(0);
                this.fAspectNode.setTraceTypeId(traceTypeList.get((int)0).traceTypeId);
            } else {
                int i = 0;
                while (i < traceTypeList.size()) {
                    TraceTypeItem traceType = traceTypeList.get(i);
                    if (this.fAspectNode.getTraceTypeId().equals(traceType.traceTypeId)) {
                        this.fTraceTypeCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.fTraceTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TraceTypeItem traceType = (TraceTypeItem)traceTypeList.get(FilterAspectNodeComposite.this.fTraceTypeCombo.getSelectionIndex());
                    FilterAspectNodeComposite.this.fAspectNode.setTraceTypeId(traceType.traceTypeId);
                    FilterAspectNodeComposite.this.fAspectList = FilterAspectNodeComposite.this.getAspectList(FilterAspectNodeComposite.this.fAspectNode.getTraceTypeId());
                    String text = FilterAspectNodeComposite.this.fAspectCombo.getText();
                    FilterAspectNodeComposite.this.fAspectCombo.removeAll();
                    for (AspectItem aspect : FilterAspectNodeComposite.this.fAspectList) {
                        FilterAspectNodeComposite.this.fAspectCombo.add(aspect.label);
                    }
                    int index = Arrays.asList(FilterAspectNodeComposite.this.fAspectCombo.getItems()).indexOf(text);
                    if (index >= 0 && !text.isEmpty()) {
                        FilterAspectNodeComposite.this.fAspectCombo.select(index);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterAspectNodeComposite.this.fAspectNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_AspectLabel);
            this.fAspectList = this.getAspectList(this.fAspectNode.getTraceTypeId());
            this.fAspectCombo = new Combo((Composite)this, 12);
            this.fAspectCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            for (AspectItem aspect : this.fAspectList) {
                this.fAspectCombo.add(aspect.label);
            }
            if (this.fAspectNode.getEventAspect() != null) {
                int i = 0;
                while (i < this.fAspectList.size()) {
                    AspectItem aspect = this.fAspectList.get(i);
                    if (aspect.eventAspect != null && this.fAspectNode.getEventAspect().getName().equals(aspect.eventAspect.getName()) && (this.fAspectNode.getTraceTypeId().equals(aspect.traceTypeId) || this.fAspectNode.getTraceTypeId().equals("BASE.ASPECT.ID"))) {
                        this.fAspectCombo.select(i);
                        if (!(this.fAspectNode.getEventAspect() instanceof TmfEventFieldAspect)) break;
                        aspect.eventAspect = this.fAspectNode.getEventAspect();
                        this.createFieldControls((TmfEventFieldAspect)this.fAspectNode.getEventAspect(), aspect);
                        break;
                    }
                    ++i;
                }
            }
            this.fAspectCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    int selection = FilterAspectNodeComposite.this.fAspectCombo.getSelectionIndex();
                    AspectItem aspect = null;
                    if (selection != -1) {
                        aspect = FilterAspectNodeComposite.this.fAspectList.get(FilterAspectNodeComposite.this.fAspectCombo.getSelectionIndex());
                        FilterAspectNodeComposite.this.fAspectNode.setEventAspect(aspect.eventAspect);
                    } else {
                        FilterAspectNodeComposite.this.fAspectNode.setEventAspect(null);
                    }
                    if (FilterAspectNodeComposite.this.fAspectNode.getEventAspect() instanceof TmfEventFieldAspect) {
                        TmfEventFieldAspect eventFieldAspect = (TmfEventFieldAspect)FilterAspectNodeComposite.this.fAspectNode.getEventAspect();
                        FilterAspectNodeComposite.this.createFieldControls(eventFieldAspect, aspect);
                        FilterAspectNodeComposite.this.layout();
                    } else if (FilterAspectNodeComposite.this.fFieldLabel != null && FilterAspectNodeComposite.this.fFieldText != null) {
                        FilterAspectNodeComposite.this.fFieldLabel.dispose();
                        FilterAspectNodeComposite.this.fFieldLabel = null;
                        FilterAspectNodeComposite.this.fFieldText.dispose();
                        FilterAspectNodeComposite.this.fFieldText = null;
                        FilterAspectNodeComposite.this.layout();
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterAspectNodeComposite.this.fAspectNode);
                }
            });
        }

        private void createFieldControls(final TmfEventFieldAspect eventFieldAspect, final AspectItem aspect) {
            if (this.fFieldLabel != null) {
                this.fFieldLabel.dispose();
            }
            this.fFieldLabel = new Label((Composite)this, 0);
            this.fFieldLabel.moveBelow((Control)this.fAspectCombo);
            this.fFieldLabel.setBackground(Display.getCurrent().getSystemColor(1));
            this.fFieldLabel.setText(Messages.FilterViewer_FieldLabel);
            if (this.fFieldText != null) {
                this.fFieldText.dispose();
            }
            this.fFieldText = new Text((Composite)this, 2048);
            this.fFieldText.moveBelow((Control)this.fFieldLabel);
            this.fFieldText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFieldText.setToolTipText(Messages.FilterViewer_Subfield_ToolTip);
            if (eventFieldAspect.getFieldPath() != null) {
                this.fFieldText.setText(eventFieldAspect.getFieldPath());
            }
            if (this.fFieldText.getText().length() == 0) {
                this.fFieldText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fFieldText.setText(Messages.FilterViewer_FieldHint);
            }
            this.fFieldText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterAspectNodeComposite.this.fFieldText.getText().length() == 0) {
                        FilterAspectNodeComposite.this.fFieldText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterAspectNodeComposite.this.fFieldText.setText(Messages.FilterViewer_FieldHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterAspectNodeComposite.this.fFieldText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterAspectNodeComposite.this.fFieldText.setText("");
                    }
                    FilterAspectNodeComposite.this.fFieldText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fFieldText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterAspectNodeComposite.this.fFieldText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        if (FilterAspectNodeComposite.this.fFieldText.getText().isEmpty()) {
                            FilterAspectNodeComposite.this.fAspectNode.setEventAspect((ITmfEventAspect)eventFieldAspect.forField(null));
                        } else {
                            FilterAspectNodeComposite.this.fAspectNode.setEventAspect((ITmfEventAspect)eventFieldAspect.forField(FilterAspectNodeComposite.this.fFieldText.getText()));
                        }
                        aspect.eventAspect = FilterAspectNodeComposite.this.fAspectNode.getEventAspect();
                        FilterViewer.this.fViewer.refresh((Object)FilterAspectNodeComposite.this.fAspectNode);
                    }
                }
            });
        }

        private List<TraceTypeItem> getTraceTypeList(ITmfFilterTreeNode node) {
            ArrayList<TraceTypeItem> traceTypeList = new ArrayList<TraceTypeItem>();
            traceTypeList.add(new TraceTypeItem(Messages.FilterViewer_CommonCategory, "BASE.ASPECT.ID"));
            ITmfFilterTreeNode curNode = node;
            while (curNode != null) {
                if (curNode instanceof TmfFilterTraceTypeNode) {
                    TmfFilterTraceTypeNode traceTypeNode = (TmfFilterTraceTypeNode)curNode;
                    TraceTypeHelper helper = TmfTraceType.getTraceType((String)traceTypeNode.getTraceTypeId());
                    if (helper != null) {
                        traceTypeList.set(0, new TraceTypeItem(helper.getLabel(), helper.getTraceTypeId()));
                    }
                    return traceTypeList;
                }
                curNode = curNode.getParent();
            }
            for (TraceTypeHelper helper : this.getTraceTypeMap().values()) {
                traceTypeList.add(new TraceTypeItem(helper.getLabel(), helper.getTraceTypeId()));
            }
            return traceTypeList;
        }

        private List<AspectItem> getAspectList(String traceTypeId) {
            ArrayList<AspectItem> aspectList = new ArrayList<AspectItem>();
            aspectList.add(new AspectItem(Messages.FilterViewer_CommonCategory));
            for (ITmfEventAspect aspect : ITmfEventAspect.BASE_ASPECTS) {
                aspectList.add(new AspectItem(aspect.getName(), aspect, "BASE.ASPECT.ID"));
            }
            TraceTypeHelper helper = TmfTraceType.getTraceType((String)traceTypeId);
            if (helper != null) {
                aspectList.add(new AspectItem(""));
                aspectList.add(new AspectItem(String.valueOf('[') + helper.getLabel() + ']'));
                for (ITmfEventAspect aspect : helper.getTrace().getEventAspects()) {
                    for (AspectItem baseAspect : aspectList) {
                        if (!aspect.equals(baseAspect.eventAspect)) continue;
                        aspectList.remove(baseAspect);
                        break;
                    }
                    aspectList.add(new AspectItem(aspect.getName(), aspect, helper.getTraceTypeId()));
                }
            }
            return aspectList;
        }
    }

    private class FilterBaseNodeComposite
    extends Composite {
        FilterBaseNodeComposite(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            this.setLayoutData(new GridData(4, 4, true, true));
            this.setBackground(Display.getCurrent().getSystemColor(1));
        }

        protected Map<String, TraceTypeHelper> getTraceTypeMap() {
            TreeMap<String, TraceTypeHelper> traceTypeMap = new TreeMap<String, TraceTypeHelper>();
            for (TraceTypeHelper helper : TmfTraceType.getTraceTypeHelpers()) {
                if (helper.isExperimentType()) continue;
                traceTypeMap.put(helper.getLabel(), helper);
            }
            return traceTypeMap;
        }
    }

    private class FilterCompareNodeComposite
    extends FilterAspectNodeComposite {
        TmfFilterCompareNode fNode;
        Button fNotButton;
        Text fValueText;
        Button fLTButton;
        Button fEQButton;
        Button fGTButton;
        Button fNumButton;
        Button fAlphaButton;
        Button fTimestampButton;

        FilterCompareNodeComposite(Composite parent, TmfFilterCompareNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterCompareNodeComposite.this.fNode.setNot(FilterCompareNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.createAspectControls();
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ResultLabel);
            Composite resultGroup = new Composite((Composite)this, 0);
            GridLayout rggl = new GridLayout(3, true);
            rggl.marginHeight = 0;
            rggl.marginWidth = 0;
            resultGroup.setLayout((Layout)rggl);
            resultGroup.setBackground(Display.getCurrent().getSystemColor(1));
            this.fLTButton = new Button(resultGroup, 16);
            this.fLTButton.setSelection(this.fNode.getResult() < 0);
            this.fLTButton.setText("<");
            this.fLTButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fLTButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fLTButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(-1);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fEQButton = new Button(resultGroup, 16);
            this.fEQButton.setSelection(this.fNode.getResult() == 0);
            this.fEQButton.setText("=");
            this.fEQButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fEQButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fEQButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(0);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fGTButton = new Button(resultGroup, 16);
            this.fGTButton.setSelection(this.fNode.getResult() > 0);
            this.fGTButton.setText(">");
            this.fGTButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fGTButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fGTButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(1);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_TypeLabel);
            Composite typeGroup = new Composite((Composite)this, 0);
            GridLayout tggl = new GridLayout(3, false);
            tggl.marginHeight = 0;
            tggl.marginWidth = 0;
            typeGroup.setLayout((Layout)tggl);
            typeGroup.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNumButton = new Button(typeGroup, 16);
            this.fNumButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.NUM);
            this.fNumButton.setText(Messages.FilterViewer_NumButtonText);
            this.fNumButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNumButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fNumButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.NUM);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fAlphaButton = new Button(typeGroup, 16);
            this.fAlphaButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.ALPHA);
            this.fAlphaButton.setText(Messages.FilterViewer_AlphaButtonText);
            this.fAlphaButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fAlphaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fAlphaButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.ALPHA);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fTimestampButton = new Button(typeGroup, 16);
            this.fTimestampButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.TIMESTAMP);
            this.fTimestampButton.setText(Messages.FilterViewer_TimestampButtonText);
            this.fTimestampButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fTimestampButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fTimestampButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.TIMESTAMP);
                    }
                    FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ValueLabel);
            this.fValueText = new Text((Composite)this, 2048);
            this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getValue() != null && node.getValue().length() > 0) {
                this.fValueText.setText(node.getValue());
            } else {
                this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fValueText.setText(Messages.FilterViewer_ValueHint);
            }
            this.fValueText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterCompareNodeComposite.this.fNode.getValue() == null || FilterCompareNodeComposite.this.fNode.getValue().length() == 0) {
                        FilterCompareNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterCompareNodeComposite.this.fValueText.setText(Messages.FilterViewer_ValueHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterCompareNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterCompareNodeComposite.this.fValueText.setText("");
                    }
                    FilterCompareNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterCompareNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterCompareNodeComposite.this.fNode.setValue(FilterCompareNodeComposite.this.fValueText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                    }
                }
            });
        }
    }

    private class FilterContainsNodeComposite
    extends FilterAspectNodeComposite {
        TmfFilterContainsNode fNode;
        Button fNotButton;
        Text fValueText;
        Button fIgnoreCaseButton;

        FilterContainsNodeComposite(Composite parent, TmfFilterContainsNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterContainsNodeComposite.this.fNode.setNot(FilterContainsNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                }
            });
            this.createAspectControls();
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ValueLabel);
            this.fValueText = new Text((Composite)this, 2048);
            this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getValue() != null && node.getValue().length() > 0) {
                this.fValueText.setText(node.getValue());
            } else {
                this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fValueText.setText(Messages.FilterViewer_ValueHint);
            }
            this.fValueText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterContainsNodeComposite.this.fNode.getValue() == null || FilterContainsNodeComposite.this.fNode.getValue().length() == 0) {
                        FilterContainsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterContainsNodeComposite.this.fValueText.setText(Messages.FilterViewer_ValueHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterContainsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterContainsNodeComposite.this.fValueText.setText("");
                    }
                    FilterContainsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterContainsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterContainsNodeComposite.this.fNode.setValue(FilterContainsNodeComposite.this.fValueText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                    }
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton = new Button((Composite)this, 32);
            this.fIgnoreCaseButton.setSelection(this.fNode.isIgnoreCase());
            this.fIgnoreCaseButton.setText(Messages.FilterViewer_IgnoreCaseButtonText);
            this.fIgnoreCaseButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterContainsNodeComposite.this.fNode.setIgnoreCase(FilterContainsNodeComposite.this.fIgnoreCaseButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterEqualsNodeComposite
    extends FilterAspectNodeComposite {
        TmfFilterEqualsNode fNode;
        Button fNotButton;
        Text fValueText;
        Button fIgnoreCaseButton;

        FilterEqualsNodeComposite(Composite parent, TmfFilterEqualsNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterEqualsNodeComposite.this.fNode.setNot(FilterEqualsNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                }
            });
            this.createAspectControls();
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_ValueLabel);
            this.fValueText = new Text((Composite)this, 2048);
            this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getValue() != null && node.getValue().length() > 0) {
                this.fValueText.setText(node.getValue());
            } else {
                this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fValueText.setText(Messages.FilterViewer_ValueHint);
            }
            this.fValueText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterEqualsNodeComposite.this.fNode.getValue() == null || FilterEqualsNodeComposite.this.fNode.getValue().length() == 0) {
                        FilterEqualsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterEqualsNodeComposite.this.fValueText.setText(Messages.FilterViewer_ValueHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterEqualsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterEqualsNodeComposite.this.fValueText.setText("");
                    }
                    FilterEqualsNodeComposite.this.fValueText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterEqualsNodeComposite.this.fValueText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterEqualsNodeComposite.this.fNode.setValue(FilterEqualsNodeComposite.this.fValueText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                    }
                }
            });
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton = new Button((Composite)this, 32);
            this.fIgnoreCaseButton.setSelection(this.fNode.isIgnoreCase());
            this.fIgnoreCaseButton.setText(Messages.FilterViewer_IgnoreCaseButtonText);
            this.fIgnoreCaseButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fIgnoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterEqualsNodeComposite.this.fNode.setIgnoreCase(FilterEqualsNodeComposite.this.fIgnoreCaseButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterMatchesNodeComposite
    extends FilterAspectNodeComposite {
        TmfFilterMatchesNode fNode;
        Button fNotButton;
        Text fRegexText;

        FilterMatchesNodeComposite(Composite parent, TmfFilterMatchesNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterMatchesNodeComposite.this.fNode.setNot(FilterMatchesNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterMatchesNodeComposite.this.fNode);
                }
            });
            this.createAspectControls();
            label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_RegexLabel);
            this.fRegexText = new Text((Composite)this, 2048);
            this.fRegexText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getRegex() != null && node.getRegex().length() > 0) {
                this.fRegexText.setText(node.getRegex());
            } else {
                this.fRegexText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fRegexText.setText(Messages.FilterViewer_RegexHint);
            }
            this.fRegexText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterMatchesNodeComposite.this.fNode.getRegex() == null || FilterMatchesNodeComposite.this.fNode.getRegex().length() == 0) {
                        FilterMatchesNodeComposite.this.fRegexText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterMatchesNodeComposite.this.fRegexText.setText(Messages.FilterViewer_RegexHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterMatchesNodeComposite.this.fRegexText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterMatchesNodeComposite.this.fRegexText.setText("");
                    }
                    FilterMatchesNodeComposite.this.fRegexText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fRegexText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterMatchesNodeComposite.this.fRegexText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterMatchesNodeComposite.this.fNode.setRegex(FilterMatchesNodeComposite.this.fRegexText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterMatchesNodeComposite.this.fNode);
                    }
                }
            });
        }
    }

    private class FilterNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterNode fNode;
        Text fNameText;

        FilterNodeComposite(Composite parent, TmfFilterNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NameLabel);
            this.fNameText = new Text((Composite)this, 2048);
            this.fNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getFilterName() != null && node.getFilterName().length() > 0) {
                this.fNameText.setText(node.getFilterName());
            } else {
                this.fNameText.setForeground(Display.getCurrent().getSystemColor(15));
                this.fNameText.setText(Messages.FilterViewer_FilterNameHint);
            }
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterNodeComposite.this.fNode.getFilterName() == null || FilterNodeComposite.this.fNode.getFilterName().length() == 0) {
                        FilterNodeComposite.this.fNameText.setForeground(Display.getCurrent().getSystemColor(15));
                        FilterNodeComposite.this.fNameText.setText(Messages.FilterViewer_FilterNameHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterNodeComposite.this.fNameText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterNodeComposite.this.fNameText.setText("");
                    }
                    FilterNodeComposite.this.fNameText.setForeground(Display.getCurrent().getSystemColor(2));
                }
            });
            this.fNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FilterNodeComposite.this.fNameText.getForeground().equals((Object)Display.getCurrent().getSystemColor(15))) {
                        FilterNodeComposite.this.fNode.setFilterName(FilterNodeComposite.this.fNameText.getText());
                        FilterViewer.this.fViewer.refresh((Object)FilterNodeComposite.this.fNode);
                    }
                }
            });
        }
    }

    private class FilterOrNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterOrNode fNode;
        Button fNotButton;

        FilterOrNodeComposite(Composite parent, TmfFilterOrNode node) {
            super(parent);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_NotLabel);
            this.fNotButton = new Button((Composite)this, 32);
            this.fNotButton.setBackground(Display.getCurrent().getSystemColor(1));
            this.fNotButton.setSelection(this.fNode.isNot());
            this.fNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterOrNodeComposite.this.fNode.setNot(FilterOrNodeComposite.this.fNotButton.getSelection());
                    FilterViewer.this.fViewer.refresh((Object)FilterOrNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterTraceTypeNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterTraceTypeNode fNode;
        Combo fTypeCombo;
        Map<String, TraceTypeHelper> fTraceTypeMap;

        FilterTraceTypeNodeComposite(Composite parent, TmfFilterTraceTypeNode node) {
            super(parent);
            this.fNode = node;
            this.fTraceTypeMap = this.getTraceTypeMap();
            Label label = new Label((Composite)this, 0);
            label.setBackground(Display.getCurrent().getSystemColor(1));
            label.setText(Messages.FilterViewer_TypeLabel);
            this.fTypeCombo = new Combo((Composite)this, 12);
            this.fTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fTypeCombo.setItems(this.fTraceTypeMap.keySet().toArray(new String[0]));
            if (this.fNode.getTraceTypeId() != null) {
                this.fTypeCombo.setText(this.fNode.getName());
            }
            this.fTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TraceTypeHelper helper = FilterTraceTypeNodeComposite.this.fTraceTypeMap.get(FilterTraceTypeNodeComposite.this.fTypeCombo.getText());
                    FilterTraceTypeNodeComposite.this.fNode.setTraceTypeId(helper.getTraceTypeId());
                    FilterTraceTypeNodeComposite.this.fNode.setTraceClass(helper.getTraceClass());
                    FilterTraceTypeNodeComposite.this.fNode.setName(FilterTraceTypeNodeComposite.this.fTypeCombo.getText());
                    FilterViewer.this.fViewer.refresh((Object)FilterTraceTypeNodeComposite.this.fNode);
                }
            });
        }
    }

    private static class TraceTypeItem {
        public String label;
        public String traceTypeId;

        public TraceTypeItem(String label, String traceTypeId) {
            this.label = label;
            this.traceTypeId = traceTypeId;
        }
    }
}

