/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.callstack;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEntry;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEvent;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class CallStackPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;
    private CallStackView fView;
    private Integer fAverageCharWidth;

    @Deprecated
    public CallStackPresentationProvider(CallStackView view) {
        this.fView = view;
    }

    public CallStackPresentationProvider() {
    }

    public void setCallStackView(CallStackView view) {
        this.fView = view;
    }

    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        return Messages.CallStackPresentationProvider_Thread;
    }

    @Override
    public StateItem[] getStateTable() {
        float saturation = 0.6f;
        float brightness = 0.6f;
        StateItem[] stateTable = new StateItem[361];
        stateTable[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        int i = 0;
        while (i < 360) {
            RGB rgb = new RGB((float)i, 0.6f, 0.6f);
            stateTable[i + 1] = new StateItem(rgb, State.EXEC.toString());
            ++i;
        }
        return stateTable;
    }

    @Override
    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof CallStackEvent) {
            CallStackEvent callStackEvent = (CallStackEvent)event;
            return callStackEvent.getValue() + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    @Override
    public String getEventName(ITimeEvent event) {
        if (event instanceof CallStackEvent) {
            CallStackEntry entry = (CallStackEntry)event.getEntry();
            ITmfStateSystem ss = entry.getStateSystem();
            try {
                ITmfStateValue value = ss.querySingleState(event.getTime(), entry.getQuark()).getStateValue();
                if (!value.isNull()) {
                    String address = value.toString();
                    return this.fView.getFunctionName(address);
                }
            }
            catch (AttributeNotFoundException e) {
                Activator.getDefault().logError("Error querying state system", e);
            }
            catch (TimeRangeException e) {
                Activator.getDefault().logError("Error querying state system", e);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
            return null;
        }
        return State.MULTIPLE.toString();
    }

    @Override
    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fAverageCharWidth == null) {
            this.fAverageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        if (bounds.width <= this.fAverageCharWidth) {
            return;
        }
        if (!(event instanceof CallStackEvent)) {
            return;
        }
        CallStackEntry entry = (CallStackEntry)event.getEntry();
        ITmfStateSystem ss = entry.getStateSystem();
        try {
            ITmfStateValue value = ss.querySingleState(event.getTime(), entry.getQuark()).getStateValue();
            if (!value.isNull()) {
                String address = value.toString();
                String name = this.fView.getFunctionName(address);
                gc.setForeground(gc.getDevice().getSystemColor(1));
                Utils.drawText(gc, name, bounds.x, bounds.y - 2, bounds.width, true, true);
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getDefault().logError("Error querying state system", e);
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error querying state system", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

