/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TmfProjectRegistry
implements IResourceChangeListener {
    private static Map<IProject, TmfProjectElement> registry;

    static {
        new TmfProjectRegistry();
        registry = new HashMap<IProject, TmfProjectElement>();
    }

    private TmfProjectRegistry() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static synchronized TmfProjectElement getProject(IProject project) {
        return TmfProjectRegistry.getProject(project, false);
    }

    public static synchronized TmfProjectElement getProject(IProject project, boolean force) {
        TmfProjectElement element = registry.get(project);
        if (element == null && force) {
            registry.put(project, new TmfProjectElement(project.getName(), project, null));
            element = registry.get(project);
            element.refreshChildren();
        }
        return element;
    }

    public static IProject createProject(String projectName, final URI projectLocation, IProgressMonitor monitor) {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject project = root.getProject(projectName);
        WorkspaceModifyOperation action = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProjectDescription description;
                if (!project.exists()) {
                    description = workspace.newProjectDescription(project.getName());
                    if (projectLocation != null) {
                        description.setLocationURI(projectLocation);
                    }
                    project.create(description, progressMonitor);
                }
                if (!project.isOpen()) {
                    project.open(progressMonitor);
                }
                description = project.getDescription();
                description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
                project.setDescription(description, null);
                IFolder folder = project.getFolder("Traces");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                if (!(folder = project.getFolder("Experiments")).exists()) {
                    folder.create(true, true, null);
                }
                if (!(folder = project.getFolder(".tracing")).exists()) {
                    folder.create(true, true, null);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)action);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error creating TMF project " + project.getName(), e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        block15: {
            if (event.getType() == 4 || event.getType() == 2) {
                if (event.getResource() instanceof IProject) {
                    IProject project = (IProject)event.getResource();
                    try {
                        if (!project.isAccessible() || !project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) break block15;
                        TmfProjectElement tmfProjectElement = registry.get(project);
                        if (tmfProjectElement == null) {
                            return;
                        }
                        final List<TmfTraceElement> traces = tmfProjectElement.getTracesFolder().getTraces();
                        if (!traces.isEmpty()) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    for (TmfTraceElement traceElement : traces) {
                                        traceElement.closeEditors();
                                    }
                                }
                            });
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error handling resource change event for " + project.getName(), e);
                    }
                }
            } else if (event.getType() == 1) {
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource() instanceof IProject) {
                        IProject project = (IProject)delta.getResource();
                        try {
                            if (delta.getKind() == 4 && project.isOpen() && project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                                TmfProjectElement projectElement = TmfProjectRegistry.getProject(project, true);
                                projectElement.refresh();
                            } else if (delta.getKind() == 2) {
                                registry.remove(project);
                            }
                        }
                        catch (CoreException e) {
                            Activator.getDefault().logError("Error handling resource change event for " + project.getName(), e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

