/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TmfAlignmentSynchronizer {
    private static final long THROTTLE_DELAY = 500L;
    private static final int NEAR_THRESHOLD = 10;
    private final Timer fTimer;
    private final List<AlignmentOperation> fPendingOperations = Collections.synchronizedList(new ArrayList());
    private TimerTask fCurrentTask;

    public TmfAlignmentSynchronizer() {
        TmfSignalManager.register((Object)this);
        this.fTimer = new Timer();
        this.createPreferenceListener();
        this.fCurrentTask = new TimerTask(){

            @Override
            public void run() {
            }
        };
    }

    private IEclipsePreferences.IPreferenceChangeListener createPreferenceListener() {
        IEclipsePreferences.IPreferenceChangeListener listener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("PREF_ALIGN_VIEWS")) {
                    Object oldValue = event.getOldValue();
                    Object newValue = event.getNewValue();
                    if (Boolean.toString(false).equals(oldValue) && Boolean.toString(true).equals(newValue)) {
                        TmfAlignmentSynchronizer.this.realignViews();
                    } else if (Boolean.toString(true).equals(oldValue) && Boolean.toString(false).equals(newValue)) {
                        TmfAlignmentSynchronizer.restoreViews();
                    }
                }
            }
        };
        InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.ui").addPreferenceChangeListener(listener);
        return listener;
    }

    public void handleViewResized(TmfView view) {
        TmfTimeViewAlignmentInfo alignmentInfo = new TmfTimeViewAlignmentInfo(view.getParentComposite().getShell(), TmfAlignmentSynchronizer.getViewLocation(view), 0);
        ITmfTimeAligned referenceView = TmfAlignmentSynchronizer.getReferenceView(alignmentInfo, view);
        if (referenceView != null) {
            this.queueAlignment(referenceView.getTimeViewAlignmentInfo(), false);
        }
    }

    public void handleViewClosed(TmfView view) {
        this.realignViews(view.getSite().getPage());
    }

    @TmfSignalHandler
    public void timeViewAlignmentUpdated(TmfTimeViewAlignmentSignal signal) {
        this.queueAlignment(signal.getTimeViewAlignmentInfo(), signal.IsSynchronous());
    }

    private static void performAllAlignments(List<AlignmentOperation> alignments) {
        for (AlignmentOperation info : alignments) {
            TmfAlignmentSynchronizer.performAlignment(info);
        }
    }

    private static void performAlignment(AlignmentOperation info) {
        IViewReference[] viewReferences;
        TmfView referenceView = info.fView;
        if (TmfAlignmentSynchronizer.isDisposedView(referenceView)) {
            return;
        }
        TmfTimeViewAlignmentInfo alignmentInfo = info.fAlignmentInfo;
        TmfView narrowestView = TmfAlignmentSynchronizer.getNarrowestView(alignmentInfo = new TmfTimeViewAlignmentInfo(alignmentInfo.getShell(), TmfAlignmentSynchronizer.getViewLocation(referenceView), TmfAlignmentSynchronizer.getClampedTimeAxisOffset(alignmentInfo)));
        if (narrowestView == null) {
            return;
        }
        int narrowestWidth = ((ITmfTimeAligned)((Object)narrowestView)).getAvailableWidth(TmfAlignmentSynchronizer.getClampedTimeAxisOffset(alignmentInfo));
        narrowestWidth = TmfAlignmentSynchronizer.getClampedTimeAxisWidth(alignmentInfo, narrowestWidth);
        IViewReference[] iViewReferenceArray = viewReferences = referenceView.getSite().getPage().getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IViewPart view = ref.getView(false);
            if (TmfAlignmentSynchronizer.isTimeAlignedView(view)) {
                TmfView tmfView = (TmfView)view;
                ITmfTimeAligned alignedView = (ITmfTimeAligned)view;
                if (!TmfAlignmentSynchronizer.isDisposedView(tmfView) && TmfAlignmentSynchronizer.isViewLocationNear(TmfAlignmentSynchronizer.getViewLocation(tmfView), alignmentInfo.getViewLocation())) {
                    alignedView.performAlign(TmfAlignmentSynchronizer.getClampedTimeAxisOffset(alignmentInfo), narrowestWidth);
                }
            }
            ++n2;
        }
    }

    private void realignViews() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                this.realignViews(page);
                ++n4;
            }
            ++n2;
        }
    }

    private void realignViews(IWorkbenchPage page) {
        IViewReference[] viewReferences;
        IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IViewPart view = ref.getView(false);
            if (TmfAlignmentSynchronizer.isTimeAlignedView(view)) {
                this.queueAlignment(((ITmfTimeAligned)view).getTimeViewAlignmentInfo(), false);
            }
            ++n2;
        }
    }

    private static void restoreViews() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n5 = iViewReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IViewReference ref = iViewReferenceArray[n6];
                    TmfAlignmentSynchronizer.restoreView(ref);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void restoreView(IViewReference ref) {
        IViewPart view = ref.getView(false);
        if (TmfAlignmentSynchronizer.isTimeAlignedView(view)) {
            ITmfTimeAligned alignedView = (ITmfTimeAligned)view;
            alignedView.performAlign(TmfAlignmentSynchronizer.getClampedTimeAxisOffset(alignedView.getTimeViewAlignmentInfo()), Integer.MAX_VALUE);
        }
    }

    private static boolean isTimeAlignedView(IViewPart view) {
        Composite parentComposite;
        if (view instanceof TmfView && view instanceof ITmfTimeAligned && (parentComposite = ((TmfView)view).getParentComposite()) != null && !parentComposite.isDisposed()) {
            return true;
        }
        return view instanceof TmfView && view instanceof ITmfTimeAligned;
    }

    private static boolean isDisposedView(TmfView view) {
        Composite parentComposite = view.getParentComposite();
        return parentComposite != null && parentComposite.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(AlignmentOperation operation) {
        List<AlignmentOperation> list = this.fPendingOperations;
        synchronized (list) {
            this.fCurrentTask.cancel();
            for (AlignmentOperation pendingOperation : this.fPendingOperations) {
                if (!TmfAlignmentSynchronizer.isSameAlignment(operation, pendingOperation)) continue;
                this.fPendingOperations.remove(pendingOperation);
                break;
            }
            this.fPendingOperations.add(operation);
            this.fCurrentTask = new AlignTask();
            this.fTimer.schedule(this.fCurrentTask, 500L);
        }
    }

    private static boolean isSameAlignment(AlignmentOperation operation1, AlignmentOperation operation2) {
        if (operation1.fView == operation2.fView) {
            return true;
        }
        if (operation1.fAlignmentInfo.getShell() != operation2.fAlignmentInfo.getShell()) {
            return false;
        }
        return TmfAlignmentSynchronizer.isViewLocationNear(TmfAlignmentSynchronizer.getViewLocation(operation1.fView), TmfAlignmentSynchronizer.getViewLocation(operation2.fView));
    }

    private static boolean isViewLocationNear(Point location1, Point location2) {
        return Math.abs(location1.x - location2.x) < 10;
    }

    private static Point getViewLocation(TmfView view) {
        return view.getParentComposite().toDisplay(0, 0);
    }

    private void queueAlignment(TmfTimeViewAlignmentInfo timeViewAlignmentInfo, boolean synchronous) {
        if (TmfAlignmentSynchronizer.isAlignViewsPreferenceEnabled()) {
            IWorkbenchWindow workbenchWindow = TmfAlignmentSynchronizer.getWorkbenchWindow(timeViewAlignmentInfo.getShell());
            if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
                return;
            }
            TmfView view = (TmfView)((Object)TmfAlignmentSynchronizer.getReferenceView(timeViewAlignmentInfo, null));
            if (view == null) {
                return;
            }
            AlignmentOperation operation = new AlignmentOperation(view, timeViewAlignmentInfo);
            if (synchronous) {
                TmfAlignmentSynchronizer.performAlignment(operation);
            } else {
                this.queue(operation);
            }
        }
    }

    private static boolean isAlignViewsPreferenceEnabled() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.ui").getBoolean("PREF_ALIGN_VIEWS", true);
    }

    private static ITmfTimeAligned getReferenceView(TmfTimeViewAlignmentInfo alignmentInfo, TmfView blackListedView) {
        IWorkbenchWindow workbenchWindow = TmfAlignmentSynchronizer.getWorkbenchWindow(alignmentInfo.getShell());
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        int lowestTimeAxisOffset = Integer.MAX_VALUE;
        ITmfTimeAligned referenceView = null;
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IViewPart view = ref.getView(false);
            if (view != blackListedView && TmfAlignmentSynchronizer.isTimeAlignedView(view) && TmfAlignmentSynchronizer.isCandidateForReferenceView((TmfView)view, alignmentInfo, lowestTimeAxisOffset)) {
                referenceView = (ITmfTimeAligned)view;
                lowestTimeAxisOffset = TmfAlignmentSynchronizer.getClampedTimeAxisOffset(referenceView.getTimeViewAlignmentInfo());
                break;
            }
            ++n2;
        }
        return referenceView;
    }

    private static boolean isCandidateForReferenceView(TmfView tmfView, TmfTimeViewAlignmentInfo alignmentInfo, int lowestTimeAxisOffset) {
        boolean isVisible;
        ITmfTimeAligned alignedView = (ITmfTimeAligned)((Object)tmfView);
        TmfTimeViewAlignmentInfo timeViewAlignmentInfo = alignedView.getTimeViewAlignmentInfo();
        if (timeViewAlignmentInfo == null) {
            return false;
        }
        if (TmfAlignmentSynchronizer.isDisposedView(tmfView)) {
            return false;
        }
        Composite parentComposite = tmfView.getParentComposite();
        boolean bl = isVisible = parentComposite != null && parentComposite.isVisible();
        if (isVisible) {
            boolean isLowestTimeAxisOffset;
            boolean isViewLocationNear = TmfAlignmentSynchronizer.isViewLocationNear(alignmentInfo.getViewLocation(), TmfAlignmentSynchronizer.getViewLocation(tmfView));
            boolean bl2 = isLowestTimeAxisOffset = TmfAlignmentSynchronizer.getClampedTimeAxisOffset(timeViewAlignmentInfo) < lowestTimeAxisOffset;
            if (isViewLocationNear && isLowestTimeAxisOffset) {
                int availableWidth = alignedView.getAvailableWidth(TmfAlignmentSynchronizer.getClampedTimeAxisOffset(timeViewAlignmentInfo));
                if ((availableWidth = TmfAlignmentSynchronizer.getClampedTimeAxisWidth(timeViewAlignmentInfo, availableWidth)) > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private static TmfView getNarrowestView(TmfTimeViewAlignmentInfo alignmentInfo) {
        IWorkbenchWindow workbenchWindow = TmfAlignmentSynchronizer.getWorkbenchWindow(alignmentInfo.getShell());
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        int narrowestWidth = Integer.MAX_VALUE;
        TmfView narrowestView = null;
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TmfView tmfView;
            IViewReference ref = iViewReferenceArray[n2];
            IViewPart view = ref.getView(false);
            if (TmfAlignmentSynchronizer.isTimeAlignedView(view) && TmfAlignmentSynchronizer.isCandidateForNarrowestView(tmfView = (TmfView)view, alignmentInfo, narrowestWidth)) {
                narrowestWidth = ((ITmfTimeAligned)((Object)tmfView)).getAvailableWidth(TmfAlignmentSynchronizer.getClampedTimeAxisOffset(alignmentInfo));
                narrowestWidth = TmfAlignmentSynchronizer.getClampedTimeAxisWidth(alignmentInfo, narrowestWidth);
                narrowestView = tmfView;
            }
            ++n2;
        }
        return narrowestView;
    }

    private static int getClampedTimeAxisWidth(TmfTimeViewAlignmentInfo alignmentInfo, int width) {
        int max = TmfAlignmentSynchronizer.getMaxInt(alignmentInfo.getShell());
        if (TmfAlignmentSynchronizer.validateInt(width, max)) {
            Activator.getDefault().logError("Time-axis width out of range (" + width + ")", new Throwable());
        }
        return Math.min(max, Math.max(0, width));
    }

    private static int getClampedTimeAxisOffset(TmfTimeViewAlignmentInfo alignmentInfo) {
        int max;
        int timeAxisOffset = alignmentInfo.getTimeAxisOffset();
        if (TmfAlignmentSynchronizer.validateInt(timeAxisOffset, max = TmfAlignmentSynchronizer.getMaxInt(alignmentInfo.getShell()))) {
            Activator.getDefault().logError("Time-axis offset out of range (" + timeAxisOffset + ")", new Throwable());
        }
        return Math.min(max, Math.max(0, timeAxisOffset));
    }

    private static boolean validateInt(int value, int max) {
        return value < 0 || value > max;
    }

    private static int getMaxInt(Shell shell) {
        int DISPLAY_WIDTH_FACTOR = 10;
        return shell.getDisplay().getBounds().width * 10;
    }

    private static boolean isCandidateForNarrowestView(TmfView tmfView, TmfTimeViewAlignmentInfo alignmentInfo, int narrowestWidth) {
        boolean isVisible;
        ITmfTimeAligned alignedView = (ITmfTimeAligned)((Object)tmfView);
        TmfTimeViewAlignmentInfo timeViewAlignmentInfo = alignedView.getTimeViewAlignmentInfo();
        if (timeViewAlignmentInfo == null) {
            return false;
        }
        if (TmfAlignmentSynchronizer.isDisposedView(tmfView)) {
            return false;
        }
        Composite parentComposite = tmfView.getParentComposite();
        boolean bl = isVisible = parentComposite != null && parentComposite.isVisible();
        if (isVisible && TmfAlignmentSynchronizer.isViewLocationNear(TmfAlignmentSynchronizer.getViewLocation(tmfView), alignmentInfo.getViewLocation())) {
            int availableWidth = alignedView.getAvailableWidth(TmfAlignmentSynchronizer.getClampedTimeAxisOffset(alignmentInfo));
            boolean isNarrower = (availableWidth = TmfAlignmentSynchronizer.getClampedTimeAxisWidth(alignmentInfo, availableWidth)) < narrowestWidth && availableWidth > 0;
            return isNarrower;
        }
        return false;
    }

    private static IWorkbenchWindow getWorkbenchWindow(Shell shell) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window.getShell().equals(shell)) {
                return window;
            }
            ++n2;
        }
        return null;
    }

    private class AlignTask
    extends TimerTask {
        private AlignTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList fCopy;
            List list = TmfAlignmentSynchronizer.this.fPendingOperations;
            synchronized (list) {
                fCopy = new ArrayList(TmfAlignmentSynchronizer.this.fPendingOperations);
                TmfAlignmentSynchronizer.this.fPendingOperations.clear();
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    TmfAlignmentSynchronizer.performAllAlignments(fCopy);
                }
            });
        }
    }

    private class AlignmentOperation {
        final TmfView fView;
        final TmfTimeViewAlignmentInfo fAlignmentInfo;

        public AlignmentOperation(TmfView view, TmfTimeViewAlignmentInfo timeViewAlignmentInfo) {
            this.fView = view;
            this.fAlignmentInfo = timeViewAlignmentInfo;
        }
    }
}

