/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.dialogs.offset.OffsetDialog;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OffsetTraceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        HashSet<TmfTraceElement> traceElements = new HashSet<TmfTraceElement>();
        if (selection instanceof StructuredSelection) {
            for (Object element : (StructuredSelection)selection) {
                if (element instanceof TmfTraceElement) {
                    TmfTraceElement trace = (TmfTraceElement)element;
                    traceElements.add(trace.getElementUnderTraceFolder());
                    continue;
                }
                if (element instanceof TmfExperimentElement) {
                    TmfExperimentElement exp = (TmfExperimentElement)element;
                    for (TmfTraceElement trace : exp.getTraces()) {
                        traceElements.add(trace.getElementUnderTraceFolder());
                    }
                    continue;
                }
                if (!(element instanceof TmfTraceFolder)) continue;
                TmfTraceFolder folder = (TmfTraceFolder)element;
                traceElements.addAll(folder.getTraces());
            }
        }
        if (traceElements.isEmpty()) {
            return null;
        }
        final LinkedHashMap<TmfTraceElement, Long> offsets = new LinkedHashMap<TmfTraceElement, Long>(traceElements.size());
        for (TmfTraceElement trace : traceElements) {
            offsets.put(trace, 0L);
        }
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        OffsetDialog dialog = new OffsetDialog(shell, offsets);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                for (final TmfTraceElement trace : offsets.keySet()) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Long offset = (Long)offsets.get(trace);
                    if (offset == 0L || !trace.getResource().exists()) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            trace.closeEditors();
                        }
                    });
                    long previousOffset = TimestampTransformFactory.getTimestampTransform((IResource)trace.getResource()).transform(0L);
                    ITmfTimestampTransform transform = TimestampTransformFactory.createWithOffset((long)(previousOffset + offset));
                    trace.deleteSupplementaryResources();
                    trace.refreshSupplementaryFolder();
                    TimestampTransformFactory.setTimestampTransform((IResource)trace.getResource(), (ITmfTimestampTransform)transform);
                    trace.refreshSupplementaryFolder();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)shell, (String)e.toString(), (String)e.getTargetException().toString());
            return null;
        }
        return null;
    }
}

