/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernelanalysis;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class KernelStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 10;
    private static final int IRQ_HANDLER_ENTRY_INDEX = 1;
    private static final int IRQ_HANDLER_EXIT_INDEX = 2;
    private static final int SOFT_IRQ_ENTRY_INDEX = 3;
    private static final int SOFT_IRQ_EXIT_INDEX = 4;
    private static final int SOFT_IRQ_RAISE_INDEX = 5;
    private static final int SCHED_SWITCH_INDEX = 6;
    private static final int SCHED_PROCESS_FORK_INDEX = 7;
    private static final int SCHED_PROCESS_EXIT_INDEX = 8;
    private static final int SCHED_PROCESS_FREE_INDEX = 9;
    private static final int STATEDUMP_PROCESS_STATE_INDEX = 10;
    private static final int SCHED_WAKEUP_INDEX = 11;
    private static final int SCHED_PI_SETPRIO_INDEX = 12;
    private final Map<String, Integer> fEventNames;
    private final IKernelAnalysisEventLayout fLayout;

    public KernelStateProvider(ITmfTrace trace, IKernelAnalysisEventLayout layout) {
        super(trace, "Kernel");
        this.fLayout = layout;
        this.fEventNames = KernelStateProvider.buildEventNames(layout);
    }

    private static Map<String, Integer> buildEventNames(IKernelAnalysisEventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventIrqHandlerEntry(), (Object)1);
        builder.put((Object)layout.eventIrqHandlerExit(), (Object)2);
        builder.put((Object)layout.eventSoftIrqEntry(), (Object)3);
        builder.put((Object)layout.eventSoftIrqExit(), (Object)4);
        builder.put((Object)layout.eventSoftIrqRaise(), (Object)5);
        builder.put((Object)layout.eventSchedSwitch(), (Object)6);
        builder.put((Object)layout.eventSchedPiSetprio(), (Object)12);
        builder.put((Object)layout.eventSchedProcessFork(), (Object)7);
        builder.put((Object)layout.eventSchedProcessExit(), (Object)8);
        builder.put((Object)layout.eventSchedProcessFree(), (Object)9);
        String eventStatedumpProcessState = layout.eventStatedumpProcessState();
        if (eventStatedumpProcessState != null) {
            builder.put((Object)eventStatedumpProcessState, (Object)10);
        }
        for (String eventSchedWakeup : layout.eventsSchedWakeup()) {
            builder.put((Object)eventSchedWakeup, (Object)11);
        }
        return (Map)NonNullUtils.checkNotNull((Object)builder.build());
    }

    public int getVersion() {
        return 10;
    }

    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        super.assignTargetStateSystem(ssb);
    }

    public KernelStateProvider getNewInstance() {
        return new KernelStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(@Nullable ITmfEvent event) {
        if (event == null) {
            return;
        }
        Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpuObj == null) {
            return;
        }
        Integer cpu = (Integer)cpuObj;
        String eventName = event.getName();
        long ts = event.getTimestamp().getValue();
        try {
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            int currentCPUNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeCPUs(ss), new String[]{cpu.toString()});
            int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
            ITmfStateValue value = ss.queryOngoingState(quark);
            int thread = value.isNull() ? -1 : value.unboxInt();
            int currentThreadNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{String.valueOf(thread)});
            Integer idx = this.fEventNames.get(eventName);
            int intval = idx == null ? -1 : idx;
            switch (intval) {
                case 1: {
                    Integer irqId = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldIrq()}).getValue()).intValue();
                    quark = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeIRQs(ss), new String[]{irqId.toString()});
                    value = TmfStateValue.newValueInt((int)cpu);
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
                    value = StateValues.PROCESS_STATUS_INTERRUPTED_VALUE;
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
                    value = StateValues.CPU_STATUS_IRQ_VALUE;
                    ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 2: {
                    Integer irqId = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldIrq()}).getValue()).intValue();
                    quark = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeIRQs(ss), new String[]{irqId.toString()});
                    value = TmfStateValue.nullValue();
                    ss.modifyAttribute(ts, value, quark);
                    KernelStateProvider.setProcessToRunning(ss, ts, currentThreadNode);
                    KernelStateProvider.cpuExitInterrupt(ss, ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case 3: {
                    Integer softIrqId = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldVec()}).getValue()).intValue();
                    quark = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeSoftIRQs(ss), new String[]{softIrqId.toString()});
                    value = TmfStateValue.newValueInt((int)cpu);
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
                    value = StateValues.PROCESS_STATUS_INTERRUPTED_VALUE;
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
                    value = StateValues.CPU_STATUS_SOFTIRQ_VALUE;
                    ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 4: {
                    Integer softIrqId = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldVec()}).getValue()).intValue();
                    quark = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeSoftIRQs(ss), new String[]{softIrqId.toString()});
                    value = TmfStateValue.nullValue();
                    ss.modifyAttribute(ts, value, quark);
                    KernelStateProvider.setProcessToRunning(ss, ts, currentThreadNode);
                    KernelStateProvider.cpuExitInterrupt(ss, ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case 5: {
                    Integer softIrqId = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldVec()}).getValue()).intValue();
                    quark = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeSoftIRQs(ss), new String[]{softIrqId.toString()});
                    value = StateValues.SOFT_IRQ_RAISED_VALUE;
                    ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 6: {
                    ITmfEventField content = event.getContent();
                    Integer prevTid = ((Long)content.getField(new String[]{this.fLayout.fieldPrevTid()}).getValue()).intValue();
                    Long prevState = (Long)content.getField(new String[]{this.fLayout.fieldPrevState()}).getValue();
                    String nextProcessName = (String)content.getField(new String[]{this.fLayout.fieldNextComm()}).getValue();
                    Integer nextTid = ((Long)content.getField(new String[]{this.fLayout.fieldNextTid()}).getValue()).intValue();
                    Integer nextPrio = ((Long)content.getField(new String[]{this.fLayout.fieldNextPrio()}).getValue()).intValue();
                    Integer formerThreadNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{prevTid.toString()});
                    Integer newCurrentThreadNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{nextTid.toString()});
                    prevState = prevState & 0xFFFFFFFFFFFFFBFFL;
                    switch (prevState.intValue()) {
                        case 0: {
                            value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                            break;
                        }
                        case 1: 
                        case 2: {
                            value = StateValues.PROCESS_STATUS_WAIT_BLOCKED_VALUE;
                            break;
                        }
                        case 64: {
                            value = TmfStateValue.nullValue();
                            break;
                        }
                        default: {
                            value = StateValues.PROCESS_STATUS_WAIT_UNKNOWN_VALUE;
                        }
                    }
                    quark = ss.getQuarkRelativeAndAdd(formerThreadNode.intValue(), new String[]{"Status"});
                    ss.modifyAttribute(ts, value, quark);
                    KernelStateProvider.setProcessToRunning(ss, ts, newCurrentThreadNode);
                    quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)nextProcessName);
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"Prio"});
                    value = TmfStateValue.newValueInt((int)nextPrio);
                    ss.modifyAttribute(ts, value, quark);
                    ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"});
                    ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"PPID"});
                    quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
                    value = TmfStateValue.newValueInt((int)nextTid);
                    ss.modifyAttribute(ts, value, quark);
                    value = nextTid > 0 ? (ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"})).isNull() ? StateValues.CPU_STATUS_RUN_USERMODE_VALUE : StateValues.CPU_STATUS_RUN_SYSCALL_VALUE) : StateValues.CPU_STATUS_IDLE_VALUE;
                    quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
                    ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 12: {
                    ITmfEventField content = event.getContent();
                    Integer tid = ((Long)content.getField(new String[]{this.fLayout.fieldTid()}).getValue()).intValue();
                    Integer prio = ((Long)content.getField(new String[]{this.fLayout.fieldNewPrio()}).getValue()).intValue();
                    Integer updateThreadNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{tid.toString()});
                    quark = ss.getQuarkRelativeAndAdd(updateThreadNode.intValue(), new String[]{"Prio"});
                    value = TmfStateValue.newValueInt((int)prio);
                    ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 7: {
                    ITmfEventField content = event.getContent();
                    String childProcessName = (String)content.getField(new String[]{this.fLayout.fieldChildComm()}).getValue();
                    Integer parentTid = ((Long)content.getField(new String[]{this.fLayout.fieldParentTid()}).getValue()).intValue();
                    Integer childTid = ((Long)content.getField(new String[]{this.fLayout.fieldChildTid()}).getValue()).intValue();
                    Integer parentTidNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{parentTid.toString()});
                    Integer childTidNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{childTid.toString()});
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"PPID"});
                    value = TmfStateValue.newValueInt((int)parentTid);
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)childProcessName);
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Status"});
                    value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                    ss.modifyAttribute(ts, value, quark);
                    quark = ss.getQuarkRelativeAndAdd(parentTidNode.intValue(), new String[]{"System_call"});
                    value = ss.queryOngoingState(quark);
                    if (value.isNull()) {
                        value = TmfStateValue.newValueString((String)(String.valueOf(this.fLayout.eventSyscallEntryPrefix()) + "clone"));
                    }
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"System_call"});
                    ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    Integer tid = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldTid()}).getValue()).intValue();
                    quark = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{tid.toString()});
                    ss.removeAttribute(ts, quark);
                    break;
                }
                case 10: {
                    ITmfEventField content = event.getContent();
                    int tid = ((Long)content.getField(new String[]{"tid"}).getValue()).intValue();
                    int pid = ((Long)content.getField(new String[]{"pid"}).getValue()).intValue();
                    int ppid = ((Long)content.getField(new String[]{"ppid"}).getValue()).intValue();
                    int status = ((Long)content.getField(new String[]{"status"}).getValue()).intValue();
                    String name = (String)content.getField(new String[]{"name"}).getValue();
                    int curThreadNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{String.valueOf(tid)});
                    quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Exec_name"});
                    if (ss.queryOngoingState(quark).isNull()) {
                        value = TmfStateValue.newValueString((String)name);
                        ss.modifyAttribute(ts, value, quark);
                    }
                    if (ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"PPID"})).isNull()) {
                        value = pid == tid ? TmfStateValue.newValueInt((int)ppid) : TmfStateValue.newValueInt((int)pid);
                        ss.modifyAttribute(ts, value, quark);
                    }
                    if (ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Status"})).isNull()) {
                        switch (status) {
                            case 2: {
                                value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                                break;
                            }
                            case 5: {
                                value = StateValues.PROCESS_STATUS_WAIT_UNKNOWN_VALUE;
                                break;
                            }
                            default: {
                                value = StateValues.PROCESS_STATUS_UNKNOWN_VALUE;
                            }
                        }
                        ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
                case 11: {
                    int tid = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldTid()}).getValue()).intValue();
                    int prio = ((Long)event.getContent().getField(new String[]{this.fLayout.fieldPrio()}).getValue()).intValue();
                    int threadNode = ss.getQuarkRelativeAndAdd(KernelStateProvider.getNodeThreads(ss), new String[]{String.valueOf(tid)});
                    quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Status"});
                    int status = ss.queryOngoingState(quark).unboxInt();
                    if (status != 3 && status != 2) {
                        value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                        ss.modifyAttribute(ts, value, quark);
                    }
                    quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Prio"});
                    value = TmfStateValue.newValueInt((int)prio);
                    ss.modifyAttribute(ts, value, quark);
                    break;
                }
                default: {
                    if (eventName.startsWith(this.fLayout.eventSyscallEntryPrefix()) || eventName.startsWith(this.fLayout.eventCompatSyscallEntryPrefix())) {
                        quark = ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
                        value = TmfStateValue.newValueString((String)eventName);
                        ss.modifyAttribute(ts, value, quark);
                        quark = ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
                        value = StateValues.PROCESS_STATUS_RUN_SYSCALL_VALUE;
                        ss.modifyAttribute(ts, value, quark);
                        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
                        value = StateValues.CPU_STATUS_RUN_SYSCALL_VALUE;
                        ss.modifyAttribute(ts, value, quark);
                        break;
                    }
                    if (eventName.startsWith(this.fLayout.eventSyscallExitPrefix()) || eventName.startsWith("compat_syscall_exit_")) {
                        quark = ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
                        value = TmfStateValue.nullValue();
                        ss.modifyAttribute(ts, value, quark);
                        quark = ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
                        value = StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE;
                        ss.modifyAttribute(ts, value, quark);
                        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
                        value = StateValues.CPU_STATUS_RUN_USERMODE_VALUE;
                        ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
            }
        }
        catch (AttributeNotFoundException ae) {
            ae.printStackTrace();
        }
        catch (TimeRangeException tre) {
            System.err.println("TimeRangeExcpetion caught in the state system's event manager.");
            System.err.println("Are the events in the trace correctly ordered?");
            tre.printStackTrace();
        }
        catch (StateValueTypeException sve) {
            sve.printStackTrace();
        }
    }

    private static int getNodeCPUs(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }

    private static int getNodeThreads(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
    }

    private static int getNodeIRQs(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"Resources", "IRQs"});
    }

    private static int getNodeSoftIRQs(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"Resources", "Soft_IRQs"});
    }

    private static void setProcessToRunning(ITmfStateSystemBuilder ssb, long ts, int currentThreadNode) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        int quark = ssb.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
        ITmfStateValue value = ssb.queryOngoingState(quark).isNull() ? StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE : StateValues.PROCESS_STATUS_RUN_SYSCALL_VALUE;
        quark = ssb.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
        ssb.modifyAttribute(ts, value, quark);
    }

    private static void cpuExitInterrupt(ITmfStateSystemBuilder ssb, long ts, int currentCpuNode, int currentThreadNode) throws StateValueTypeException, AttributeNotFoundException, TimeRangeException {
        int quark = ssb.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Current_thread"});
        ITmfStateValue value = ssb.queryOngoingState(quark).unboxInt() > 0 ? (ssb.queryOngoingState(quark = ssb.getQuarkRelative(currentThreadNode, new String[]{"System_call"})).isNull() ? StateValues.CPU_STATUS_RUN_USERMODE_VALUE : StateValues.CPU_STATUS_RUN_SYSCALL_VALUE) : StateValues.CPU_STATUS_IDLE_VALUE;
        quark = ssb.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Status"});
        ssb.modifyAttribute(ts, value, quark);
    }
}

