/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.Messages;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class ThreadPriorityAspect
implements ITmfEventAspect {
    public static final ThreadPriorityAspect INSTANCE = new ThreadPriorityAspect();

    private ThreadPriorityAspect() {
    }

    public final String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.AspectName_Prio);
    }

    public final String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.AspectHelpText_Prio);
    }

    @Nullable
    public Integer resolve(ITmfEvent event) {
        KernelAnalysisModule kernelAnalysis = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)event.getTrace(), KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelAnalysis == null) {
            return null;
        }
        Integer tid = KernelTidAspect.INSTANCE.resolve(event);
        if (tid == null) {
            return null;
        }
        Integer prio = KernelThreadInformationProvider.getThreadPrio(kernelAnalysis, tid, event.getTimestamp().getValue());
        return prio;
    }
}

