/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class CLIInfoBreakInfo
extends MIInfo {
    private Map<Integer, String[]> fBreakpointToGroupMap = new HashMap<Integer, String[]>();

    public CLIInfoBreakInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public Map<Integer, String[]> getBreakpointToGroupMap() {
        return this.fBreakpointToGroupMap;
    }

    protected void parse() {
        String INFERIOR_PREFIX = " inf ";
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = out.getMIOOBRecords();
            int n = mIOOBRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line;
                int loc;
                MIOOBRecord oob = mIOOBRecordArray[n2];
                if (oob instanceof MIConsoleStreamOutput && (loc = (line = ((MIConsoleStreamOutput)oob).getString().trim()).indexOf(" inf ")) >= 0) {
                    int bpId;
                    block7: {
                        String bpIdStr = line.split("[\\s\\.]", 2)[0];
                        bpId = 0;
                        try {
                            bpId = Integer.parseInt(bpIdStr);
                        }
                        catch (NumberFormatException e) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError();
                        }
                    }
                    String[] groups = this.fBreakpointToGroupMap.get(bpId);
                    HashSet<String> groupIdList = new HashSet<String>();
                    if (groups != null) {
                        groupIdList.addAll(Arrays.asList(groups));
                    }
                    String inferiorIdStr = line.substring(loc + " inf ".length()).trim();
                    String[] stringArray = inferiorIdStr.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id = stringArray[n4];
                        groupIdList.add("i" + id.trim());
                        ++n4;
                    }
                    this.fBreakpointToGroupMap.put(bpId, groupIdList.toArray(new String[groupIdList.size()]));
                }
                ++n2;
            }
        }
    }
}

