/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameter
extends PDOMNamedNode
implements ICPPParameter,
IPDOMBinding {
    private static final int NEXT_PARAM = 12;
    private static final int ANNOTATIONS = 16;
    private static final int DEFAULT_VALUE = 17;
    protected static final int RECORD_SIZE = 22;
    private final IType fType;
    private volatile IValue fDefaultValue = Value.NOT_INITIALIZED;

    public PDOMCPPParameter(PDOMLinkage linkage, long record, IType type) {
        super(linkage, record);
        this.fType = type;
    }

    public PDOMCPPParameter(PDOMLinkage linkage, PDOMNode parent, ICPPParameter param, PDOMCPPParameter next) throws CoreException {
        super(linkage, parent, param.getNameCharArray());
        this.fType = null;
        this.fDefaultValue = param.getDefaultValue();
        Database db = this.getDB();
        linkage.storeValue(this.record + 17L, this.fDefaultValue);
        db.putRecPtr(this.record + 12L, next == null ? 0L : next.getRecord());
        this.storeAnnotations(db, param);
    }

    private void storeAnnotations(Database db, ICPPParameter param) throws CoreException {
        byte annotations = PDOMCPPAnnotation.encodeAnnotation(param);
        db.putByte(this.record + 16L, annotations);
    }

    public void update(ICPPParameter newPar) throws CoreException {
        Database db = this.getDB();
        if (newPar.hasDefaultValue()) {
            ((PDOMLinkage)this.getLinkage()).storeValue(this.record + 17L, newPar.getDefaultValue());
        } else if (newPar.isParameterPack()) {
            ((PDOMLinkage)this.getLinkage()).storeValue(this.record + 17L, null);
        }
        this.storeAnnotations(db, newPar);
        char[] newName = newPar.getNameCharArray();
        if (!CharArrayUtils.equals(newName, this.getNameCharArray())) {
            this.updateName(newName);
        }
    }

    @Override
    protected int getRecordSize() {
        return 22;
    }

    @Override
    public int getNodeType() {
        return 14;
    }

    @Override
    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    @Override
    public char[][] getQualifiedNameCharArray() throws DOMException {
        return new char[][]{this.getNameCharArray()};
    }

    @Override
    public boolean isGloballyQualified() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IType getType() {
        return this.fType;
    }

    @Override
    public boolean isAuto() {
        byte flag = 1;
        return this.hasFlag(flag, true, 16);
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isRegister() {
        byte flag = 8;
        return this.hasFlag(flag, true, 16);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public IIndexScope getScope() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }

    @Override
    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    @Override
    public IValue getDefaultValue() {
        if (this.fDefaultValue == Value.NOT_INITIALIZED) {
            try {
                this.fDefaultValue = ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 17L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fDefaultValue = null;
            }
        }
        return this.fDefaultValue;
    }

    @Override
    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    private boolean hasFlag(byte flag, boolean defValue, int offset) {
        try {
            byte myflags = this.getDB().getByte(this.record + (long)offset);
            return (myflags & flag) == flag;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return defValue;
        }
    }

    @Override
    public IIndexFragment getFragment() {
        return this.getPDOM();
    }

    @Override
    public boolean hasDefinition() throws CoreException {
        return true;
    }

    @Override
    public boolean hasDeclaration() throws CoreException {
        return true;
    }

    @Override
    public int getBindingConstant() {
        return this.getNodeType();
    }

    @Override
    public void delete(PDOMLinkage linkage) throws CoreException {
        PDOMCPPParameter p = this;
        while (true) {
            long rec = p.getNextPtr();
            p.flatDelete(linkage);
            if (rec == 0L) {
                return;
            }
            p = new PDOMCPPParameter(linkage, rec, null);
        }
    }

    private void flatDelete(PDOMLinkage linkage) throws CoreException {
        linkage.storeValue(this.record + 17L, null);
        super.delete(linkage);
    }

    public long getNextPtr() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 12L);
        return rec;
    }

    @Override
    public boolean isFileLocal() throws CoreException {
        return false;
    }

    @Override
    public IIndexFile getLocalToFile() throws CoreException {
        return null;
    }

    @Override
    public IValue getInitialValue() {
        return null;
    }
}

