/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMember;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalID;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUnary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;

public class HeuristicResolver {
    public static IScope findConcreteScopeForType(IType type, IASTNode point) {
        IType fieldOwnerType;
        EvalID evalId;
        ICPPEvaluation fieldOwner;
        ICPPEvaluation evaluation;
        if (type instanceof ICPPDeferredClassInstance) {
            ICPPDeferredClassInstance instance = (ICPPDeferredClassInstance)type;
            return instance.getClassTemplate().getCompositeScope();
        }
        if (type instanceof TypeOfDependentExpression && (evaluation = ((TypeOfDependentExpression)type).getEvaluation()) instanceof EvalID && (fieldOwner = (evalId = (EvalID)evaluation).getFieldOwner()) != null && (fieldOwnerType = fieldOwner.getTypeOrFunctionSet(point)) instanceof ICPPDeferredClassInstance) {
            IType fieldType;
            ICPPDeferredClassInstance instance = (ICPPDeferredClassInstance)fieldOwnerType;
            IScope scope = instance.getClassTemplate().getCompositeScope();
            LookupData lookup = new LookupData(evalId.getName(), evalId.getTemplateArgs(), point);
            lookup.qualified = evalId.isQualified();
            try {
                CPPSemantics.lookup(lookup, scope);
            }
            catch (DOMException e) {
                return null;
            }
            IBinding[] bindings = lookup.getFoundBindings();
            if (bindings.length == 1 && bindings[0] instanceof IField && (fieldType = ((IField)bindings[0]).getType()) instanceof ICompositeType) {
                return ((ICompositeType)fieldType).getCompositeScope();
            }
        }
        return null;
    }

    private static IBinding[] lookInside(IType ownerType, boolean isPointerDeref, char[] name, ICPPTemplateArgument[] templateArgs, IASTNode point) {
        ownerType = SemanticUtil.getSimplifiedType(ownerType);
        if (isPointerDeref && ownerType instanceof IPointerType) {
            ownerType = ((IPointerType)ownerType).getType();
            isPointerDeref = false;
        }
        if (ownerType instanceof ICPPUnknownType) {
            IType lookupType = HeuristicResolver.resolveUnknownType((ICPPUnknownType)ownerType, point);
            if (isPointerDeref) {
                lookupType = (lookupType = SemanticUtil.getSimplifiedType(lookupType)) instanceof IPointerType ? ((IPointerType)lookupType).getType() : null;
            }
            if (lookupType instanceof ICPPClassType) {
                LookupData lookup = new LookupData(name, templateArgs, point);
                lookup.fHeuristicBaseLookup = true;
                try {
                    CPPSemantics.lookup(lookup, ((ICPPClassType)lookupType).getCompositeScope());
                    IBinding[] foundBindings = lookup.getFoundBindings();
                    if (foundBindings.length > 0) {
                        return foundBindings;
                    }
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    private static IType typeForBinding(IBinding binding) {
        if (binding instanceof IType) {
            return (IType)((Object)binding);
        }
        if (binding instanceof IVariable) {
            return ((IVariable)binding).getType();
        }
        if (binding instanceof IEnumerator) {
            return ((IEnumerator)binding).getType();
        }
        if (binding instanceof IFunction) {
            return ((IFunction)binding).getType();
        }
        return null;
    }

    private static IType resolveUnknownType(ICPPUnknownType type, IASTNode point) {
        if (type instanceof ICPPDeferredClassInstance) {
            return ((ICPPDeferredClassInstance)type).getClassTemplate();
        }
        if (type instanceof TypeOfDependentExpression) {
            IBinding[] candidates;
            EvalID id;
            ICPPEvaluation fieldOwner;
            ICPPEvaluation evaluation = ((TypeOfDependentExpression)type).getEvaluation();
            if (evaluation instanceof EvalUnary) {
                IType argument;
                EvalUnary unary = (EvalUnary)evaluation;
                if (unary.getOperator() == 4 && (argument = unary.getArgument().getTypeOrFunctionSet(point)) instanceof ICPPUnknownType) {
                    IType resolved = HeuristicResolver.resolveUnknownType((ICPPUnknownType)argument, point);
                    if ((resolved = SemanticUtil.getSimplifiedType(resolved)) instanceof IPointerType) {
                        return ((IPointerType)resolved).getType();
                    }
                }
            } else if (evaluation instanceof EvalID && (fieldOwner = (id = (EvalID)evaluation).getFieldOwner()) != null && (candidates = HeuristicResolver.lookInside(fieldOwner.getTypeOrFunctionSet(point), id.isPointerDeref(), id.getName(), id.getTemplateArgs(), point)).length == 1) {
                return HeuristicResolver.typeForBinding(candidates[0]);
            }
        }
        return null;
    }

    public static IBinding[] resolveUnknownBinding(ICPPUnknownBinding binding, IASTNode point) {
        if (binding instanceof ICPPDeferredClassInstance) {
            return new IBinding[]{((ICPPDeferredClassInstance)binding).getClassTemplate()};
        }
        if (binding instanceof ICPPUnknownMember) {
            return HeuristicResolver.lookInside(((ICPPUnknownMember)binding).getOwnerType(), false, binding.getNameCharArray(), null, point);
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }
}

