/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpressionList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalComma;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTExpressionList
extends ASTNode
implements ICPPASTExpressionList,
IASTAmbiguityParent {
    private IASTExpression[] expressions = new IASTExpression[2];
    private IASTImplicitName[] fImplicitNames;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;
    private ICPPEvaluation fEvaluation;

    @Override
    public CPPASTExpressionList copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTExpressionList copy(IASTNode.CopyStyle style) {
        CPPASTExpressionList copy = new CPPASTExpressionList();
        IASTExpression[] iASTExpressionArray = this.getExpressions();
        int n = iASTExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTExpression expr = iASTExpressionArray[n2];
            copy.addExpression(expr == null ? null : expr.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression[] getExpressions() {
        if (this.expressions == null) {
            return IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return ArrayUtil.trim(IASTExpression.class, this.expressions);
    }

    @Override
    public void addExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.expressions = ArrayUtil.append(this.expressions, expression);
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NESTED_EXPRESSION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTExpression[] exps = this.getExpressions();
        IASTImplicitName[] implicits = action.shouldVisitImplicitNames ? this.computeImplicitNames() : null;
        int i = 0;
        int n = exps.length;
        while (i < n) {
            if (!exps[i].accept(action)) {
                return false;
            }
            if (i < n - 1 && implicits != null && implicits[i] != null && !implicits[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTExpressionList.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    private IASTImplicitName[] computeImplicitNames() {
        if (this.fImplicitNames == null) {
            IASTExpression[] exprs = this.getExpressions();
            if (exprs.length < 2) {
                this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            this.fImplicitNames = new IASTImplicitName[exprs.length - 1];
            ICPPFunction[] overloads = this.getOverloads();
            int i = 0;
            while (i < overloads.length) {
                ICPPFunction overload = overloads[i];
                if (overload != null && !(overload instanceof CPPImplicitFunction)) {
                    CPPASTImplicitName operatorName = new CPPASTImplicitName(OverloadableOperator.COMMA, (IASTNode)this);
                    operatorName.setBinding(overload);
                    operatorName.computeOperatorOffsets(exprs[i], true);
                    this.fImplicitNames[i] = operatorName;
                }
                ++i;
            }
        }
        return this.fImplicitNames;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        return ArrayUtil.removeNulls(IASTImplicitName.class, this.computeImplicitNames());
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    private ICPPFunction[] getOverloads() {
        ICPPEvaluation eval = this.getEvaluation();
        if (eval instanceof EvalComma) {
            return ((EvalComma)eval).getOverloads(this);
        }
        return null;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.expressions == null) {
            return;
        }
        int i = 0;
        while (i < this.expressions.length) {
            if (child == this.expressions[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.expressions[i] = (IASTExpression)other;
            }
            ++i;
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        IASTExpression[] exprs = this.getExpressions();
        if (exprs.length < 2) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation[] evals = new ICPPEvaluation[exprs.length];
        int i = 0;
        while (i < evals.length) {
            evals[i] = ((ICPPASTExpression)exprs[i]).getEvaluation();
            ++i;
        }
        return new EvalComma(evals, this);
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

