/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAlignmentSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;

public abstract class CPPASTBaseDeclSpecifier
extends ASTAttributeOwner
implements ICPPASTDeclSpecifier,
IASTAmbiguityParent {
    private boolean explicit;
    private boolean friend;
    private boolean inline;
    private boolean isConst;
    private boolean isConstexpr;
    private boolean isRestrict;
    private boolean isThreadLocal;
    private boolean isVolatile;
    private int sc;
    private boolean virtual;
    private IASTAlignmentSpecifier[] alignmentSpecifiers = IASTAlignmentSpecifier.EMPTY_ALIGNMENT_SPECIFIER_ARRAY;

    @Override
    public boolean isFriend() {
        return this.friend;
    }

    @Override
    public int getStorageClass() {
        return this.sc;
    }

    @Override
    public void setStorageClass(int storageClass) {
        this.assertNotFrozen();
        this.sc = storageClass;
    }

    @Override
    public boolean isThreadLocal() {
        return this.isThreadLocal;
    }

    @Override
    public void setThreadLocal(boolean value) {
        this.assertNotFrozen();
        this.isThreadLocal = value;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public void setConst(boolean value) {
        this.assertNotFrozen();
        this.isConst = value;
    }

    @Override
    public boolean isConstexpr() {
        return this.isConstexpr;
    }

    @Override
    public void setConstexpr(boolean value) {
        this.assertNotFrozen();
        this.isConstexpr = value;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public void setVolatile(boolean value) {
        this.assertNotFrozen();
        this.isVolatile = value;
    }

    @Override
    public boolean isRestrict() {
        return this.isRestrict;
    }

    @Override
    public void setRestrict(boolean value) {
        this.assertNotFrozen();
        this.isRestrict = value;
    }

    @Override
    public boolean isInline() {
        return this.inline;
    }

    @Override
    public void setInline(boolean value) {
        this.assertNotFrozen();
        this.inline = value;
    }

    @Override
    public void setFriend(boolean value) {
        this.assertNotFrozen();
        this.friend = value;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public void setVirtual(boolean value) {
        this.assertNotFrozen();
        this.virtual = value;
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public void setExplicit(boolean value) {
        this.assertNotFrozen();
        this.explicit = value;
    }

    @Override
    public IASTAlignmentSpecifier[] getAlignmentSpecifiers() {
        return this.alignmentSpecifiers;
    }

    @Override
    public void setAlignmentSpecifiers(IASTAlignmentSpecifier[] alignmentSpecifiers) {
        this.assertNotFrozen();
        IASTAlignmentSpecifier[] iASTAlignmentSpecifierArray = alignmentSpecifiers;
        int n = alignmentSpecifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAlignmentSpecifier specifier = iASTAlignmentSpecifierArray[n2];
            specifier.setParent(this);
            specifier.setPropertyInParent(ALIGNMENT_SPECIFIER);
            ++n2;
        }
        this.alignmentSpecifiers = alignmentSpecifiers;
    }

    @Override
    protected <T extends CPPASTBaseDeclSpecifier> T copy(T copy, IASTNode.CopyStyle style) {
        T target = copy;
        target.explicit = this.explicit;
        target.friend = this.friend;
        target.inline = this.inline;
        target.isConst = this.isConst;
        target.isConstexpr = this.isConstexpr;
        target.isRestrict = this.isRestrict;
        target.isThreadLocal = this.isThreadLocal;
        target.isVolatile = this.isVolatile;
        target.sc = this.sc;
        target.virtual = this.virtual;
        target.alignmentSpecifiers = new IASTAlignmentSpecifier[this.alignmentSpecifiers.length];
        int i = 0;
        while (i < this.alignmentSpecifiers.length) {
            target.alignmentSpecifiers[i] = this.alignmentSpecifiers[i].copy(style);
            target.alignmentSpecifiers[i].setParent(target);
            ++i;
        }
        return super.copy(copy, style);
    }

    public String toString() {
        return ASTStringUtil.getSignatureString(this, null);
    }

    protected boolean visitAlignmentSpecifiers(ASTVisitor visitor) {
        IASTAlignmentSpecifier[] iASTAlignmentSpecifierArray = this.alignmentSpecifiers;
        int n = this.alignmentSpecifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAlignmentSpecifier specifier = iASTAlignmentSpecifierArray[n2];
            if (!specifier.accept(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child instanceof IASTAlignmentSpecifier && other instanceof IASTAlignmentSpecifier) {
            int i = 0;
            while (i < this.alignmentSpecifiers.length) {
                if (this.alignmentSpecifiers[i] == child) {
                    this.alignmentSpecifiers[i] = (IASTAlignmentSpecifier)other;
                    other.setParent(child.getParent());
                    other.setPropertyInParent(child.getPropertyInParent());
                    return;
                }
                ++i;
            }
        }
    }
}

