/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.IConnectHandler;
import org.eclipse.cdt.debug.core.model.IDebugNewExecutableHandler;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignalHandler;
import org.eclipse.cdt.debug.core.model.IReverseResumeHandler;
import org.eclipse.cdt.debug.core.model.IReverseStepIntoHandler;
import org.eclipse.cdt.debug.core.model.IReverseStepOverHandler;
import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.cdt.debug.core.model.ISaveTraceDataHandler;
import org.eclipse.cdt.debug.core.model.IStartTracingHandler;
import org.eclipse.cdt.debug.core.model.IStepIntoSelectionHandler;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.core.model.IStopTracingHandler;
import org.eclipse.cdt.debug.core.model.IUncallHandler;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepIntoSelectionCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.DsfSourceDisplayAdapter;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.DefaultRefreshAllTarget;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.IRefreshAllTarget;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.DefaultDsfModelSelectionPolicyFactory;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.commands.ISelectNextTraceRecordHandler;
import org.eclipse.cdt.dsf.gdb.internal.commands.ISelectPrevTraceRecordHandler;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbDebugTextHover;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbPinProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbSuspendTrigger;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.DsfTerminateCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbDisconnectCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbRestartCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbSteppingModeTarget;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbConnectCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbDebugNewExecutableCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbResumeWithoutSignalCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbReverseResumeCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbReverseStepIntoCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbReverseStepOverCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbReverseToggleCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbSaveTraceDataCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbSelectNextTraceRecordCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbSelectPrevTraceRecordCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbStartTracingCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbStopTracingCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.GdbUncallCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbViewModelAdapter;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IRestartHandler;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

@Immutable
public class GdbSessionAdapters {
    private final ILaunch fLaunch;
    private final DsfSession fSession;
    private final Map<Class<?>, Object> fLaunchAdapters = new HashMap();
    private final Class<?>[] fLaunchAdapterTypes;

    public GdbSessionAdapters(ILaunch launch, DsfSession session, Class<?>[] launchAdapterTypes) {
        this.fLaunch = launch;
        this.fSession = session;
        this.fLaunchAdapterTypes = launchAdapterTypes;
        this.createAdapters();
    }

    protected void createAdapters() {
        for (Class<?> adapterType : this.getModelAdapters()) {
            Object adapter = this.createModelAdapter(adapterType, this.getLaunch(), this.getSession());
            if (adapter == null) continue;
            this.getSession().registerModelAdapter(adapterType, adapter);
        }
        Class<?>[] classArray = this.fLaunchAdapterTypes;
        int n = this.fLaunchAdapterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> adapterType;
            adapterType = classArray[n2];
            Object adapter = this.createLaunchAdapter(adapterType, this.getLaunch(), this.getSession());
            if (adapter != null) {
                this.fLaunchAdapters.put(adapterType, adapter);
            }
            ++n2;
        }
    }

    public <T> T getModelAdapter(Class<T> adapterType) {
        return (T)this.fSession.getModelAdapter(adapterType);
    }

    public <T> T getLaunchAdapter(Class<T> adapterType) {
        if (adapterType.equals(ITerminateHandler.class) || adapterType.equals(IConnectHandler.class) || adapterType.equals(IDisconnectHandler.class) || adapterType.equals(IDebugNewExecutableHandler.class)) {
            return (T)this.fSession.getModelAdapter(adapterType);
        }
        return (T)this.fLaunchAdapters.get(adapterType);
    }

    public void dispose() {
        for (Class<?> adapterType : this.getModelAdapters()) {
            Object adapter = this.getSession().getModelAdapter(adapterType);
            if (adapter == null) continue;
            this.getSession().unregisterModelAdapter(adapterType);
            this.disposeAdapter(adapter);
        }
        Class<?>[] classArray = this.fLaunchAdapterTypes;
        int n = this.fLaunchAdapterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> adapterType;
            adapterType = classArray[n2];
            Object adapter = this.fLaunchAdapters.remove(adapterType);
            if (adapter != null) {
                this.disposeAdapter(adapter);
            }
            ++n2;
        }
    }

    protected List<Class<?>> getModelAdapters() {
        return new ArrayList(Arrays.asList(SteppingController.class, IViewerInputProvider.class, ISteppingModeTarget.class, ISourceDisplay.class, IStepIntoHandler.class, IStepIntoSelectionHandler.class, IReverseStepIntoHandler.class, IStepOverHandler.class, IReverseStepOverHandler.class, IStepReturnHandler.class, IUncallHandler.class, ISuspendHandler.class, IResumeHandler.class, IReverseResumeHandler.class, IResumeWithoutSignalHandler.class, IRestartHandler.class, ITerminateHandler.class, IDebugNewExecutableHandler.class, IConnectHandler.class, IDisconnectHandler.class, IModelSelectionPolicyFactory.class, IRefreshAllTarget.class, IReverseToggleHandler.class, IStartTracingHandler.class, IStopTracingHandler.class, ISaveTraceDataHandler.class, ISelectNextTraceRecordHandler.class, ISelectPrevTraceRecordHandler.class, IPinProvider.class, IDebugModelProvider.class, ILaunch.class, ICEditorTextHover.class));
    }

    protected <T> T createLaunchAdapter(Class<T> adapterType, ILaunch launch, DsfSession session) {
        if (adapterType.equals(IElementContentProvider.class) || adapterType.equals(IModelProxyFactory.class) || adapterType.equals(IColumnPresentationFactory.class)) {
            return (T)this.getViewModelAdapter();
        }
        if (adapterType.equals(ISuspendTrigger.class)) {
            return (T)((Object)new GdbSuspendTrigger(session, launch));
        }
        return null;
    }

    protected <T> T createModelAdapter(Class<T> adapterType, ILaunch launch, DsfSession session) {
        if (SteppingController.class.equals(adapterType)) {
            return (T)new SteppingController(session);
        }
        if (IViewerInputProvider.class.equals(adapterType)) {
            return (T)((Object)new GdbViewModelAdapter(session, this.getSteppingController()));
        }
        if (ISteppingModeTarget.class.equals(adapterType)) {
            return (T)((Object)new GdbSteppingModeTarget(session));
        }
        if (ISourceDisplay.class.equals(adapterType)) {
            return (T)(launch.getSourceLocator() instanceof ISourceLookupDirector ? new DsfSourceDisplayAdapter(session, (ISourceLookupDirector)launch.getSourceLocator(), this.getSteppingController()) : null);
        }
        if (IStepIntoHandler.class.equals(adapterType)) {
            return (T)new DsfStepIntoCommand(session, this.getSteppingModeTarget());
        }
        if (IStepIntoSelectionHandler.class.equals(adapterType)) {
            return (T)new DsfStepIntoSelectionCommand(session);
        }
        if (IReverseStepIntoHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbReverseStepIntoCommand(session, this.getSteppingModeTarget()));
        }
        if (IStepOverHandler.class.equals(adapterType)) {
            return (T)new DsfStepOverCommand(session, this.getSteppingModeTarget());
        }
        if (IReverseStepOverHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbReverseStepOverCommand(session, this.getSteppingModeTarget()));
        }
        if (IStepReturnHandler.class.equals(adapterType)) {
            return (T)new DsfStepReturnCommand(session);
        }
        if (IUncallHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbUncallCommand(session, this.getSteppingModeTarget()));
        }
        if (ISuspendHandler.class.equals(adapterType)) {
            return (T)new DsfSuspendCommand(session);
        }
        if (IResumeHandler.class.equals(adapterType)) {
            return (T)new DsfResumeCommand(session);
        }
        if (IReverseResumeHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbReverseResumeCommand(session));
        }
        if (IResumeWithoutSignalHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbResumeWithoutSignalCommand(session));
        }
        if (IRestartHandler.class.equals(adapterType)) {
            return (T)new GdbRestartCommand(session, this.getLaunch());
        }
        if (ITerminateHandler.class.equals(adapterType)) {
            return (T)new DsfTerminateCommand(session);
        }
        if (IDebugNewExecutableHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbDebugNewExecutableCommand(session, launch));
        }
        if (IConnectHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbConnectCommand(session, launch));
        }
        if (IDisconnectHandler.class.equals(adapterType)) {
            return (T)new GdbDisconnectCommand(session);
        }
        if (IModelSelectionPolicyFactory.class.equals(adapterType)) {
            return (T)new DefaultDsfModelSelectionPolicyFactory();
        }
        if (IRefreshAllTarget.class.equals(adapterType)) {
            return (T)new DefaultRefreshAllTarget();
        }
        if (IReverseToggleHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbReverseToggleCommand(session));
        }
        if (IStartTracingHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbStartTracingCommand(session));
        }
        if (IStopTracingHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbStopTracingCommand(session));
        }
        if (ISaveTraceDataHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbSaveTraceDataCommand(session));
        }
        if (ISelectNextTraceRecordHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbSelectNextTraceRecordCommand(session));
        }
        if (ISelectPrevTraceRecordHandler.class.equals(adapterType)) {
            return (T)((Object)new GdbSelectPrevTraceRecordCommand(session));
        }
        if (IPinProvider.class.equals(adapterType)) {
            return (T)new GdbPinProvider(session);
        }
        if (IDebugModelProvider.class.equals(adapterType)) {
            return (T)new IDebugModelProvider(){

                public String[] getModelIdentifiers() {
                    return new String[]{"org.eclipse.cdt.dsf.gdb", ICBreakpoint.C_BREAKPOINTS_DEBUG_MODEL_ID, "org.eclipse.cdt.gdb"};
                }
            };
        }
        if (ILaunch.class.equals(adapterType)) {
            return (T)launch;
        }
        if (ICEditorTextHover.class.equals(adapterType)) {
            return (T)((Object)new GdbDebugTextHover());
        }
        return null;
    }

    protected Method getDisposeMethod(Object adapter) {
        if (adapter != null) {
            try {
                return adapter.getClass().getMethod("dispose", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void disposeAdapter(Object adapter) {
        try {
            Method dispose = this.getDisposeMethod(adapter);
            if (dispose != null) {
                dispose.invoke(adapter, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException dispose) {
        }
        catch (InvocationTargetException e) {
            GdbPlugin.log((Throwable)e.getTargetException());
        }
    }

    protected DsfSteppingModeTarget getSteppingModeTarget() {
        ISteppingModeTarget target = (ISteppingModeTarget)this.fSession.getModelAdapter(ISteppingModeTarget.class);
        if (target instanceof DsfSteppingModeTarget) {
            return (DsfSteppingModeTarget)target;
        }
        return null;
    }

    protected SteppingController getSteppingController() {
        return (SteppingController)this.fSession.getModelAdapter(SteppingController.class);
    }

    protected IVMAdapter getViewModelAdapter() {
        IViewerInputProvider provider = (IViewerInputProvider)this.fSession.getModelAdapter(IViewerInputProvider.class);
        if (provider instanceof IVMAdapter) {
            return (IVMAdapter)provider;
        }
        return null;
    }
}

