/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint2;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class Watchpoint
extends Breakpoint
implements ICDIWatchpoint2 {
    int watchType;
    String expression;
    String memorySpace;
    BigInteger range;
    String derivedExpression;

    public Watchpoint(Target target, String expression, int type, int watchType, ICDICondition condition, boolean enabled) {
        this(target, expression, "", BigInteger.ZERO, type, watchType, condition, enabled);
    }

    public Watchpoint(Target target, String expression, String memorySpace, BigInteger range, int type, int watchType, ICDICondition cond, boolean enabled) {
        super(target, type, cond, enabled);
        boolean doSpecify;
        this.watchType = watchType;
        this.expression = expression;
        this.memorySpace = memorySpace;
        this.range = range;
        this.derivedExpression = "";
        boolean doSpecifyMemorySpace = memorySpace.length() > 0;
        boolean doSpecifyRange = range.compareTo(BigInteger.ZERO) > 0;
        boolean bl = doSpecify = doSpecifyMemorySpace || doSpecifyRange;
        if (doSpecify) {
            this.derivedExpression = String.valueOf(this.derivedExpression) + "(";
            if (doSpecifyMemorySpace) {
                this.derivedExpression = String.valueOf(this.derivedExpression) + "@" + memorySpace;
                if (doSpecifyRange) {
                    this.derivedExpression = String.valueOf(this.derivedExpression) + " ";
                }
            }
            if (doSpecifyRange) {
                this.derivedExpression = String.valueOf(this.derivedExpression) + "char[" + range.toString() + "]";
            }
            this.derivedExpression = String.valueOf(this.derivedExpression) + ")(";
        }
        try {
            Integer.decode(expression);
            this.derivedExpression = String.valueOf(this.derivedExpression) + '*';
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.derivedExpression = String.valueOf(this.derivedExpression) + expression;
        if (doSpecify) {
            this.derivedExpression = String.valueOf(this.derivedExpression) + ")";
        }
    }

    public String getWatchExpression() throws CDIException {
        MIBreakpoint[] miPoints;
        if (this.expression == null && (miPoints = this.getMIBreakpoints()) != null && miPoints.length > 0) {
            return miPoints[0].getWhat();
        }
        return this.expression;
    }

    public boolean isReadType() {
        return (this.watchType & 2) == 2;
    }

    public boolean isWriteType() {
        return (this.watchType & 1) == 1;
    }

    public String getMemorySpace() throws CDIException {
        return this.memorySpace;
    }

    public BigInteger getRange() throws CDIException {
        return this.range;
    }

    public String getDerivedExpression() {
        return this.derivedExpression;
    }
}

