/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDIFileLocation;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIAddressBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIAddressToSource;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpointManagement3;
import org.eclipse.cdt.debug.core.cdi.model.ICDIEventBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExceptionpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExecuteMoveInstructionPointer;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIFunctionBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIGlobalVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIGlobalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDILineBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.CoreProcess;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.AddressBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CoreFileConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.model.GlobalVariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.LineBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocationBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.MappedSourceLocation;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.RuntimeOptions;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.TargetConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.CLIInfoLine;
import org.eclipse.cdt.debug.mi.core.command.CLIInfoThreads;
import org.eclipse.cdt.debug.mi.core.command.CLIJump;
import org.eclipse.cdt.debug.mi.core.command.CLISignal;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecRun;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecUntil;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowEndian;
import org.eclipse.cdt.debug.mi.core.command.MITargetDetach;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.output.CLIInfoLineInfo;
import org.eclipse.cdt.debug.mi.core.output.CLIInfoThreadsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowEndianInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIThreadSelectInfo;

public class Target
extends SessionObject
implements ICDITarget,
ICDIBreakpointManagement3,
ICDIAddressToSource,
ICDIExecuteMoveInstructionPointer {
    MISession miSession;
    ICDITargetConfiguration fConfiguration;
    Thread[] noThreads = new Thread[0];
    Thread[] currentThreads;
    int currentThreadId;
    String fEndian = null;
    boolean suspended = true;
    boolean deferBreakpoints = true;
    private final Object lock = new Object();

    public Target(Session s, MISession mi) {
        super(s);
        this.miSession = mi;
        this.currentThreads = this.noThreads;
    }

    public Object getLock() {
        return this.lock;
    }

    public MISession getMISession() {
        return this.miSession;
    }

    public void setConfiguration(ICDITargetConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    public ICDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(ICDIThread cthread) throws CDIException {
        if (!(cthread instanceof Thread)) {
            throw new CDIException(CdiResources.getString("cdi.model.Target.Unknown_thread"));
        }
        this.setCurrentThread(cthread, true);
    }

    public void setCurrentThread(ICDIThread cthread, boolean doUpdate) throws CDIException {
        if (!(cthread instanceof Thread)) {
            throw new CDIException(CdiResources.getString("cdi.model.Target.Unknown_thread"));
        }
        this.setCurrentThread((Thread)cthread, doUpdate);
    }

    public synchronized void setSupended(boolean state) {
        this.suspended = state;
        this.notifyAll();
    }

    public void setCurrentThread(Thread cthread, boolean doUpdate) throws CDIException {
        int id = cthread.getId();
        if (id == 0) {
            return;
        }
        if (this.currentThreadId != id) {
            CommandFactory factory = this.miSession.getCommandFactory();
            MIThreadSelect select = factory.createMIThreadSelect(id);
            try {
                this.miSession.postCommand(select);
                MIThreadSelectInfo info = select.getMIThreadSelectInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
                }
                this.currentThreadId = info.getNewThreadId();
                MIFrame miFrame = info.getFrame();
                if (miFrame != null) {
                    int depth = cthread.getStackFrameCount();
                    cthread.currentFrame = new StackFrame(cthread, miFrame, depth - miFrame.getLevel());
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Session session = (Session)this.getSession();
            if (doUpdate) {
                VariableManager varMgr;
                RegisterManager regMgr = session.getRegisterManager();
                if (regMgr.isAutoUpdate()) {
                    regMgr.update(this);
                }
                if ((varMgr = session.getVariableManager()).isAutoUpdate()) {
                    varMgr.update(this);
                }
            }
        }
        if (this.currentThreadId != id) {
            this.miSession.fireEvent(new MIThreadExitEvent(this.miSession, id));
            throw new CDIException(String.valueOf(CdiResources.getString("cdi.model.Target.Cannot_switch_to_thread")) + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateState(int newThreadId) {
        int j;
        Thread[] oldThreads = this.currentThreads;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.currentThreadId = newThreadId;
                this.currentThreads = this.getCThreads();
            }
            catch (CDIException e) {
                this.currentThreads = this.noThreads;
            }
        }
        ArrayList<Integer> cList = new ArrayList<Integer>(this.currentThreads.length);
        int i = 0;
        while (i < this.currentThreads.length) {
            boolean found = false;
            j = 0;
            while (j < oldThreads.length) {
                if (this.currentThreads[i].getId() == oldThreads[j].getId()) {
                    oldThreads[j].clearState();
                    this.currentThreads[i] = oldThreads[j];
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                cList.add(new Integer(this.currentThreads[i].getId()));
            }
            ++i;
        }
        if (!cList.isEmpty()) {
            MIEvent[] events = new MIThreadCreatedEvent[cList.size()];
            int j2 = 0;
            while (j2 < events.length) {
                int id = (Integer)cList.get(j2);
                events[j2] = new MIThreadCreatedEvent(this.miSession, id);
                ++j2;
            }
            this.miSession.fireEvents(events);
        }
        ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
        int i2 = 0;
        while (i2 < oldThreads.length) {
            boolean found = false;
            int j3 = 0;
            while (j3 < this.currentThreads.length) {
                if (this.currentThreads[j3].getId() == oldThreads[i2].getId()) {
                    found = true;
                    break;
                }
                ++j3;
            }
            if (!found) {
                dList.add(new Integer(oldThreads[i2].getId()));
            }
            ++i2;
        }
        if (!dList.isEmpty()) {
            MIEvent[] events = new MIThreadExitEvent[dList.size()];
            j = 0;
            while (j < events.length) {
                int id = (Integer)dList.get(j);
                events[j] = new MIThreadExitEvent(this.miSession, id);
                ++j;
            }
            this.miSession.fireEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread[] getCThreads() throws CDIException {
        Thread[] cthreads = this.noThreads;
        Object object = this.lock;
        synchronized (object) {
            RxThread rxThread = this.miSession.getRxThread();
            rxThread.setEnableConsole(false);
            try {
                try {
                    String[] names;
                    int[] ids;
                    CommandFactory factory = this.miSession.getCommandFactory();
                    CLIInfoThreads tids = factory.createCLIInfoThreads();
                    this.miSession.postCommand(tids);
                    CLIInfoThreadsInfo info = tids.getMIInfoThreadsInfo();
                    if (info == null) {
                        ids = new int[]{};
                        names = new String[]{};
                    } else {
                        ids = info.getThreadIds();
                        names = info.getThreadNames();
                        this.currentThreadId = info.getCurrentThread();
                    }
                    if (ids != null && ids.length > 0) {
                        cthreads = new Thread[ids.length];
                        if (names != null && names.length == ids.length) {
                            int i = 0;
                            while (i < ids.length) {
                                cthreads[i] = new Thread(this, ids[i], names[i]);
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < ids.length) {
                                cthreads[i] = new Thread(this, ids[i]);
                                ++i;
                            }
                        }
                    } else {
                        cthreads = new Thread[]{new Thread(this, 0)};
                    }
                    if (this.currentThreadId == 0 && cthreads.length > 0) {
                        this.setCurrentThread(cthreads[0], false);
                    }
                }
                catch (MIException e) {
                    throw new CDIException(e.getMessage());
                }
            }
            finally {
                rxThread.setEnableConsole(true);
            }
        }
        return cthreads;
    }

    public ICDIThread getCurrentThread() throws CDIException {
        ICDIThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            Thread cthread = (Thread)threads[i];
            if (cthread.getId() == this.currentThreadId) {
                return cthread;
            }
            ++i;
        }
        return null;
    }

    public synchronized ICDIThread[] getThreads() throws CDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getCThreads();
        }
        return this.currentThreads;
    }

    public ICDIThread getThread(int tid) {
        Thread th = null;
        if (this.currentThreads != null) {
            int i = 0;
            while (i < this.currentThreads.length) {
                Thread cthread = this.currentThreads[i];
                if (cthread.getId() == tid) {
                    th = cthread;
                    break;
                }
                ++i;
            }
        }
        return th;
    }

    public boolean isLittleEndian() throws CDIException {
        if (this.fEndian == null) {
            CommandFactory factory = this.miSession.getCommandFactory();
            MIGDBShowEndian endian = factory.createMIGDBShowEndian();
            try {
                this.miSession.postCommand(endian);
                MIGDBShowEndianInfo info = endian.getMIShowEndianInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
                }
                this.fEndian = info.isLittleEndian() ? "le" : "be";
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return this.fEndian.equals("le");
    }

    public void restart() throws CDIException {
        MIInferior inferior = this.getMISession().getMIInferior();
        int pid = inferior.resetInferiorPID();
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecRun run = factory.createMIExecRun(new String[0]);
        try {
            this.miSession.postCommand(run);
            MIInfo info = run.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            inferior.setInferiorPID(pid);
            throw new MI2CDIException(e);
        }
    }

    public void stepInto() throws CDIException {
        this.stepInto(1);
    }

    public void stepInto(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecStep step = factory.createMIExecStep(count);
        try {
            this.miSession.postCommand(step);
            MIInfo info = step.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepIntoInstruction() throws CDIException {
        this.stepIntoInstruction(1);
    }

    public void stepIntoInstruction(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecStepInstruction stepi = factory.createMIExecStepInstruction(count);
        try {
            this.miSession.postCommand(stepi);
            MIInfo info = stepi.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepOver() throws CDIException {
        this.stepOver(1);
    }

    public void stepOver(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecNext next = factory.createMIExecNext(count);
        try {
            this.miSession.postCommand(next);
            MIInfo info = next.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepOverInstruction() throws CDIException {
        this.stepOverInstruction(1);
    }

    public void stepOverInstruction(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecNextInstruction nexti = factory.createMIExecNextInstruction(count);
        try {
            this.miSession.postCommand(nexti);
            MIInfo info = nexti.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepReturn() throws CDIException {
        ((Thread)this.getCurrentThread()).getCurrentStackFrame().stepReturn();
    }

    public void runUntil(ICDILocation location) throws CDIException {
        this.stepUntil(location);
    }

    public void stepUntil(ICDILocation location) throws CDIException {
        ICDIAddressLocation addrLocation;
        String filePath;
        CommandFactory factory = this.miSession.getCommandFactory();
        String loc = null;
        File file = null;
        if (location instanceof ICDIFileLocation && (filePath = ((ICDIFileLocation)location).getFile()) != null && filePath.length() > 0) {
            file = new File(filePath);
        }
        if (location instanceof ICDILineLocation) {
            ICDILineLocation lineLocation = (ICDILineLocation)location;
            if (file != null) {
                loc = String.valueOf(file.getName()) + ":" + lineLocation.getLineNumber();
            }
        } else if (location instanceof ICDIFunctionLocation) {
            ICDIFunctionLocation funcLocation = (ICDIFunctionLocation)location;
            if (funcLocation.getFunction() != null && funcLocation.getFunction().length() > 0) {
                loc = funcLocation.getFunction();
            }
            if (file != null && loc != null) {
                loc = String.valueOf(funcLocation.getFile()) + ":" + loc;
            }
        } else if (location instanceof ICDIAddressLocation && !(addrLocation = (ICDIAddressLocation)location).getAddress().equals(BigInteger.ZERO)) {
            loc = "*0x" + addrLocation.getAddress().toString(16);
        }
        if (loc == null) {
            throw new CDIException(CdiResources.getString("cdi.mode.Target.Bad_location"));
        }
        MIExecUntil until = factory.createMIExecUntil(loc);
        try {
            this.miSession.postCommand(until);
            MIInfo info = until.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws CDIException {
        try {
            this.miSession.getMIInferior().interrupt();
            long maxSec = this.miSession.getCommandTimeout() / 1000L + 1L;
            Target target = this;
            synchronized (target) {
                int i = 0;
                while (!this.suspended && (long)i < maxSec) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void disconnect() throws CDIException {
        if (this.isRunning()) {
            try {
                ((EventManager)this.getSession().getEventManager()).allowProcessingEvents(false);
                this.suspend();
            }
            finally {
                ((EventManager)this.getSession().getEventManager()).allowProcessingEvents(true);
            }
        }
        CommandFactory factory = this.miSession.getCommandFactory();
        MITargetDetach detach = factory.createMITargetDetach();
        try {
            this.miSession.postCommand(detach);
            MIInfo info = detach.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.miSession.fireEvent(new MIDetachedEvent(this.miSession, detach.getToken()));
        this.miSession.getMIInferior().setDisconnected();
    }

    public void resume() throws CDIException {
        this.resume(false);
    }

    public void resume(ICDILocation location) throws CDIException {
        ICDIAddressLocation addrLocation;
        String filePath;
        CommandFactory factory = this.miSession.getCommandFactory();
        String loc = null;
        File file = null;
        if (location instanceof ICDIFileLocation && (filePath = ((ICDIFileLocation)location).getFile()) != null && filePath.length() > 0) {
            file = new File(filePath);
        }
        if (location instanceof ICDILineLocation) {
            ICDILineLocation lineLocation = (ICDILineLocation)location;
            if (file != null) {
                loc = String.valueOf(file.getName()) + ":" + lineLocation.getLineNumber();
            }
        } else if (location instanceof ICDIFunctionLocation) {
            ICDIFunctionLocation funcLocation = (ICDIFunctionLocation)location;
            if (funcLocation.getFunction() != null && funcLocation.getFunction().length() > 0) {
                loc = funcLocation.getFunction();
            }
            if (file != null && loc != null) {
                loc = String.valueOf(funcLocation.getFile()) + ":" + loc;
            }
        } else if (location instanceof ICDIAddressLocation && !(addrLocation = (ICDIAddressLocation)location).getAddress().equals(BigInteger.ZERO)) {
            loc = "*0x" + addrLocation.getAddress().toString(16);
        }
        if (loc == null) {
            throw new CDIException(CdiResources.getString("cdi.mode.Target.Bad_location"));
        }
        CLIJump jump = factory.createCLIJump(loc);
        try {
            this.miSession.postCommand(jump);
            MIInfo info = jump.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void moveInstructionPointer(ICDILocation location) throws CDIException {
        String filePath;
        CommandFactory factory = this.miSession.getCommandFactory();
        LocationBreakpoint bkpt = null;
        String loc = null;
        File file = null;
        if (location instanceof ICDIFileLocation && (filePath = ((ICDIFileLocation)location).getFile()) != null && filePath.length() > 0) {
            file = new File(filePath);
        }
        if (location instanceof ICDILineLocation) {
            ICDILineLocation lineLocation = (ICDILineLocation)location;
            if (file != null) {
                loc = String.valueOf(file.getName()) + ":" + lineLocation.getLineNumber();
            }
            bkpt = new LineBreakpoint(this, 1, lineLocation, null, true);
        } else if (location instanceof ICDIAddressLocation) {
            ICDIAddressLocation addrLocation = (ICDIAddressLocation)location;
            if (!addrLocation.getAddress().equals(BigInteger.ZERO)) {
                loc = "*0x" + addrLocation.getAddress().toString(16);
            }
            bkpt = new AddressBreakpoint(this, 1, (ICDILocation)addrLocation, null, true);
        }
        if (loc == null) {
            throw new CDIException(CdiResources.getString("cdi.mode.Target.Bad_location"));
        }
        Session session = (Session)this.getSession();
        session.getBreakpointManager().setLocationBreakpoint(bkpt);
        CLIJump jump = factory.createCLIJump(loc);
        try {
            this.miSession.postCommand(jump);
            MIInfo info = jump.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void resume(ICDISignal signal) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        CLISignal sig = factory.createCLISignal(signal.getName());
        try {
            this.miSession.postCommand(sig);
            MIInfo info = sig.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void resume(boolean passSignal) throws CDIException {
        block9: {
            if (this.miSession.getMIInferior().isRunning()) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Inferior_already_running"));
            }
            if (this.miSession.getMIInferior().isSuspended()) {
                if (passSignal) {
                    CommandFactory factory = this.miSession.getCommandFactory();
                    CLISignal signal = factory.createCLISignal("0");
                    try {
                        this.miSession.postCommand(signal);
                        MIInfo info = signal.getMIInfo();
                        if (info == null) {
                            throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
                        }
                        break block9;
                    }
                    catch (MIException e) {
                        throw new MI2CDIException(e);
                    }
                }
                this.continuation();
            } else if (this.miSession.getMIInferior().isTerminated()) {
                this.restart();
            } else {
                this.restart();
            }
        }
    }

    public void continuation() throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecContinue cont = factory.createMIExecContinue();
        try {
            this.miSession.postCommand(cont);
            MIInfo info = cont.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void jump(ICDILocation location) throws CDIException {
        this.resume(location);
    }

    public void signal() throws CDIException {
        this.resume(true);
    }

    public void signal(ICDISignal signal) throws CDIException {
        this.resume(signal);
    }

    public String evaluateExpressionToString(ICDIStackFrame frame, String expressionText) throws CDIException {
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame((StackFrame)frame, false);
        try {
            CommandFactory factory = this.miSession.getCommandFactory();
            MIDataEvaluateExpression evaluate = factory.createMIDataEvaluateExpression(expressionText);
            this.miSession.postCommand(evaluate);
            MIDataEvaluateExpressionInfo info = evaluate.getMIDataEvaluateExpressionInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
            String string = info.getExpression();
            return string;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
        }
    }

    public void terminate() throws CDIException {
        try {
            this.miSession.getMIInferior().terminate();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isTerminated() {
        return this.miSession.getMIInferior().isTerminated();
    }

    public boolean isDisconnected() {
        return !this.miSession.getMIInferior().isConnected();
    }

    public boolean isSuspended() {
        return this.miSession.getMIInferior().isSuspended();
    }

    public boolean isRunning() {
        return this.miSession.getMIInferior().isRunning();
    }

    public Process getProcess() {
        if (this.miSession.isCoreSession()) {
            return new CoreProcess();
        }
        return this.miSession.getMIInferior();
    }

    public ICDILineBreakpoint setLineBreakpoint(int type, ICDILineLocation location, ICDICondition condition, boolean deferred) throws CDIException {
        return this.setLineBreakpoint(type, location, condition, deferred, true);
    }

    public ICDIFunctionBreakpoint setFunctionBreakpoint(int type, ICDIFunctionLocation location, ICDICondition condition, boolean deferred) throws CDIException {
        return this.setFunctionBreakpoint(type, location, condition, deferred, true);
    }

    public ICDIAddressBreakpoint setAddressBreakpoint(int type, ICDIAddressLocation location, ICDICondition condition, boolean deferred) throws CDIException {
        return this.setAddressBreakpoint(type, location, condition, deferred, true);
    }

    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, ICDICondition condition) throws CDIException {
        return this.setWatchpoint(type, watchType, expression, condition, true);
    }

    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, ICDICondition condition, boolean enabled) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        Watchpoint bkpt = new Watchpoint(this, expression, type, watchType, condition, enabled);
        bMgr.setWatchpoint(bkpt);
        return bkpt;
    }

    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, String memorySpace, BigInteger range, ICDICondition condition, boolean enabled) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        Watchpoint bkpt = new Watchpoint(this, expression, memorySpace, range, type, watchType, condition, enabled);
        bMgr.setWatchpoint(bkpt);
        return bkpt;
    }

    public ICDIExceptionpoint setExceptionBreakpoint(String clazz, boolean stopOnThrow, boolean stopOnCatch) throws CDIException {
        throw new CDIException(CdiResources.getString("cdi.Common.Not_implemented"));
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.getBreakpoints(this);
    }

    public void deleteBreakpoints(ICDIBreakpoint[] breakpoints) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        bMgr.deleteBreakpoints(this, breakpoints);
    }

    public void deleteAllBreakpoints() throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        bMgr.deleteAllBreakpoints(this);
    }

    public ICDICondition createCondition(int ignoreCount, String expression) {
        return this.createCondition(ignoreCount, expression, null);
    }

    public ICDICondition createCondition(int ignoreCount, String expression, String[] tids) {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.createCondition(ignoreCount, expression, tids);
    }

    public ICDILineLocation createLineLocation(String file, int line) {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.createLineLocation(file, line);
    }

    public ICDIFunctionLocation createFunctionLocation(String file, String function) {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.createFunctionLocation(file, function);
    }

    public ICDIAddressLocation createAddressLocation(BigInteger address) {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.createAddressLocation(address);
    }

    public ICDIRuntimeOptions getRuntimeOptions() {
        return new RuntimeOptions(this);
    }

    public ICDIExpression createExpression(String code) throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.createExpression(this, code);
    }

    public ICDIExpression[] getExpressions() throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.getExpressions(this);
    }

    public void destroyExpressions(ICDIExpression[] expressions) throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyExpressions(this, expressions);
    }

    public void destroyAllExpressions() throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyAllExpressions(this);
    }

    public ICDISignal[] getSignals() throws CDIException {
        SignalManager sigMgr = ((Session)this.getSession()).getSignalManager();
        return sigMgr.getSignals(this);
    }

    public void setSourcePaths(String[] srcPaths) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        srcMgr.setSourcePaths(this, srcPaths);
    }

    public String[] getSourcePaths() throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getSourcePaths(this);
    }

    public ICDIInstruction[] getInstructions(BigInteger startAddress, BigInteger endAddress) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getInstructions(this, startAddress, endAddress);
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getInstructions(this, filename, linenum);
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum, int lines) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getInstructions(this, filename, linenum, lines);
    }

    public ICDIMixedInstruction[] getMixedInstructions(BigInteger startAddress, BigInteger endAddress) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getMixedInstructions(this, startAddress, endAddress);
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getMixedInstructions(this, filename, linenum);
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum, int lines) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getMixedInstructions(this, filename, linenum, lines);
    }

    public ICDIMemoryBlock createMemoryBlock(String address, int units, int wordSize) throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        return memMgr.createMemoryBlock(this, address, units, wordSize);
    }

    public void removeBlocks(ICDIMemoryBlock[] memoryBlocks) throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        memMgr.removeBlocks(this, memoryBlocks);
    }

    public void removeAllBlocks() throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        memMgr.removeAllBlocks(this);
    }

    public ICDIMemoryBlock[] getMemoryBlocks() throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        return memMgr.getMemoryBlocks(this);
    }

    public ICDISharedLibrary[] getSharedLibraries() throws CDIException {
        SharedLibraryManager sharedMgr = ((Session)this.getSession()).getSharedLibraryManager();
        return sharedMgr.getSharedLibraries(this);
    }

    public ICDIGlobalVariableDescriptor getGlobalVariableDescriptors(String filename, String function, String name) throws CDIException {
        VariableManager varMgr = ((Session)this.getSession()).getVariableManager();
        return varMgr.getGlobalVariableDescriptor(this, filename, function, name);
    }

    public ICDIRegisterGroup[] getRegisterGroups() throws CDIException {
        RegisterManager regMgr = ((Session)this.getSession()).getRegisterManager();
        return regMgr.getRegisterGroups(this);
    }

    public ICDITargetConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = this.miSession.isProgramSession() ? new TargetConfiguration(this) : (this.miSession.isAttachSession() ? new TargetConfiguration(this) : (this.miSession.isCoreSession() ? new CoreFileConfiguration(this) : new TargetConfiguration(this)));
        }
        return this.fConfiguration;
    }

    public ICDIGlobalVariable createGlobalVariable(ICDIGlobalVariableDescriptor varDesc) throws CDIException {
        if (varDesc instanceof GlobalVariableDescriptor) {
            VariableManager varMgr = ((Session)this.getSession()).getVariableManager();
            return varMgr.createGlobalVariable((GlobalVariableDescriptor)varDesc);
        }
        return null;
    }

    public ICDIRegister createRegister(ICDIRegisterDescriptor varDesc) throws CDIException {
        if (varDesc instanceof RegisterDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            RegisterManager mgr = session.getRegisterManager();
            return mgr.createRegister((RegisterDescriptor)varDesc);
        }
        return null;
    }

    public void deferBreakpoints(boolean defer) {
        this.deferBreakpoints = defer;
    }

    public boolean areBreakpointsDeferred() {
        return this.deferBreakpoints;
    }

    public void enableVerboseMode(boolean enabled) {
        this.miSession.enableVerboseMode(enabled);
    }

    public boolean isVerboseModeEnabled() {
        return this.miSession.isVerboseModeEnabled();
    }

    public ICDIAddressBreakpoint setAddressBreakpoint(int type, ICDIAddressLocation location, ICDICondition condition, boolean deferred, boolean enabled) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.setAddressBreakpoint(this, type, location, condition, deferred, enabled);
    }

    public ICDIExceptionpoint setExceptionBreakpoint(String clazz, boolean stopOnThrow, boolean stopOnCatch, boolean enabled) throws CDIException {
        throw new CDIException(CdiResources.getString("cdi.Common.Not_implemented"));
    }

    public ICDIFunctionBreakpoint setFunctionBreakpoint(int type, ICDIFunctionLocation location, ICDICondition condition, boolean deferred, boolean enabled) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.setFunctionBreakpoint(this, type, location, condition, deferred, enabled);
    }

    public ICDILineBreakpoint setLineBreakpoint(int type, ICDILineLocation location, ICDICondition condition, boolean deferred, boolean enabled) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.setLineBreakpoint(this, type, location, condition, deferred, enabled);
    }

    public ICDIAddressToSource.IMappedSourceLocation getSourceForAddress(IAddress address) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        CLIInfoLine cmd = factory.createCLIInfoLine(address);
        try {
            this.miSession.postCommand(cmd);
            CLIInfoLineInfo info = cmd.getMIInfoLineInfo();
            String fileName = "";
            ICDISharedLibrary[] libs = this.getSharedLibraries();
            BigInteger sourceAddress = address.getValue();
            int i = 0;
            while (i < libs.length) {
                if (sourceAddress.compareTo(libs[i].getStartAddress()) > 0 && sourceAddress.compareTo(libs[i].getEndAddress()) < 0) {
                    fileName = libs[i].getFileName();
                }
                ++i;
            }
            return new MappedSourceLocation(address, info, fileName);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIEventBreakpoint setEventBreakpoint(String type, String arg, int cdiType, ICDICondition condition, boolean deferred, boolean enabled) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.setEventBreakpoint(this, type, arg, condition, enabled);
    }
}

