/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IncompleteType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.Type;

public class Expression
extends CObject
implements ICDIExpression {
    private static int ID_COUNT = 0;
    private int id;
    String fExpression;
    Type fType;
    Variable fVariable;
    ICDIStackFrame fContext;

    public Expression(Target target, String ex) {
        super(target);
        this.fExpression = ex;
        this.id = ++ID_COUNT;
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public boolean equals(ICDIExpression obj) {
        if (obj instanceof Expression) {
            Expression other = (Expression)obj;
            return other.id == this.id;
        }
        return false;
    }

    public ICDIType getType(ICDIStackFrame frame) throws CDIException {
        Type type = null;
        Target target = (Target)this.getTarget();
        Session session = (Session)target.getSession();
        SourceManager sourceMgr = session.getSourceManager();
        String nametype = sourceMgr.getTypeNameFromVariable((StackFrame)frame, this.getExpressionText());
        try {
            type = sourceMgr.getType(target, nametype);
        }
        catch (CDIException e) {
            try {
                String ptype = sourceMgr.getDetailTypeName(target, nametype);
                type = sourceMgr.getType(target, ptype);
            }
            catch (CDIException ex) {
                try {
                    String ptype = sourceMgr.getDetailTypeNameFromVariable((StackFrame)frame, this.getExpressionText());
                    type = sourceMgr.getType(target, ptype);
                }
                catch (CDIException cDIException) {
                    // empty catch block
                }
            }
        }
        if (type == null) {
            type = new IncompleteType(target, nametype);
        }
        return type;
    }

    public ICDIValue getValue(ICDIStackFrame context) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        ExpressionManager mgr = session.getExpressionManager();
        if (this.fVariable != null && this.fContext != null && !context.equals(this.fContext)) {
            mgr.deleteVariable(this.fVariable);
            this.fVariable = null;
        }
        this.fContext = context;
        if (this.fVariable != null) {
            try {
                this.fVariable.getValue().getValueString();
            }
            catch (CDIException e) {
                this.fVariable = null;
            }
        }
        if (this.fVariable == null) {
            this.fVariable = mgr.createVariable((StackFrame)context, this.getExpressionText());
        }
        return this.fVariable.getValue();
    }

    public void dispose() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        ExpressionManager mgr = session.getExpressionManager();
        mgr.destroyExpressions((Target)this.getTarget(), new Expression[]{this});
        if (this.fVariable != null) {
            mgr.deleteVariable(this.fVariable);
        }
        this.fVariable = null;
    }
}

