/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.Messages;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.module.TmfAnalysisModuleHelperXml;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.module.TmfXmlAnalysisOutputSource;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleSource;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlAnalysisModuleSource
implements IAnalysisModuleSource {
    private static final String TMF_XML_BUILTIN_ID = "org.eclipse.linuxtools.tmf.analysis.xml.core.files";
    private static final String XML_FILE_ELEMENT = "xmlfile";
    private static final String XML_FILE_ATTRIB = "file";
    private static final IPath XML_DIRECTORY_LEGACY = Activator.getDefault().getStateLocation().removeLastSegments(1).append("org.eclipse.linuxtools.tmf.analysis.xml.core").append("xml_files");
    private static List<IAnalysisModuleHelper> fModules = null;

    public XmlAnalysisModuleSource() {
        TmfAnalysisManager.addNewModuleListener((ITmfNewAnalysisModuleListener)new TmfXmlAnalysisOutputSource());
    }

    public synchronized Iterable<IAnalysisModuleHelper> getAnalysisModules() {
        if (fModules == null) {
            fModules = new ArrayList<IAnalysisModuleHelper>();
            XmlAnalysisModuleSource.populateBuiltinModules();
            XmlAnalysisModuleSource.populateAnalysisModules();
        }
        return fModules;
    }

    private static void processFile(File xmlFile) {
        if (!XmlUtils.xmlValidate((File)xmlFile).isOK()) {
            return;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
            int i = 0;
            while (i < stateproviderNodes.getLength()) {
                Element node = (Element)stateproviderNodes.item(i);
                TmfAnalysisModuleHelperXml helper = new TmfAnalysisModuleHelperXml(xmlFile, node, TmfAnalysisModuleHelperXml.XmlAnalysisModuleType.STATE_SYSTEM);
                fModules.add(helper);
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError("Error opening XML file", e);
        }
    }

    private static void populateBuiltinModules() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_XML_BUILTIN_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(XML_FILE_ELEMENT)) {
                final String filename = element.getAttribute(XML_FILE_ATTRIB);
                final String name = element.getContributor().getName();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        Bundle bundle;
                        if (name != null && (bundle = Platform.getBundle((String)name)) != null) {
                            URL xmlUrl = bundle.getResource(filename);
                            if (xmlUrl == null) {
                                throw new FileNotFoundException(filename);
                            }
                            URL locatedURL = FileLocator.toFileURL((URL)xmlUrl);
                            XmlAnalysisModuleSource.processFile(new File(locatedURL.getFile()));
                        }
                    }

                    public void handleException(Throwable exception) {
                    }
                });
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void populateAnalysisModules() {
        int n;
        int n2;
        File[] fileArray;
        IPath pathToFiles = XmlUtils.getXmlFilesPath();
        File fFolder = pathToFiles.toFile();
        if (!fFolder.isDirectory()) return;
        if (!fFolder.exists()) {
            return;
        }
        File fOldFolder = XML_DIRECTORY_LEGACY.toFile();
        if (fOldFolder.isDirectory() && fOldFolder.exists()) {
            fileArray = fOldFolder.listFiles();
            n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                block33: {
                    File fromFile = fileArray[n];
                    File toFile = pathToFiles.append(fromFile.getName()).toFile();
                    if (!toFile.exists() && !fromFile.isDirectory()) {
                        try {
                            Throwable throwable = null;
                            Object var9_11 = null;
                            try {
                                FileInputStream fis = new FileInputStream(fromFile);
                                try {
                                    block32: {
                                        FileOutputStream fos = new FileOutputStream(toFile);
                                        try {
                                            block31: {
                                                FileChannel source = fis.getChannel();
                                                try {
                                                    try (FileChannel destination = fos.getChannel();){
                                                        destination.transferFrom(source, 0L, source.size());
                                                    }
                                                    if (source == null) break block31;
                                                }
                                                catch (Throwable throwable2) {
                                                    if (throwable == null) {
                                                        throwable = throwable2;
                                                    } else if (throwable != throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                    if (source == null) throw throwable;
                                                    source.close();
                                                    throw throwable;
                                                }
                                                source.close();
                                            }
                                            if (fos == null) break block32;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable == null) {
                                                throwable = throwable3;
                                            } else if (throwable != throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            if (fos == null) throw throwable;
                                            fos.close();
                                            throw throwable;
                                        }
                                        fos.close();
                                    }
                                    if (fis == null) break block33;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    if (fis == null) throw throwable;
                                    fis.close();
                                    throw throwable;
                                }
                                fis.close();
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                    throw throwable;
                                }
                                if (throwable == throwable5) throw throwable;
                                throwable.addSuppressed(throwable5);
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            String error = Messages.XmlUtils_ErrorCopyingFile;
                            Activator.logError(error, e);
                        }
                    }
                }
                ++n;
            }
        }
        fileArray = fFolder.listFiles();
        n2 = fileArray.length;
        n = 0;
        while (n < n2) {
            File xmlFile = fileArray[n];
            XmlAnalysisModuleSource.processFile(xmlFile);
            ++n;
        }
        return;
    }

    public static void notifyModuleChange() {
        fModules = null;
        TmfAnalysisManager.refreshModules();
    }
}

