/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractGenerator {
    String projectName;
    String specfileName;

    public void writeContent() {
        String contents = this.generateSpecfile();
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(contents.getBytes());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(this.projectName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            Status status = new Status(4, "org.eclipse.linuxtools.internal.rpmstubby", 0, "Project \"" + this.projectName + "\" does not exist.", null);
            StubbyLog.logError(new CoreException((IStatus)status));
        }
        IContainer container = (IContainer)resource;
        IResource specsFolder = container.getProject().findMember("SPECS");
        IFile file = container.getFile((IPath)new Path(this.specfileName));
        if (specsFolder != null) {
            file = ((IFolder)specsFolder).getFile((IPath)new Path(this.specfileName));
        }
        final IFile openFile = file;
        try {
            ByteArrayInputStream stream = contentInputStream;
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, null);
            } else {
                file.create((InputStream)stream, true, null);
            }
            ((InputStream)stream).close();
        }
        catch (IOException | CoreException e) {
            StubbyLog.logError(e);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)openFile, (boolean)true);
                }
                catch (PartInitException e) {
                    StubbyLog.logError(e);
                }
            }
        });
    }

    public abstract String generateSpecfile();

    protected static void generateChangelog(StringBuilder buffer) {
        buffer.append("%changelog\n");
        buffer.append("#FIXME\n");
    }
}

