/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling.engine;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.ui.text.spelling.Messages;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingPreferences;
import org.eclipse.cdt.internal.ui.text.spelling.engine.DefaultPhoneticDistanceAlgorithm;
import org.eclipse.cdt.internal.ui.text.spelling.engine.DefaultPhoneticHashProvider;
import org.eclipse.cdt.internal.ui.text.spelling.engine.IPhoneticDistanceAlgorithm;
import org.eclipse.cdt.internal.ui.text.spelling.engine.IPhoneticHashProvider;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.cdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractSpellDictionary
implements ISpellDictionary {
    protected static final int BUCKET_CAPACITY = 4;
    protected static final int BUFFER_CAPACITY = 32;
    protected static final int DISTANCE_THRESHOLD = 160;
    protected static final int HASH_CAPACITY = 22528;
    private IPhoneticDistanceAlgorithm fDistanceAlgorithm = new DefaultPhoneticDistanceAlgorithm();
    private final Map<String, Serializable> fHashBuckets = new HashMap<String, Serializable>(22528);
    private IPhoneticHashProvider fHashProvider = new DefaultPhoneticHashProvider();
    private boolean fLoaded = false;
    private boolean fMustLoad = true;
    boolean fIsStrippingNonLetters = true;

    protected final Object getCandidates(String hash) {
        return this.fHashBuckets.get(hash);
    }

    protected final Set<RankedWordProposal> getCandidates(String word, boolean sentence, ArrayList<String> hashs) {
        int distance = 0;
        String hash = null;
        StringBuffer buffer = new StringBuffer(32);
        HashSet<RankedWordProposal> result = new HashSet<RankedWordProposal>(4 * hashs.size());
        int index = 0;
        while (index < hashs.size()) {
            hash = hashs.get(index);
            Object candidates = this.getCandidates(hash);
            if (candidates != null) {
                if (candidates instanceof String) {
                    String candidate = (String)candidates;
                    distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                    if (distance < 160) {
                        buffer.setLength(0);
                        buffer.append(candidate);
                        if (sentence) {
                            buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                        }
                        result.add(new RankedWordProposal(buffer.toString(), -distance));
                    }
                } else {
                    ArrayList candidateList = (ArrayList)candidates;
                    int offset = 0;
                    while (offset < candidateList.size()) {
                        String candidate = (String)candidateList.get(offset);
                        distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                        if (distance < 160) {
                            buffer.setLength(0);
                            buffer.append(candidate);
                            if (sentence) {
                                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                            }
                            result.add(new RankedWordProposal(buffer.toString(), -distance));
                        }
                        ++offset;
                    }
                }
            }
            ++index;
        }
        return result;
    }

    protected final void getCandidates(String word, boolean sentence, Set<RankedWordProposal> result) {
        int distance = 0;
        int minimum = Integer.MAX_VALUE;
        StringBuffer buffer = new StringBuffer(32);
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return;
        }
        if (candidates instanceof String) {
            String candidate = (String)candidates;
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            buffer.append(candidate);
            if (sentence) {
                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
            }
            result.add(new RankedWordProposal(buffer.toString(), -distance));
            return;
        }
        ArrayList candidateList = (ArrayList)candidates;
        ArrayList<RankedWordProposal> matches = new ArrayList<RankedWordProposal>(candidateList.size());
        int index = 0;
        while (index < candidateList.size()) {
            String candidate = (String)candidateList.get(index);
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            if (distance <= minimum) {
                if (distance < minimum) {
                    matches.clear();
                }
                buffer.setLength(0);
                buffer.append(candidate);
                if (sentence) {
                    buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                }
                matches.add(new RankedWordProposal(buffer.toString(), -distance));
                minimum = distance;
            }
            ++index;
        }
        result.addAll(matches);
    }

    protected boolean isEmpty() {
        return this.fHashBuckets.size() == 0;
    }

    protected final IPhoneticDistanceAlgorithm getDistanceAlgorithm() {
        return this.fDistanceAlgorithm;
    }

    protected final IPhoneticHashProvider getHashProvider() {
        return this.fHashProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RankedWordProposal> getProposals(String word, boolean sentence) {
        block14: {
            try {
                if (this.fLoaded) break block14;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String hash = this.fHashProvider.getHash(word);
        char[] mutators = this.fHashProvider.getMutators();
        ArrayList<String> neighborhood = new ArrayList<String>((word.length() + 1) * (mutators.length + 2));
        neighborhood.add(hash);
        Set<RankedWordProposal> candidates = this.getCandidates(word, sentence, neighborhood);
        neighborhood.clear();
        char previous = '\u0000';
        char next = '\u0000';
        char[] characters = word.toCharArray();
        int index = 0;
        while (index < word.length() - 1) {
            next = characters[index];
            characters[index] = previous = characters[index + 1];
            characters[index + 1] = next;
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            characters[index] = next;
            characters[index + 1] = previous;
            ++index;
        }
        String sentinel = String.valueOf(word) + " ";
        characters = sentinel.toCharArray();
        int offset = characters.length - 1;
        while (true) {
            char[] cArray = mutators;
            int n = mutators.length;
            int n2 = 0;
            while (n2 < n) {
                char mutator;
                characters[offset] = mutator = cArray[n2];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++n2;
            }
            if (offset == 0) break;
            characters[offset] = characters[offset - 1];
            --offset;
        }
        char mutated = '\u0000';
        characters = word.toCharArray();
        int index2 = 0;
        while (index2 < word.length()) {
            mutated = characters[index2];
            char[] cArray = mutators;
            int n = mutators.length;
            int n3 = 0;
            while (n3 < n) {
                char mutator2;
                characters[index2] = mutator2 = cArray[n3];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++n3;
            }
            characters[index2] = mutated;
            ++index2;
        }
        characters = word.toCharArray();
        char[] deleted = new char[characters.length - 1];
        int index3 = 0;
        while (index3 < deleted.length) {
            deleted[index3] = characters[index3];
            ++index3;
        }
        next = characters[characters.length - 1];
        offset = deleted.length;
        while (true) {
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            if (offset == 0) break;
            previous = next;
            next = deleted[offset - 1];
            deleted[offset - 1] = previous;
            --offset;
        }
        neighborhood.remove(hash);
        Set<RankedWordProposal> matches = this.getCandidates(word, sentence, neighborhood);
        if (matches.size() == 0 && candidates.size() == 0) {
            this.getCandidates(word, sentence, candidates);
        }
        candidates.addAll(matches);
        return candidates;
    }

    protected abstract URL getURL() throws MalformedURLException;

    protected final void hashWord(String word) {
        String hash = this.fHashProvider.getHash(word);
        Serializable bucket = this.fHashBuckets.get(hash);
        if (bucket == null) {
            this.fHashBuckets.put(hash, (Serializable)((Object)word));
        } else if (bucket instanceof ArrayList) {
            ArrayList bucket2 = (ArrayList)bucket;
            bucket2.add(word);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(bucket);
            list.add(word);
            this.fHashBuckets.put(hash, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrect(String word) {
        block8: {
            word = this.stripNonLetters(word);
            try {
                if (this.fLoaded) break block8;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return false;
        }
        if (candidates instanceof String) {
            String candidate = (String)candidates;
            return candidate.equals(word) || candidate.equals(word.toLowerCase());
        }
        ArrayList candidateList = (ArrayList)candidates;
        return candidateList.contains(word) || candidateList.contains(word.toLowerCase());
    }

    @Override
    public void setStripNonLetters(boolean state) {
        this.fIsStrippingNonLetters = state;
    }

    /*
     * Unable to fully structure code
     */
    protected String stripNonLetters(String word) {
        if (!this.fIsStrippingNonLetters) {
            return word;
        }
        i = 0;
        j = word.length() - 1;
        while (i <= j && !Character.isLetter(word.charAt(i))) {
            ++i;
        }
        if (i <= j) ** GOTO lbl11
        return "";
lbl-1000:
        // 1 sources

        {
            --j;
lbl11:
            // 2 sources

            ** while (j > i && !Character.isLetter((char)word.charAt((int)j)))
        }
lbl12:
        // 1 sources

        return word.substring(i, j + 1);
    }

    @Override
    public final synchronized boolean isLoaded() {
        return this.fLoaded || this.fHashBuckets.size() > 0;
    }

    protected synchronized boolean load(URL url) {
        block31: {
            if (!this.fMustLoad) {
                return this.fLoaded;
            }
            if (url != null) {
                InputStream stream = null;
                int line = 0;
                try {
                    stream = url.openStream();
                    if (stream == null) break block31;
                    String word = null;
                    CharsetDecoder decoder = Charset.forName(this.getEncoding()).newDecoder();
                    decoder.onMalformedInput(CodingErrorAction.REPORT);
                    decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, decoder));
                    boolean doRead = true;
                    while (doRead) {
                        try {
                            word = reader.readLine();
                        }
                        catch (MalformedInputException ex) {
                            decoder.onMalformedInput(CodingErrorAction.REPLACE);
                            decoder.reset();
                            word = reader.readLine();
                            decoder.onMalformedInput(CodingErrorAction.REPORT);
                            String message = NLS.bind((String)Messages.AbstractSpellingDictionary_encodingError, (Object[])new String[]{word, decoder.replacement(), url.toString()});
                            Status status = new Status(4, "org.eclipse.cdt.ui", 0, message, (Throwable)ex);
                            CUIPlugin.log((IStatus)status);
                            doRead = word != null;
                            continue;
                        }
                        boolean bl = doRead = word != null;
                        if (!doRead) continue;
                        this.hashWord(word);
                    }
                    return true;
                }
                catch (FileNotFoundException e) {
                    String urlString = url.toString();
                    String lowercaseUrlString = urlString.toLowerCase();
                    if (urlString.equals(lowercaseUrlString)) {
                        CUIPlugin.log(e);
                        break block31;
                    }
                    try {
                        boolean bl = this.load(new URL(lowercaseUrlString));
                        return bl;
                    }
                    catch (MalformedURLException ex) {
                        CUIPlugin.log(ex);
                    }
                }
                catch (IOException exception) {
                    if (line > 0) {
                        String message = NLS.bind((String)Messages.AbstractSpellingDictionary_encodingError, (Object)String.valueOf(line), (Object)url.toString());
                        Status status = new Status(4, "org.eclipse.cdt.ui", 0, message, (Throwable)exception);
                        CUIPlugin.log((IStatus)status);
                    } else {
                        CUIPlugin.log(exception);
                    }
                }
                finally {
                    this.fMustLoad = false;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    private void compact() {
        for (Serializable element : this.fHashBuckets.values()) {
            if (!(element instanceof ArrayList)) continue;
            ((ArrayList)element).trimToSize();
        }
    }

    protected final void setDistanceAlgorithm(IPhoneticDistanceAlgorithm algorithm) {
        this.fDistanceAlgorithm = algorithm;
    }

    protected final void setHashProvider(IPhoneticHashProvider provider) {
        this.fHashProvider = provider;
    }

    @Override
    public synchronized void unload() {
        this.fLoaded = false;
        this.fMustLoad = true;
        this.fHashBuckets.clear();
    }

    @Override
    public boolean acceptsWords() {
        return false;
    }

    @Override
    public void addWord(String word) {
    }

    protected String getEncoding() {
        String encoding = SpellingPreferences.getSpellingUserDictionaryEncoding();
        if (encoding == null || encoding.isEmpty()) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return encoding;
    }
}

