/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.corext.codemanipulation.InclusionContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IncludeCreationContext
extends InclusionContext {
    private final IIndex fIndex;
    private final Set<IPath> fHeadersToInclude;
    private final Set<IPath> fHeadersAlreadyIncluded;
    private final Set<IPath> fHeadersIncludedPreviously;

    public IncludeCreationContext(ITranslationUnit tu, IIndex index) {
        super(tu);
        this.fIndex = index;
        this.fHeadersToInclude = new HashSet<IPath>();
        this.fHeadersAlreadyIncluded = new HashSet<IPath>();
        this.fHeadersIncludedPreviously = new HashSet<IPath>();
    }

    public final IIndex getIndex() {
        return this.fIndex;
    }

    public boolean isCXXLanguage() {
        return this.getTranslationUnit().isCXXLanguage();
    }

    public void removeExportedHeaders() throws CoreException {
        HashMap<IPath, IIndexFile> filesByPath = new HashMap<IPath, IIndexFile>();
        IIndexFile[] iIndexFileArray = this.fIndex.getAllFiles();
        int n = iIndexFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFile file = iIndexFileArray[n2];
            IPath path = IncludeCreationContext.getPath(file);
            filesByPath.put(path, file);
            ++n2;
        }
        this.removeExportedHeaders(this.fHeadersAlreadyIncluded, filesByPath);
        this.removeExportedHeaders(this.fHeadersToInclude, filesByPath);
    }

    private void removeExportedHeaders(Set<IPath> exportingHeaders, Map<IPath, IIndexFile> filesByPath) throws CoreException {
        HashSet<IPath> exportedHeaders = new HashSet<IPath>();
        for (IPath path : exportingHeaders) {
            IIndexFile file;
            if (exportedHeaders.contains(path) || (file = filesByPath.get(path)) == null) continue;
            ArrayDeque<IIndexFile> queue = new ArrayDeque<IIndexFile>();
            queue.add(file);
            while ((file = (IIndexFile)queue.pollFirst()) != null) {
                IIndexInclude[] iIndexIncludeArray = file.getIncludes();
                int n = iIndexIncludeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexInclude include = iIndexIncludeArray[n2];
                    if ((this.getPreferences().allowIndirectInclusion || this.isIncludedFileExported(include)) && (file = this.fIndex.resolveInclude(include)) != null && exportedHeaders.add(IncludeCreationContext.getPath(file))) {
                        queue.add(file);
                    }
                    ++n2;
                }
            }
        }
        this.fHeadersToInclude.removeAll(exportedHeaders);
    }

    private boolean isIncludedFileExported(IIndexInclude include) throws CoreException {
        if (include.isIncludedFileExported()) {
            return true;
        }
        String name = include.getName();
        int index = name.lastIndexOf(46);
        String extension = index >= 0 ? name.substring(index + 1) : "";
        return ArrayUtil.containsEqual((Object[])this.getPreferences().extensionsOfAutoExportedFiles, (Object)extension);
    }

    private static IPath getPath(IIndexFile file) throws CoreException {
        return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
    }

    public Set<IPath> getHeadersToInclude() {
        return this.fHeadersToInclude;
    }

    public final void addHeaderToInclude(IPath header) {
        this.fHeadersToInclude.add(header);
        this.fHeadersAlreadyIncluded.add(header);
    }

    public final boolean isToBeIncluded(IPath header) {
        return this.fHeadersToInclude.contains(header);
    }

    public Set<IPath> getHeadersAlreadyIncluded() {
        return this.fHeadersAlreadyIncluded;
    }

    public final void addHeaderAlreadyIncluded(IPath header) {
        this.fHeadersAlreadyIncluded.add(header);
    }

    public final boolean isAlreadyIncluded(IPath header) {
        return this.fHeadersAlreadyIncluded.contains(header);
    }

    public final boolean isIncluded(IPath header) {
        return this.fHeadersAlreadyIncluded.contains(header) || this.fHeadersToInclude.contains(header);
    }

    public void addHeadersIncludedPreviously(IASTPreprocessorIncludeStatement[] includes) {
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            IASTPreprocessorIncludeStatement include = iASTPreprocessorIncludeStatementArray[n2];
            if (include.isPartOfTranslationUnitFile() && !(path = include.getPath()).isEmpty()) {
                this.fHeadersIncludedPreviously.add(Path.fromOSString((String)path));
            }
            ++n2;
        }
    }

    public final boolean wasIncludedPreviously(IPath header) {
        return this.fHeadersIncludedPreviously.contains(header);
    }
}

