/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IContextStore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.IContextStoreListener;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextExternalizer;

public class LocalContextStore
implements IContextStore {
    private File contextDirectory;
    private Set<File> contextFiles;
    private final InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
    private final IInteractionContextScaling commonContextScaling;
    private final List<IContextStoreListener> listeners = new ArrayList<IContextStoreListener>();

    public LocalContextStore(IInteractionContextScaling commonContextScaling) {
        this.commonContextScaling = commonContextScaling;
    }

    public synchronized void setContextDirectory(File directory) {
        this.contextDirectory = directory;
        this.contextFiles = null;
        for (IContextStoreListener listener : this.listeners) {
            listener.contextStoreMoved(directory);
        }
    }

    public File getContextDirectory() {
        return this.contextDirectory;
    }

    public IInteractionContext loadContext(String handleIdentifier) {
        return this.loadContext(handleIdentifier, this.getFileForContext(handleIdentifier), this.commonContextScaling);
    }

    public InputStream getAdditionalContextInformation(IInteractionContext context, String identifier) throws IOException {
        File fileForContext = this.getFileForContext(context.getHandleIdentifier());
        return this.externalizer.getAdditionalInformation(fileForContext, identifier);
    }

    @Override
    public IInteractionContext importContext(String handleIdentifier, File fromFile) throws CoreException {
        String handleToImportFrom = InteractionContextExternalizer.getFirstContextHandle(fromFile);
        InteractionContext context = (InteractionContext)this.loadContext(handleToImportFrom, fromFile, this.commonContextScaling);
        context.setHandleIdentifier(handleIdentifier);
        this.saveContext(context);
        return context;
    }

    public IInteractionContext loadContext(String handleIdentifier, File fromFile, IInteractionContextScaling contextScaling) {
        IInteractionContext loadedContext = this.externalizer.readContextFromXml(handleIdentifier, fromFile, contextScaling);
        if (loadedContext == null) {
            return new InteractionContext(handleIdentifier, contextScaling);
        }
        return loadedContext;
    }

    public void saveActiveContext() {
        IInteractionContext context = ContextCore.getContextManager().getActiveContext();
        if (context != null && context.getHandleIdentifier() != null) {
            this.saveContext(context);
        }
    }

    public void saveContext(IInteractionContext context, String fileName) {
        try {
            this.externalizer.writeContextToXml(context, this.getFileForContext(fileName));
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Failed to write context " + context.getHandleIdentifier(), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContext(IInteractionContext context) {
        block13: {
            boolean wasPaused = ContextCore.getContextManager().isContextCapturePaused();
            try {
                try {
                    if (!wasPaused) {
                        ContextCore.getContextManager().setContextCapturePaused(true);
                    }
                    IInteractionContext iInteractionContext = context;
                    synchronized (iInteractionContext) {
                        IInteractionContext contextToSave = context;
                        if (context instanceof InteractionContext) {
                            contextToSave = ((InteractionContext)context).createCollapsedWritableCopy();
                        }
                        this.externalizer.writeContextToXml(contextToSave, this.getFileForContext(contextToSave.getHandleIdentifier()));
                    }
                    if (context.getAllElements().size() == 0) {
                        this.removeFromCache(context);
                        break block13;
                    }
                    this.addToCache(context);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "could not save context", t));
                    if (!wasPaused) {
                        ContextCore.getContextManager().setContextCapturePaused(false);
                    }
                }
            }
            finally {
                if (!wasPaused) {
                    ContextCore.getContextManager().setContextCapturePaused(false);
                }
            }
        }
    }

    private boolean addToCache(IInteractionContext context) {
        this.initCache();
        return this.contextFiles.add(this.getFileForContext(context.getHandleIdentifier()));
    }

    private void initCache() {
        if (this.contextFiles == null) {
            File[] files;
            this.contextFiles = new HashSet<File>();
            File[] fileArray = files = this.contextDirectory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.contextFiles.add(file);
                ++n2;
            }
        }
    }

    private boolean removeFromCache(IInteractionContext context) {
        if (this.contextFiles != null) {
            return this.contextFiles.remove(this.getFileForContext(context.getHandleIdentifier()));
        }
        return false;
    }

    public void merge(String sourceTaskHandle, String targetTaskHandle) {
        IInteractionContext sourceContext = this.loadContext(sourceTaskHandle);
        IInteractionContext targetContext = this.loadContext(targetTaskHandle);
        if (targetContext instanceof InteractionContext) {
            ((InteractionContext)targetContext).addEvents(sourceContext);
            ContextCorePlugin.getContextStore().saveContext(targetContext);
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Cannot merge contexts of " + sourceTaskHandle + " and " + targetTaskHandle, new Exception().fillInStackTrace()));
        }
    }

    @Override
    public IInteractionContext cloneContext(String sourceContextHandle, String destinationContextHandle) {
        InteractionContext readContext = (InteractionContext)this.externalizer.readContextFromXml(sourceContextHandle, this.getFileForContext(sourceContextHandle), this.commonContextScaling);
        if (readContext == null) {
            return new InteractionContext(destinationContextHandle, this.commonContextScaling);
        }
        readContext.setHandleIdentifier(destinationContextHandle);
        this.saveContext(readContext);
        return readContext;
    }

    @Override
    public boolean hasContext(String handleIdentifier) {
        Assert.isNotNull((Object)handleIdentifier);
        File file = this.getFileForContext(handleIdentifier);
        this.initCache();
        return this.contextFiles.contains(file);
    }

    public File getFileForContext(String handleIdentifier) {
        try {
            String encoded = URLEncoder.encode(handleIdentifier, "UTF-8");
            File contextDirectory = this.getContextDirectory();
            File contextFile = new File(contextDirectory, String.valueOf(encoded) + ".xml.zip");
            return contextFile;
        }
        catch (UnsupportedEncodingException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Could not determine path for context", (Throwable)e));
            return null;
        }
    }

    public void deleteContext(String handleIdentifier) {
        try {
            File file = this.getFileForContext(handleIdentifier);
            if (file.exists()) {
                file.delete();
            }
            if (this.contextFiles != null) {
                this.contextFiles.remove(this.getFileForContext(handleIdentifier));
            }
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Could not delete context file, insufficient permissions.", (Throwable)e));
        }
    }

    public void export(String handleIdentifier, ZipOutputStream outputStream) throws IOException {
        IInteractionContext context = this.loadContext(handleIdentifier);
        this.externalizer.writeContext(context, outputStream);
    }

    @Deprecated
    public void addListener(IContextStoreListener listener) {
        this.listeners.add(listener);
    }

    @Deprecated
    public void removeListener(IContextStoreListener listener) {
        this.listeners.remove(listener);
    }
}

