/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDIErrorInfo;
import org.eclipse.cdt.debug.core.cdi.ICDIEventBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISessionConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryEvent;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIExitedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIRestartedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIAddressFactoryManagement;
import org.eclipse.cdt.debug.core.cdi.model.ICDIDisposable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIGlobalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget2;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration2;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.model.CDebugElementState;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.core.model.IDebuggerProcessSupport;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.core.model.IModuleRetrieval;
import org.eclipse.cdt.debug.core.model.IPersistableRegisterGroup;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.core.sourcelookup.CProjectSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.cdt.debug.internal.core.CBreakpointManager;
import org.eclipse.cdt.debug.internal.core.CGlobalVariableManager;
import org.eclipse.cdt.debug.internal.core.CMemoryBlockRetrievalExtension;
import org.eclipse.cdt.debug.internal.core.CRegisterManager;
import org.eclipse.cdt.debug.internal.core.CSettingsManager;
import org.eclipse.cdt.debug.internal.core.CSignalManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CModule;
import org.eclipse.cdt.debug.internal.core.model.CModuleManager;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.model.CVariableFactory;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.debug.internal.core.model.Disassembly;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyRetrieval;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupParticipant;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager;
import org.eclipse.cdt.utils.Addr64Factory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;

public class CDebugTarget
extends CDebugElement
implements ICDebugTarget,
ICDIEventListener,
ILaunchListener,
IExpressionListener,
ISourceLookupChangeListener {
    private ArrayList<CThread> fThreads;
    private IProcess fDebuggeeProcess = null;
    private ICDITarget fCDITarget;
    private String fName;
    private ILaunch fLaunch;
    private ICDITargetConfiguration fConfig;
    private Disassembly fDisassembly;
    private DisassemblyRetrieval fDisassemblyRetrieval;
    private CModuleManager fModuleManager;
    private CSignalManager fSignalManager;
    private CRegisterManager fRegisterManager;
    private CBreakpointManager fBreakpointManager;
    private CGlobalVariableManager fGlobalVariableManager;
    private CSettingsManager fFormatManager;
    private IBinaryParser.IBinaryObject fBinaryFile;
    private IProject fProject;
    private Boolean fIsLittleEndian = null;
    private Preferences fPreferences = null;
    private IAddressFactory fAddressFactory;
    private CMemoryBlockRetrievalExtension fMemoryBlockRetrieval;
    private String internalD = Integer.toString(lastInternalID++);
    private static int lastInternalID = 1;

    public CDebugTarget(ILaunch launch, IProject project, ICDITarget cdiTarget, String name, IProcess debuggeeProcess, IBinaryParser.IBinaryObject file, boolean allowsTerminate, boolean allowsDisconnect) {
        super(null);
        this.setLaunch(launch);
        this.setDebugTarget(this);
        this.setName(name);
        this.setProcess(debuggeeProcess);
        this.setProject(project);
        this.setExecFile(file);
        this.setCDITarget(cdiTarget);
        this.setState(CDebugElementState.SUSPENDED);
        this.initializePreferences();
        this.setConfiguration(cdiTarget.getConfiguration());
        this.setThreadList(new ArrayList<CThread>(5));
        this.createDisassembly();
        this.setModuleManager(new CModuleManager(this));
        this.setSignalManager(new CSignalManager(this));
        this.setRegisterManager(new CRegisterManager(this));
        this.setBreakpointManager(new CBreakpointManager(this));
        this.setGlobalVariableManager(new CGlobalVariableManager(this));
        this.setFormatManager(new CSettingsManager(this));
        this.setMemoryBlockRetrieval(new CMemoryBlockRetrievalExtension(this));
        this.initialize();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionListener)this);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.initializeSourceLookupPath();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(1);
        debugEvents.add(this.createCreateEvent());
        this.initializeThreads(debugEvents);
        this.initializeBreakpoints();
        this.initializeRegisters();
        this.initializeSourceManager();
        this.initializeModuleManager();
        this.initializeMemoryBlocks();
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    private void initializeBreakpoints() {
        this.getBreakpointManager().initialize();
    }

    public void start(String stopSymbol, boolean resume) throws DebugException {
        ICDITargetConfiguration config = this.getConfiguration();
        if (config.supportsBreakpoints()) {
            this.getBreakpointManager().setInitialBreakpoints();
            if (stopSymbol != null && stopSymbol.length() != 0) {
                try {
                    IAddress address = this.getAddressFactory().createAddress(stopSymbol);
                    this.stopAtAddress(address);
                }
                catch (NumberFormatException nfexc) {
                    this.stopAtSymbol(stopSymbol);
                }
            }
        }
        if (config.supportsResume() && resume) {
            this.resume();
        }
    }

    protected void initializeThreads(List<DebugEvent> debugEvents) {
        ICDITarget cdiTarget = this.getCDITarget();
        if (cdiTarget == null) {
            return;
        }
        ICDIThread[] cdiThreads = new ICDIThread[]{};
        try {
            cdiThreads = cdiTarget.getThreads();
        }
        catch (CDIException cDIException) {
            // empty catch block
        }
        DebugEvent suspendEvent = null;
        int i = 0;
        while (i < cdiThreads.length) {
            CThread thread = this.createThread(cdiThreads[i]);
            debugEvents.add(thread.createCreateEvent());
            try {
                if (cdiThreads[i].equals(cdiTarget.getCurrentThread()) && thread.isSuspended()) {
                    suspendEvent = thread.createSuspendEvent(16);
                }
            }
            catch (CDIException cDIException) {
                // empty catch block
            }
            ++i;
        }
        if (suspendEvent != null) {
            debugEvents.add(suspendEvent);
        }
    }

    protected void initializeRegisters() {
        this.getRegisterManager().initialize();
    }

    protected void initializeSourceManager() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof IAdaptable) {
            IResourceChangeListener listener;
            CSourceManager sm;
            ICSourceLocator clocator = (ICSourceLocator)((IAdaptable)locator).getAdapter(ICSourceLocator.class);
            if (clocator instanceof IAdaptable && (sm = (CSourceManager)((IAdaptable)clocator).getAdapter(CSourceManager.class)) != null) {
                sm.setDebugTarget(this);
            }
            if ((listener = (IResourceChangeListener)((IAdaptable)locator).getAdapter(IResourceChangeListener.class)) != null) {
                CCorePlugin.getWorkspace().addResourceChangeListener(listener);
            }
        }
    }

    protected void initializeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] participants = ((ISourceLookupDirector)locator).getParticipants();
            int i = 0;
            while (i < participants.length) {
                if (participants[i] instanceof CSourceLookupParticipant) {
                    ((CSourceLookupParticipant)participants[i]).addSourceLookupChangeListener(this);
                }
                ++i;
            }
            this.setSourceLookupPath(((ISourceLookupDirector)locator).getSourceContainers());
        }
    }

    protected void initializeModuleManager() {
        ICDITarget cdiTarget = this.getCDITarget();
        if (cdiTarget == null) {
            return;
        }
        ICDISharedLibrary[] slibs = new ICDISharedLibrary[]{};
        try {
            slibs = cdiTarget.getSharedLibraries();
        }
        catch (CDIException e) {
            DebugPlugin.log((Throwable)e);
        }
        ICModule[] modules = null;
        if (this.getExecFile() != null) {
            modules = new ICModule[slibs.length + 1];
            modules[0] = CModule.createExecutable(this, this.getExecFile().getPath());
        } else {
            modules = new ICModule[slibs.length];
        }
        int i = 0;
        while (i < slibs.length) {
            modules[i + 1] = CModule.createSharedLibrary(this, slibs[i]);
            ++i;
        }
        this.getModuleManager().addModules(modules);
    }

    protected void initializeMemoryBlocks() {
        this.getMemoryBlockRetrieval().initialize();
    }

    public IProcess getProcess() {
        return this.fDebuggeeProcess;
    }

    protected void setProcess(IProcess debuggeeProcess) {
        this.fDebuggeeProcess = debuggeeProcess;
    }

    public IThread[] getThreads() {
        ArrayList<CThread> threads = this.getThreadList();
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (!this.getConfiguration().supportsBreakpoints()) {
            return false;
        }
        return breakpoint instanceof ICBreakpoint && this.getBreakpointManager().supportsBreakpoint((ICBreakpoint)breakpoint);
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.getState().equals(CDebugElementState.TERMINATED);
    }

    public void terminate() throws DebugException {
        if (!this.canTerminate()) {
            return;
        }
        CDebugElementState newState = CDebugElementState.TERMINATING;
        this.changeState(newState);
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                cdiTarget.terminate();
            }
        }
        catch (CDIException e) {
            if (this.getState() == newState) {
                this.restoreOldState();
            }
            CDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canResume() {
        return this.getConfiguration().supportsResume() && this.isSuspended();
    }

    public boolean canSuspend() {
        if (!this.getConfiguration().supportsSuspend()) {
            return false;
        }
        if (this.getState().equals(CDebugElementState.RESUMED)) {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return this.getState().equals(CDebugElementState.SUSPENDED);
    }

    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        CDebugElementState newState = CDebugElementState.RESUMING;
        this.changeState(newState);
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                cdiTarget.resume(false);
            }
        }
        catch (CDIException e) {
            if (this.getState() == newState) {
                this.restoreOldState();
            }
            CDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void suspend() throws DebugException {
        if (!this.canSuspend()) {
            return;
        }
        CDebugElementState newState = CDebugElementState.SUSPENDING;
        this.changeState(newState);
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                cdiTarget.suspend();
            }
        }
        catch (CDIException e) {
            if (this.getState() == newState) {
                this.restoreOldState();
            }
            CDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected boolean isSuspending() {
        return this.getState().equals(CDebugElementState.SUSPENDING);
    }

    protected void suspendThreads(ICDISuspendedEvent event) {
        for (CThread thread : this.getThreadList()) {
            ICDIThread suspensionThread = null;
            try {
                ICDITarget cdiTarget = this.getCDITarget();
                if (cdiTarget != null) {
                    suspensionThread = cdiTarget.getCurrentThread();
                }
            }
            catch (CDIException cDIException) {
                // empty catch block
            }
            thread.suspendByTarget(event.getReason(), suspensionThread);
        }
    }

    protected synchronized List<CThread> refreshThreads() {
        ArrayList<CThread> newThreads = new ArrayList<CThread>(5);
        ArrayList<CThread> list = new ArrayList<CThread>(5);
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(5);
        List oldList = (List)this.getThreadList().clone();
        ICDIThread[] cdiThreads = new ICDIThread[]{};
        ICDIThread currentCDIThread = null;
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                cdiThreads = cdiTarget.getThreads();
                currentCDIThread = cdiTarget.getCurrentThread();
            }
        }
        catch (CDIException cdiTarget) {
            // empty catch block
        }
        int i = 0;
        while (i < cdiThreads.length) {
            CThread thread = this.findThread(oldList, cdiThreads[i]);
            if (thread == null) {
                thread = new CThread(this, cdiThreads[i]);
                newThreads.add(thread);
            } else {
                oldList.remove(thread);
            }
            thread.setCurrent(cdiThreads[i].equals(currentCDIThread));
            list.add(thread);
            ++i;
        }
        for (CThread thread : oldList) {
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.setThreadList(list);
        Iterator it = newThreads.iterator();
        while (it.hasNext()) {
            debugEvents.add(((CThread)it.next()).createCreateEvent());
        }
        if (debugEvents.size() > 0) {
            this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
        }
        return newThreads;
    }

    protected synchronized void resumeThreads(List<DebugEvent> debugEvents, int detail) {
        Iterator<CThread> it = this.getThreadList().iterator();
        while (it.hasNext()) {
            it.next().resumedByTarget(detail, debugEvents);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    protected boolean supportsDisconnect() {
        return this.getConfiguration().supportsDisconnect();
    }

    protected boolean supportsTerminate() {
        return this.getConfiguration().supportsTerminate();
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect() && this.isAvailable();
    }

    public void disconnect() throws DebugException {
        if (this.isDisconnecting()) {
            return;
        }
        CDebugElementState newState = CDebugElementState.DISCONNECTING;
        this.changeState(newState);
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                cdiTarget.disconnect();
            }
        }
        catch (CDIException e) {
            if (this.getState() == newState) {
                this.restoreOldState();
            }
            CDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean isDisconnected() {
        return this.getState().equals(CDebugElementState.DISCONNECTED);
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    protected ArrayList<CThread> getThreadList() {
        return this.fThreads;
    }

    private void setThreadList(ArrayList<CThread> threads) {
        this.fThreads = threads;
    }

    private void setCDITarget(ICDITarget cdiTarget) {
        this.fCDITarget = cdiTarget;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(ICDebugElement.class)) {
            return this;
        }
        if (adapter.equals(CDebugElement.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(ICDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(CDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(ICDITarget.class)) {
            return this.fCDITarget;
        }
        if (adapter.equals(IDebuggerProcessSupport.class)) {
            return this;
        }
        if (adapter.equals(IExecFileInfo.class)) {
            return this;
        }
        if (adapter.equals(CBreakpointManager.class)) {
            return this.getBreakpointManager();
        }
        if (adapter.equals(CSignalManager.class)) {
            return this.getSignalManager();
        }
        if (adapter.equals(CRegisterManager.class)) {
            return this.getRegisterManager();
        }
        if (adapter.equals(ICGlobalVariableManager.class)) {
            return this.getGlobalVariableManager();
        }
        if (adapter.equals(ICDISession.class)) {
            return this.getCDISession();
        }
        if (adapter.equals(IMemoryBlockRetrievalExtension.class)) {
            return this.getMemoryBlockRetrieval();
        }
        if (adapter.equals(IMemoryBlockRetrieval.class)) {
            return this.getMemoryBlockRetrieval();
        }
        if (adapter.equals(IModuleRetrieval.class)) {
            return this.getModuleManager();
        }
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }

    @Override
    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            ICDITarget cdiTarget = this.getCDITarget();
            if (source == null && event instanceof ICDIDestroyedEvent) {
                this.handleTerminatedEvent((ICDIDestroyedEvent)event);
            } else if (source != null && cdiTarget != null && source.getTarget().equals(cdiTarget)) {
                if (event instanceof ICDICreatedEvent) {
                    if (source instanceof ICDIThread) {
                        this.handleThreadCreatedEvent((ICDICreatedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.getModuleManager().sharedLibraryLoaded((ICDISharedLibrary)source);
                    }
                } else if (event instanceof ICDISuspendedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleSuspendedEvent((ICDISuspendedEvent)event);
                    }
                } else if (event instanceof ICDIResumedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleResumedEvent((ICDIResumedEvent)event);
                    }
                } else if (event instanceof ICDIExitedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleExitedEvent((ICDIExitedEvent)event);
                    }
                } else if (event instanceof ICDIDestroyedEvent) {
                    if (source instanceof ICDIThread) {
                        this.handleThreadTerminatedEvent((ICDIDestroyedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.getModuleManager().sharedLibraryUnloaded((ICDISharedLibrary)source);
                    }
                } else if (event instanceof ICDIDisconnectedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                    }
                } else if (event instanceof ICDIChangedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleChangedEvent((ICDIChangedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.handleSymbolsLoaded((ICDISharedLibrary)source);
                    }
                    if (source instanceof ICDISignal) {
                        this.getSignalManager().signalChanged((ICDISignal)source);
                    }
                } else if (event instanceof ICDIRestartedEvent && source instanceof ICDITarget) {
                    this.handleRestartedEvent((ICDIRestartedEvent)event);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean canRestart() {
        return this.getConfiguration().supportsRestart() && this.isSuspended();
    }

    @Override
    public void restart() throws DebugException {
        ICDITarget cdiTarget;
        block9: {
            if (!this.canRestart()) {
                return;
            }
            cdiTarget = this.getCDITarget();
            if (cdiTarget == null) {
                return;
            }
            try {
                ILaunchConfiguration launchConfig = this.getLaunch().getLaunchConfiguration();
                if (!launchConfig.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true)) break block9;
                String mainSymbol = launchConfig.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                ICDILocation location = null;
                try {
                    IAddress address = this.getAddressFactory().createAddress(mainSymbol);
                    location = cdiTarget.createAddressLocation(address.getValue());
                }
                catch (NumberFormatException nfexc) {
                    location = cdiTarget.createFunctionLocation("", mainSymbol);
                }
                this.setInternalTemporaryBreakpoint(location);
            }
            catch (CoreException e) {
                CDebugTarget.requestFailed(e.getMessage(), (Exception)((Object)e));
            }
        }
        CDebugElementState newState = CDebugElementState.RESTARTING;
        this.changeState(newState);
        try {
            cdiTarget.restart();
        }
        catch (CDIException e) {
            if (this.getState() == newState) {
                this.restoreOldState();
            }
            CDebugTarget.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected() && !this.isDisconnecting();
    }

    protected boolean isTerminating() {
        return this.getState().equals(CDebugElementState.TERMINATING);
    }

    protected void terminated() {
        if (!this.isTerminated()) {
            if (!this.isDisconnected()) {
                this.setState(CDebugElementState.TERMINATED);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected boolean isDisconnecting() {
        return this.getState().equals(CDebugElementState.DISCONNECTING);
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setState(CDebugElementState.DISCONNECTED);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void cleanup() {
        this.resetStatus();
        this.removeAllThreads();
        this.getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.saveFormats();
        this.saveGlobalVariables();
        this.disposeGlobalVariableManager();
        this.disposeModuleManager();
        this.disposeSignalManager();
        this.saveRegisterGroups();
        this.disposeRegisterManager();
        this.saveMemoryBlocks();
        this.disposeMemoryBlockRetrieval();
        this.disposeDisassembly();
        this.disposeSourceManager();
        this.disposeSourceLookupPath();
        this.disposeBreakpointManager();
        this.removeAllExpressions();
        this.disposePreferences();
        ICDITarget cdiTarget = this.getCDITarget();
        if (cdiTarget instanceof ICDIDisposable) {
            ((ICDIDisposable)((Object)cdiTarget)).dispose();
        }
    }

    protected void removeAllThreads() {
        ArrayList<CThread> threads = this.getThreadList();
        this.setThreadList(new ArrayList<CThread>(0));
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(threads.size());
        for (CThread thread : threads) {
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    protected void removeAllExpressions() {
        IExpressionManager em = DebugPlugin.getDefault().getExpressionManager();
        IExpression[] expressions = em.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (expressions[i] instanceof CExpression && expressions[i].getDebugTarget().equals(this)) {
                em.removeExpression(expressions[i]);
            }
            ++i;
        }
    }

    protected CThread createThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        this.getThreadList().add(thread);
        return thread;
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        CThread thread;
        this.setState(CDebugElementState.SUSPENDED);
        ICDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        this.getRegisterManager().targetSuspended();
        this.getBreakpointManager().skipBreakpoints(false);
        List<CThread> newThreads = this.refreshThreads();
        if (event.getSource() instanceof ICDITarget) {
            if (!(this.getConfiguration() instanceof ICDITargetConfiguration2) || !((ICDITargetConfiguration2)this.getConfiguration()).supportsThreadControl()) {
                this.suspendThreads(event);
            }
        } else if (event.getSource() instanceof ICDIThread && (thread = this.findThread((ICDIThread)event.getSource())) != null && newThreads.contains(thread)) {
            ICDIEvent[] evts = new ICDIEvent[]{event};
            thread.handleDebugEvents(evts);
        }
        if (reason instanceof ICDIEndSteppingRange) {
            this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
        } else if (reason instanceof ICDIBreakpointHit) {
            this.handleBreakpointHit((ICDIBreakpointHit)reason);
        } else if (reason instanceof ICDISignalReceived) {
            this.handleSuspendedBySignal((ICDISignalReceived)reason);
        } else if (reason instanceof ICDIWatchpointTrigger) {
            this.handleWatchpointTrigger((ICDIWatchpointTrigger)reason);
        } else if (reason instanceof ICDIWatchpointScope) {
            this.handleWatchpointScope((ICDIWatchpointScope)reason);
        } else if (reason instanceof ICDIErrorInfo) {
            this.handleErrorInfo((ICDIErrorInfo)reason);
        } else if (reason instanceof ICDISharedLibraryEvent) {
            this.handleSuspendedBySolibEvent((ICDISharedLibraryEvent)reason);
        } else if (reason instanceof ICDIEventBreakpointHit) {
            this.handleEventBreakpointHit((ICDIEventBreakpointHit)reason);
        } else {
            this.fireSuspendEvent(0);
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.setState(CDebugElementState.RESUMED);
        this.setCurrentStateInfo(null);
        this.resetStatus();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(10);
        int detail = 0;
        switch (event.getType()) {
            case 0: {
                detail = 32;
                break;
            }
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        debugEvents.add(this.createResumeEvent(detail));
        if (!(this.getConfiguration() instanceof ICDITargetConfiguration2) || !((ICDITargetConfiguration2)this.getConfiguration()).supportsThreadControl()) {
            this.resumeThreads(debugEvents, detail);
        }
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(0);
    }

    private void handleBreakpointHit(ICDIBreakpointHit breakpointHit) {
        this.fireSuspendEvent(16);
    }

    private void handleEventBreakpointHit(ICDIEventBreakpointHit breakpointHit) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointTrigger(ICDIWatchpointTrigger wt) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointScope(ICDIWatchpointScope ws) {
        this.getBreakpointManager().watchpointOutOfScope(ws.getWatchpoint());
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignalReceived signal) {
        this.fireSuspendEvent(32);
    }

    private void handleErrorInfo(ICDIErrorInfo info) {
        this.setStatus(2, info != null ? info.getMessage() : null);
        if (info != null) {
            MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 10002, CoreModelMessages.getString("CDebugTarget.1"), null);
            StringTokenizer st = new StringTokenizer(info.getDetailMessage(), "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() > 200) {
                    token = token.substring(0, 200);
                }
                status.add((IStatus)new Status(4, status.getPlugin(), 10002, token, null));
            }
            CDebugUtils.error((IStatus)status, this);
        }
        this.fireSuspendEvent(0);
    }

    private void handleSuspendedBySolibEvent(ICDISharedLibraryEvent solibEvent) {
        this.fireSuspendEvent(0);
    }

    private void handleExitedEvent(ICDIExitedEvent event) {
        this.removeAllThreads();
        this.setState(CDebugElementState.EXITED);
        this.setCurrentStateInfo(event.getReason());
        this.fireChangeEvent(512);
        ICDISessionConfiguration sessionConfig = this.getCDISession().getConfiguration();
        if (sessionConfig != null && sessionConfig.terminateSessionOnExit()) {
            this.terminated();
        }
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
        this.terminated();
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.disconnected();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    private void handleRestartedEvent(ICDIRestartedEvent event) {
    }

    private void handleThreadCreatedEvent(ICDICreatedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread == null) {
            thread = this.createThread(cdiThread);
            thread.fireCreationEvent();
        }
    }

    private void handleThreadTerminatedEvent(ICDIDestroyedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        ArrayList<CThread> threads = this.getThreadList();
        ArrayList<CThread> threadsToRemove = new ArrayList<CThread>(1);
        int i = 0;
        while (i < threads.size()) {
            CThread cthread = (CThread)threads.get(i);
            ICDIThread cdithread = cthread.getCDIThread();
            if (cdithread == null || cdithread.equals(cdiThread)) {
                threadsToRemove.add(cthread);
            }
            ++i;
        }
        for (CThread cthread : threadsToRemove) {
            threads.remove(cthread);
            cthread.terminated();
            cthread.fireTerminateEvent();
        }
    }

    public CThread findThread(ICDIThread cdiThread) {
        return this.findThread(this.getThreadList(), cdiThread);
    }

    public CThread findThread(List<CThread> threads, ICDIThread cdiThread) {
        int i = 0;
        while (i < threads.size()) {
            CThread t = threads.get(i);
            ICDIThread thisCdiThread = t.getCDIThread();
            if (thisCdiThread != null && thisCdiThread.equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    protected ICDITargetConfiguration getConfiguration() {
        return this.fConfig;
    }

    private void setConfiguration(ICDITargetConfiguration config) {
        this.fConfig = config;
    }

    protected boolean supportsExpressionEvaluation() {
        return this.getConfiguration().supportsExpressionEvaluation();
    }

    public void expressionAdded(IExpression expression) {
    }

    public void expressionChanged(IExpression expression) {
    }

    public void expressionRemoved(IExpression expression) {
        if (expression instanceof CExpression && expression.getDebugTarget().equals(this)) {
            ((CExpression)expression).dispose();
        }
    }

    public void setInternalTemporaryBreakpoint(ICDILocation location) throws DebugException {
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget == null) {
                return;
            }
            if (location instanceof ICDIFunctionLocation) {
                cdiTarget.setFunctionBreakpoint(1, (ICDIFunctionLocation)location, null, false);
            } else if (location instanceof ICDILineLocation) {
                cdiTarget.setLineBreakpoint(1, (ICDILineLocation)location, null, false);
            } else if (location instanceof ICDIAddressLocation) {
                cdiTarget.setAddressBreakpoint(1, (ICDIAddressLocation)location, null, false);
            } else {
                CDebugTarget.targetRequestFailed("not_a_location", null);
            }
        }
        catch (CDIException e) {
            CDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected IThread getCurrentThread() {
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (((CThread)threads[i]).isCurrent()) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        return this.getLaunch().getSourceLocator();
    }

    @Override
    public boolean isLittleEndian() {
        if (this.fIsLittleEndian == null) {
            this.fIsLittleEndian = Boolean.TRUE;
            IBinaryParser.IBinaryObject file = this.getBinaryFile();
            if (file != null) {
                this.fIsLittleEndian = file.isLittleEndian();
            }
        }
        return this.fIsLittleEndian;
    }

    @Override
    public IBinaryParser.IBinaryObject getExecFile() {
        return this.getBinaryFile();
    }

    public IBinaryParser.IBinaryObject getBinaryFile() {
        return this.fBinaryFile;
    }

    private void setExecFile(IBinaryParser.IBinaryObject file) {
        this.fBinaryFile = file;
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public IGlobalVariableDescriptor[] getGlobals() throws DebugException {
        IBinaryParser.IBinaryObject file;
        ICDITarget cdiTarget = this.getCDITarget();
        boolean hasCDIGlobals = false;
        ArrayList<IGlobalVariableDescriptor> list = new ArrayList<IGlobalVariableDescriptor>();
        if (cdiTarget instanceof ICDITarget2) {
            ICDIGlobalVariableDescriptor[] cdiGlobals = ((ICDITarget2)cdiTarget).getGlobalVariables();
            boolean bl = hasCDIGlobals = cdiGlobals != null;
            if (hasCDIGlobals) {
                int i = 0;
                while (i < cdiGlobals.length) {
                    list.add(CVariableFactory.createGlobalVariableDescriptor(cdiGlobals[i].getName(), null));
                    ++i;
                }
            }
        }
        if (!hasCDIGlobals && (file = this.getBinaryFile()) != null) {
            list.addAll(this.getCFileGlobals(file));
        }
        return list.toArray(new IGlobalVariableDescriptor[list.size()]);
    }

    private List<IGlobalVariableDescriptor> getCFileGlobals(IBinaryParser.IBinaryObject file) {
        ArrayList<IGlobalVariableDescriptor> list = new ArrayList<IGlobalVariableDescriptor>();
        IBinaryParser.ISymbol[] symbols = file.getSymbols();
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i].getType() == 2) {
                list.add(CVariableFactory.createGlobalVariableDescriptor(symbols[i]));
            }
            ++i;
        }
        return list;
    }

    protected void setModuleManager(CModuleManager mm) {
        this.fModuleManager = mm;
    }

    protected CModuleManager getModuleManager() {
        return this.fModuleManager;
    }

    protected void disposeModuleManager() {
        this.fModuleManager.dispose();
        this.fModuleManager = null;
    }

    protected void setSignalManager(CSignalManager sm) {
        this.fSignalManager = sm;
    }

    protected CSignalManager getSignalManager() {
        return this.fSignalManager;
    }

    protected void disposeSignalManager() {
        this.fSignalManager.dispose();
    }

    protected void saveRegisterGroups() {
        this.fRegisterManager.save();
    }

    protected void disposeRegisterManager() {
        this.fRegisterManager.dispose();
    }

    protected void saveGlobalVariables() {
        this.fGlobalVariableManager.save();
    }

    protected void saveFormats() {
        this.fFormatManager.save();
    }

    protected void disposeGlobalVariableManager() {
        this.fGlobalVariableManager.dispose();
    }

    @Override
    public boolean canResumeWithoutSignal() {
        return this.canResume() && this.getCurrentStateInfo() instanceof ICDISignalReceived;
    }

    @Override
    public void resumeWithoutSignal() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        CDebugElementState newState = CDebugElementState.RESUMING;
        this.changeState(newState);
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                cdiTarget.resume(false);
            }
        }
        catch (CDIException e) {
            if (this.getState() == newState) {
                this.restoreOldState();
            }
            CDebugTarget.targetRequestFailed(e.getMessage(), e);
        }
    }

    public CRegisterManager getRegisterManager() {
        this.fRegisterManager.initialize();
        return this.fRegisterManager;
    }

    protected void setRegisterManager(CRegisterManager registerManager) {
        this.fRegisterManager = registerManager;
    }

    public IRegisterGroup[] getRegisterGroups(CStackFrame frame) throws DebugException {
        return this.getRegisterManager().getRegisterGroups(frame);
    }

    protected void disposeSourceManager() {
        IResourceChangeListener listener;
        ISourceLocator locator = this.getSourceLocator();
        if (locator instanceof IAdaptable && (listener = (IResourceChangeListener)((IAdaptable)locator).getAdapter(IResourceChangeListener.class)) != null) {
            CCorePlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    protected void disposeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] participants = ((ISourceLookupDirector)locator).getParticipants();
            int i = 0;
            while (i < participants.length) {
                if (participants[i] instanceof CSourceLookupParticipant) {
                    ((CSourceLookupParticipant)participants[i]).removeSourceLookupChangeListener(this);
                }
                ++i;
            }
        }
    }

    protected void saveMemoryBlocks() {
        this.getMemoryBlockRetrieval().save();
    }

    protected void disposeMemoryBlockRetrieval() {
        this.getMemoryBlockRetrieval().dispose();
    }

    protected CBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    protected void setBreakpointManager(CBreakpointManager manager) {
        this.fBreakpointManager = manager;
    }

    protected void disposeBreakpointManager() {
        if (this.getBreakpointManager() != null) {
            this.getBreakpointManager().dispose();
        }
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public IDisassembly getDisassembly() throws DebugException {
        return this.fDisassembly;
    }

    public DisassemblyRetrieval getDisassemblyRetrieval() {
        return this.fDisassemblyRetrieval;
    }

    @Override
    public ICSignal[] getSignals() throws DebugException {
        CSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals();
        }
        return new ICSignal[0];
    }

    @Override
    public boolean hasSignals() throws DebugException {
        CSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals().length > 0;
        }
        return false;
    }

    private void createDisassembly() {
        this.fDisassembly = new Disassembly(this);
        this.fDisassemblyRetrieval = new DisassemblyRetrieval(this);
    }

    private void disposeDisassembly() {
        if (this.fDisassembly != null) {
            this.fDisassembly.dispose();
        }
        this.fDisassembly = null;
        if (this.fDisassemblyRetrieval != null) {
            this.fDisassemblyRetrieval.dispose();
        }
        this.fDisassemblyRetrieval = null;
    }

    @Override
    public IAddress getBreakpointAddress(ICLineBreakpoint breakpoint) throws DebugException {
        return this.getBreakpointManager() != null ? this.getBreakpointManager().getBreakpointAddress(breakpoint) : this.getAddressFactory().getZero();
    }

    @Override
    public void enableInstructionStepping(boolean enabled) {
        this.fPreferences.setValue("instruction_stepping_mode", enabled);
    }

    @Override
    public boolean isInstructionSteppingEnabled() {
        return this.fPreferences.getBoolean("instruction_stepping_mode");
    }

    @Override
    public boolean supportsInstructionStepping() {
        return this.getConfiguration().supportsInstructionStepping();
    }

    private void initializePreferences() {
        this.fPreferences = new Preferences();
        this.fPreferences.setDefault("instruction_stepping_mode", CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_INSTRUCTION_STEP_MODE_ON));
    }

    private void disposePreferences() {
        if (this.fPreferences != null) {
            CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_INSTRUCTION_STEP_MODE_ON, this.fPreferences.getBoolean("instruction_stepping_mode"));
            CDebugCorePlugin.getDefault().savePluginPreferences();
        }
        this.fPreferences = null;
    }

    @Override
    public void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.removePropertyChangeListener(listener);
        }
    }

    protected CGlobalVariableManager getGlobalVariableManager() {
        return this.fGlobalVariableManager;
    }

    private void setGlobalVariableManager(CGlobalVariableManager globalVariableManager) {
        this.fGlobalVariableManager = globalVariableManager;
    }

    protected CSettingsManager getFormatManager() {
        return this.fFormatManager;
    }

    private void setFormatManager(CSettingsManager formatManager) {
        this.fFormatManager = formatManager;
    }

    @Override
    public boolean isPostMortem() {
        return false;
    }

    public IAddressFactory getAddressFactory() {
        if (this.fAddressFactory == null) {
            IBinaryParser.IBinaryObject file;
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget instanceof ICDIAddressFactoryManagement) {
                this.fAddressFactory = ((ICDIAddressFactoryManagement)((Object)cdiTarget)).getAddressFactory();
            }
            if (this.fAddressFactory == null && this.getExecFile() != null && this.getProject() != null && (file = this.getBinaryFile()) != null) {
                this.fAddressFactory = file.getAddressFactory();
            }
            if (this.fAddressFactory == null) {
                this.fAddressFactory = new Addr64Factory();
            }
        }
        return this.fAddressFactory;
    }

    private CMemoryBlockRetrievalExtension getMemoryBlockRetrieval() {
        return this.fMemoryBlockRetrieval;
    }

    private void setMemoryBlockRetrieval(CMemoryBlockRetrievalExtension memoryBlockRetrieval) {
        this.fMemoryBlockRetrieval = memoryBlockRetrieval;
    }

    private void changeState(CDebugElementState state) {
        this.setState(state);
        Iterator<CThread> it = this.getThreadList().iterator();
        while (it.hasNext()) {
            it.next().setState(state);
        }
    }

    protected void restoreOldState() {
        this.restoreState();
        Iterator<CThread> it = this.getThreadList().iterator();
        while (it.hasNext()) {
            it.next().restoreState();
        }
    }

    private void handleSymbolsLoaded(ICDISharedLibrary library) {
        this.getModuleManager().symbolsLoaded(library);
    }

    public ICGlobalVariable createGlobalVariable(IGlobalVariableDescriptor info) throws DebugException {
        ICDIGlobalVariableDescriptor vo = null;
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                vo = cdiTarget.getGlobalVariableDescriptors(info.getPath().lastSegment(), null, info.getName());
            }
        }
        catch (CDIException e) {
            throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, e.getMessage(), null));
        }
        return CVariableFactory.createGlobalVariable(this, info, vo);
    }

    @Override
    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.setSourceLookupPath(director.getSourceContainers());
    }

    private void setSourceLookupPath(ISourceContainer[] containers) {
        LinkedHashSet<String> list = new LinkedHashSet<String>(containers.length);
        this.getSourceLookupPath(list, containers);
        try {
            ICDITarget cdiTarget = this.getCDITarget();
            if (cdiTarget != null) {
                cdiTarget.setSourcePaths(list.toArray(new String[list.size()]));
            }
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
    }

    private void getSourceLookupPath(LinkedHashSet<String> list, ISourceContainer[] containers) {
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                ISourceContainer container;
                block16: {
                    File dir;
                    IContainer folderContainer;
                    IPath location;
                    IProject project;
                    container = iSourceContainerArray[n2];
                    String pathToAdd = null;
                    if (container instanceof CProjectSourceContainer) {
                        project = ((CProjectSourceContainer)container).getProject();
                        if (project != null && project.exists() && (location = project.getLocation()) != null) {
                            pathToAdd = location.toPortableString();
                        }
                    } else if (container instanceof ProjectSourceContainer) {
                        project = ((ProjectSourceContainer)container).getProject();
                        if (project != null && project.exists() && (location = project.getLocation()) != null) {
                            pathToAdd = location.toPortableString();
                        }
                    } else if (container instanceof FolderSourceContainer && (folderContainer = ((FolderSourceContainer)container).getContainer()) != null && folderContainer.exists() && (location = folderContainer.getLocation()) != null) {
                        pathToAdd = location.toPortableString();
                    }
                    if (container instanceof DirectorySourceContainer && (dir = ((DirectorySourceContainer)container).getDirectory()) != null && dir.exists()) {
                        Path path = new Path(dir.getAbsolutePath());
                        pathToAdd = path.toPortableString();
                    }
                    if (pathToAdd == null) break block16;
                    if (list.contains(pathToAdd)) break block17;
                    list.add(pathToAdd);
                }
                if (container.isComposite()) {
                    try {
                        this.getSourceLookupPath(list, container.getSourceContainers());
                    }
                    catch (CoreException e) {
                        CDebugCorePlugin.log(e.getStatus());
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public IRegisterDescriptor[] getRegisterDescriptors() throws DebugException {
        return this.getRegisterManager().getAllRegisterDescriptors();
    }

    @Override
    public void addRegisterGroup(String name, IRegisterDescriptor[] descriptors) {
        this.getRegisterManager().addRegisterGroup(name, descriptors);
    }

    @Override
    public void removeRegisterGroups(IRegisterGroup[] groups) {
        this.getRegisterManager().removeRegisterGroups(groups);
    }

    @Override
    public void modifyRegisterGroup(IPersistableRegisterGroup group, IRegisterDescriptor[] descriptors) {
        this.getRegisterManager().modifyRegisterGroup(group, descriptors);
    }

    @Override
    public void restoreDefaultRegisterGroups() {
        this.getRegisterManager().restoreDefaults();
    }

    protected void skipBreakpoints(boolean enabled) {
        this.getBreakpointManager().skipBreakpoints(enabled);
    }

    private void stopAtLocation(ICDILocation location, String stopExpression) throws DebugException {
        block3: {
            try {
                this.setInternalTemporaryBreakpoint(location);
            }
            catch (CoreException e) {
                boolean isTerminated;
                ICDITarget cdiTarget = this.getCDITarget();
                boolean bl = isTerminated = cdiTarget != null && cdiTarget.isTerminated();
                if (isTerminated) {
                    String message = MessageFormat.format((String)CoreModelMessages.getString("CDebugTarget.0"), (Object[])new String[]{stopExpression});
                    MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 0, message, null);
                    status.add(e.getStatus());
                    throw new DebugException((IStatus)status);
                }
                String message = MessageFormat.format((String)CoreModelMessages.getString("CDebugTarget.2"), (Object[])new String[]{stopExpression, e.getStatus().getMessage()});
                Status newStatus = new Status(2, e.getStatus().getPlugin(), 10000, message, null);
                if (CDebugUtils.question((IStatus)newStatus, this)) break block3;
                throw new DebugException((IStatus)new Status(0, e.getStatus().getPlugin(), e.getStatus().getCode(), e.getStatus().getMessage(), null));
            }
        }
    }

    protected void stopAtSymbol(String stopSymbol) throws DebugException {
        ICDITarget cdiTarget = this.getCDITarget();
        if (cdiTarget != null) {
            ICDIFunctionLocation location = cdiTarget.createFunctionLocation("", stopSymbol);
            this.stopAtLocation(location, stopSymbol);
        }
    }

    protected void stopAtAddress(IAddress address) throws DebugException {
        ICDITarget cdiTarget = this.getCDITarget();
        if (cdiTarget != null) {
            ICDIAddressLocation location = cdiTarget.createAddressLocation(address.getValue());
            this.stopAtLocation(location, address.toHexAddressString());
        }
    }

    protected void stopInMain() throws DebugException {
        block3: {
            String mainSymbol = "main";
            try {
                ICDITarget cdiTarget = this.getCDITarget();
                if (cdiTarget != null) {
                    mainSymbol = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                    ICDIFunctionLocation location = cdiTarget.createFunctionLocation("", mainSymbol);
                    this.setInternalTemporaryBreakpoint(location);
                }
            }
            catch (CoreException e) {
                String message = MessageFormat.format((String)CoreModelMessages.getString("CDebugTarget.2"), (Object[])new String[]{mainSymbol, e.getStatus().getMessage()});
                Status newStatus = new Status(2, e.getStatus().getPlugin(), 10000, message, null);
                if (CDebugUtils.question((IStatus)newStatus, this)) break block3;
                this.terminate();
                throw new DebugException((IStatus)new Status(0, e.getStatus().getPlugin(), e.getStatus().getCode(), e.getStatus().getMessage(), null));
            }
        }
    }

    @Override
    public boolean hasModules() throws DebugException {
        CModuleManager mm = this.getModuleManager();
        if (mm != null) {
            return mm.hasModules();
        }
        return false;
    }

    @Override
    public ICModule[] getModules() throws DebugException {
        CModuleManager mm = this.getModuleManager();
        if (mm != null) {
            return mm.getModules();
        }
        return new ICModule[0];
    }

    @Override
    public void loadSymbolsForAllModules() throws DebugException {
        CModuleManager mm = this.getModuleManager();
        if (mm != null) {
            mm.loadSymbolsForAllModules();
        }
    }

    public String getInternalID() {
        return this.internalD;
    }
}

