/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;

class LogReader
implements Runnable,
IRunnableWithProgress {
    private static long lastModified = -1L;
    private static String contents = null;

    LogReader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            IRemoteFileProxy proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            IFileStore fileStore = proxy.getResource(Oprofile.getLogFile());
            if (!fileStore.fetchInfo().exists()) return;
            long modified = fileStore.fetchInfo().getLastModified();
            if (modified != lastModified) {
                lastModified = modified;
                contents = "";
            }
            Throwable throwable = null;
            Object var6_9 = null;
            try {
                InputStream is = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
                try {
                    try (BufferedReader bi = new BufferedReader(new InputStreamReader(is));){
                        String line;
                        while ((line = bi.readLine()) != null) {
                            contents = String.valueOf(contents) + line + "\n";
                        }
                        bi.close();
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            contents = OprofileUiMessages.getString("oprofiled.logreader.error.fileNotFound");
            return;
        }
        catch (IOException e) {
            lastModified = 0L;
            contents = OprofileUiMessages.getString("oprofiled.logreader.error.io");
            return;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getLogContents() {
        return contents;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.run();
    }
}

