/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.BaseDataManipulator;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDataManipulator
extends BaseDataManipulator
implements IPerfData {
    private String text;
    private String title;
    private ILaunch launch;
    private IPath pathWorkDir;
    private List<Thread> threads;
    protected IProject project;

    AbstractDataManipulator(String title, IPath pathWorkDir, IProject project) {
        this.title = title;
        this.pathWorkDir = pathWorkDir;
        this.threads = new ArrayList<Thread>();
        this.project = project;
    }

    @Override
    public String getPerfData() {
        return this.text;
    }

    protected IPath getWorkDir() {
        return this.pathWorkDir;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public void performCommand(String[] cmd, int fd) {
        BufferedReader buffData = null;
        BufferedReader buffTemp = null;
        try {
            try {
                Process proc = null;
                IFileStore workDirStore = this.getWorkingDirStore();
                proc = RuntimeProcessFactory.getFactory().exec(cmd, null, workDirStore, this.project);
                StringBuffer data = new StringBuffer();
                StringBuffer temp = new StringBuffer();
                switch (fd) {
                    case 2: {
                        buffData = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        buffTemp = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        this.readStream(buffTemp, temp);
                        this.readStream(buffData, data);
                        break;
                    }
                    default: {
                        buffData = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        buffTemp = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        this.readStream(buffData, data);
                        this.readStream(buffTemp, temp);
                    }
                }
                this.joinAll();
                this.text = data.toString();
            }
            catch (IOException | InterruptedException e) {
                this.text = "";
                try {
                    if (buffData != null) {
                        buffData.close();
                    }
                    if (buffTemp != null) {
                        buffTemp.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (buffData != null) {
                    buffData.close();
                }
                if (buffTemp != null) {
                    buffTemp.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void performCommand(String[] cmd, String file) {
        Process proc = null;
        try {
            IRemoteFileProxy fileProxy;
            try {
                fileProxy = RemoteProxyManager.getInstance().getFileProxy(this.project);
            }
            catch (RemoteConnectionException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
                return;
            }
            IFileStore workDirStore = this.getWorkingDirStore();
            proc = RuntimeProcessFactory.getFactory().exec(cmd, null, workDirStore, this.project, new PTY());
            DebugPlugin.newProcess((ILaunch)this.launch, (Process)proc, (String)"");
            proc.waitFor();
            StringBuffer data = new StringBuffer();
            Throwable throwable = null;
            Object var8_12 = null;
            try (BufferedReader buffData = new BufferedReader(new InputStreamReader(fileProxy.getResource(file).openInputStream(0, null)));){
                this.readStream(buffData, data);
                this.joinAll();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.text = data.toString();
        }
        catch (IOException | CoreException e) {
            this.text = "";
        }
        catch (InterruptedException e) {
            this.text = "";
        }
    }

    private void readStream(final BufferedReader buff, final StringBuffer strBuff) {
        Thread readThread = new Thread(new Runnable(){

            @Override
            public void run() {
                strBuff.append(AbstractDataManipulator.this.getBufferContents(buff));
            }
        });
        readThread.start();
        this.threads.add(readThread);
    }

    private void joinAll() throws InterruptedException {
        for (Thread thread : this.threads) {
            thread.join();
        }
    }

    public abstract void parse();

    private IFileStore getWorkingDirStore() {
        IRemoteFileProxy fileProxy;
        try {
            fileProxy = RemoteProxyManager.getInstance().getFileProxy(this.project);
            if (fileProxy == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
            return null;
        }
        return fileProxy.getResource(this.pathWorkDir.toOSString());
    }
}

