/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;

public class TreeViewerFrameSource
implements IFrameSource {
    private AbstractTreeViewer viewer;

    public TreeViewerFrameSource(AbstractTreeViewer viewer) {
        this.viewer = viewer;
    }

    public void connectTo(FrameList frameList) {
        frameList.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TreeViewerFrameSource.this.handlePropertyChange(event);
            }
        });
    }

    protected TreeFrame createFrame(Object input) {
        return new TreeFrame(this.viewer, input);
    }

    protected void frameChanged(TreeFrame frame) {
        this.viewer.getControl().setRedraw(false);
        this.viewer.setInput(frame.getInput());
        this.viewer.setExpandedElements(frame.getExpandedElements());
        this.viewer.setSelection(frame.getSelection(), true);
        this.viewer.getControl().setRedraw(true);
    }

    protected Frame getCurrentFrame(int flags) {
        Object input = this.viewer.getInput();
        TreeFrame frame = this.createFrame(input);
        if ((flags & 1) != 0) {
            frame.setSelection(this.viewer.getSelection());
            frame.setExpandedElements(this.viewer.getExpandedElements());
        }
        return frame;
    }

    @Override
    public Frame getFrame(int whichFrame, int flags) {
        switch (whichFrame) {
            case 1: {
                return this.getCurrentFrame(flags);
            }
            case 3: {
                return this.getParentFrame(flags);
            }
            case 2: {
                return this.getSelectionFrame(flags);
            }
        }
        return null;
    }

    protected Frame getParentFrame(int flags) {
        Object input = this.viewer.getInput();
        ITreeContentProvider provider = (ITreeContentProvider)this.viewer.getContentProvider();
        Object parent = provider.getParent(input);
        if (parent == null) {
            return null;
        }
        TreeFrame frame = this.createFrame(parent);
        if ((flags & 1) != 0) {
            frame.setSelection(this.viewer.getSelection());
            Object[] expanded = this.viewer.getExpandedElements();
            Object[] newExpanded = new Object[expanded.length + 1];
            System.arraycopy(expanded, 0, newExpanded, 0, expanded.length);
            newExpanded[newExpanded.length - 1] = input;
            frame.setExpandedElements(newExpanded);
        }
        return frame;
    }

    protected Frame getSelectionFrame(int flags) {
        Object o;
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (sel.size() == 1 && this.viewer.isExpandable(o = sel.getFirstElement())) {
            TreeFrame frame = this.createFrame(o);
            if ((flags & 1) != 0) {
                frame.setSelection(this.viewer.getSelection());
                frame.setExpandedElements(this.viewer.getExpandedElements());
            }
            return frame;
        }
        return null;
    }

    public AbstractTreeViewer getViewer() {
        return this.viewer;
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if ("currentFrame".equals(event.getProperty())) {
            this.frameChanged((TreeFrame)event.getNewValue());
        }
    }
}

