/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.aspect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.Messages;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public interface ITmfEventAspect {
    public static final String EMPTY_STRING = "";
    public static final List<ITmfEventAspect> BASE_ASPECTS = (List)NonNullUtils.checkNotNull((Object)ImmutableList.of((Object)BaseAspects.TIMESTAMP, (Object)BaseAspects.EVENT_TYPE, (Object)BaseAspects.CONTENTS, (Object)BaseAspects.TRACE_NAME));

    public String getName();

    public String getHelpText();

    @Nullable
    public Object resolve(ITmfEvent var1);

    public static interface BaseAspects {
        public static final ITmfEventAspect TIMESTAMP = new ITmfEventAspect(){

            @Override
            public String getName() {
                return Messages.getMessage(Messages.AspectName_Timestamp);
            }

            @Override
            public String getHelpText() {
                return ITmfEventAspect.EMPTY_STRING;
            }

            @Override
            @Nullable
            public ITmfTimestamp resolve(ITmfEvent event) {
                return event.getTimestamp();
            }
        };
        public static final ITmfEventAspect EVENT_TYPE = new ITmfEventAspect(){

            @Override
            public String getName() {
                return Messages.getMessage(Messages.AspectName_EventType);
            }

            @Override
            public String getHelpText() {
                return Messages.getMessage(Messages.AspectHelpText_EventType);
            }

            @Override
            @Nullable
            public String resolve(ITmfEvent event) {
                ITmfEventType type = event.getType();
                if (type == null) {
                    return null;
                }
                return type.getName();
            }
        };
        public static final TmfEventFieldAspect CONTENTS = new TmfEventFieldAspect(Messages.getMessage(Messages.AspectName_Contents), null, new TmfEventFieldAspect.IRootField(){

            @Override
            @Nullable
            public ITmfEventField getRootField(ITmfEvent event) {
                return event.getContent();
            }
        }){

            @Override
            public String getHelpText() {
                return Messages.getMessage(Messages.AspectHelpText_Contents);
            }
        };
        public static final ITmfEventAspect TRACE_NAME = new ITmfEventAspect(){

            @Override
            public String getName() {
                return Messages.getMessage(Messages.AspectName_TraceName);
            }

            @Override
            public String getHelpText() {
                return Messages.getMessage(Messages.AspectHelpText_TraceName);
            }

            @Override
            @Nullable
            public String resolve(ITmfEvent event) {
                return event.getTrace().getName();
            }
        };
    }
}

