/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfEventThread;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.tracecompass.internal.tmf.core.request.TmfRequestExecutor;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;

public abstract class TmfEventProvider
extends TmfComponent
implements ITmfEventProvider,
ITmfFilter {
    public static final int DEFAULT_BLOCK_SIZE = 50000;
    private static final long DELAY = 1000L;
    private final List<TmfCoalescedEventRequest> fPendingCoalescedRequests = new LinkedList<TmfCoalescedEventRequest>();
    private Class<? extends ITmfEvent> fType;
    private final TmfRequestExecutor fExecutor;
    private final Object fLock = new Object();
    private int fSignalDepth = 0;
    private int fRequestPendingCounter = 0;
    private Timer fTimer;
    @NonNull
    private TimerTask fCurrentTask = new TimerTask(){

        @Override
        public void run() {
        }
    };
    private boolean fIsTimerEnabled;
    private TmfEventProvider fParent = null;
    private final List<TmfEventProvider> fChildren = Collections.synchronizedList(new ArrayList());

    public TmfEventProvider() {
        this.setTimerEnabled(true);
        this.fExecutor = new TmfRequestExecutor();
    }

    public TmfEventProvider(String name, Class<? extends ITmfEvent> type) {
        this();
        this.init(name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String name, Class<? extends ITmfEvent> type) {
        super.init(name);
        this.fType = type;
        this.fExecutor.init();
        this.fSignalDepth = 0;
        Object object = this.fLock;
        synchronized (object) {
            this.fTimer = new Timer();
        }
        TmfProviderManager.register(this.fType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        TmfProviderManager.deregister(this.fType, this);
        this.fExecutor.stop();
        List<TmfEventProvider> list = this.fLock;
        synchronized (list) {
            if (this.fTimer != null) {
                this.fTimer.cancel();
            }
            this.fTimer = null;
        }
        list = this.fChildren;
        synchronized (list) {
            for (TmfEventProvider child : this.fChildren) {
                child.dispose();
            }
            this.fChildren.clear();
        }
        this.clearPendingRequests();
        super.dispose();
    }

    public Class<? extends ITmfEvent> getType() {
        return this.fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ITmfEventRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            if (TmfCoreTracer.isRequestTraced()) {
                TmfCoreTracer.traceRequest(request.getRequestId(), "SENT to provider " + this.getName());
            }
            if (request.getProviderFilter() == null) {
                request.setProviderFilter(this);
            }
            if (this.sendWithParent(request)) {
                return;
            }
            if (request.getExecType() == ITmfEventRequest.ExecutionType.FOREGROUND) {
                if (this.fSignalDepth > 0 || this.fRequestPendingCounter > 0) {
                    this.coalesceEventRequest(request);
                } else {
                    this.queueRequest(request);
                }
                return;
            }
            if (this.fTimer == null) {
                this.queueRequest(request);
                return;
            }
            this.coalesceEventRequest(request);
            if (this.fIsTimerEnabled) {
                this.fCurrentTask.cancel();
                this.fCurrentTask = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = TmfEventProvider.this.fLock;
                        synchronized (object) {
                            TmfEventProvider.this.fireRequest(true);
                        }
                    }
                };
                this.fTimer.schedule(this.fCurrentTask, 1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRequest(boolean isTimeout) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fRequestPendingCounter > 0) {
                return;
            }
            if (this.fPendingCoalescedRequests.size() > 0) {
                Iterator<TmfCoalescedEventRequest> iter = this.fPendingCoalescedRequests.iterator();
                while (iter.hasNext()) {
                    ITmfEventRequest request;
                    ITmfEventRequest.ExecutionType type = isTimeout ? ITmfEventRequest.ExecutionType.BACKGROUND : ITmfEventRequest.ExecutionType.FOREGROUND;
                    if (type != (request = (ITmfEventRequest)iter.next()).getExecType()) continue;
                    this.queueRequest(request);
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPendingRequest(boolean isIncrement) {
        Object object = this.fLock;
        synchronized (object) {
            if (isIncrement) {
                ++this.fRequestPendingCounter;
            } else {
                if (this.fRequestPendingCounter > 0) {
                    --this.fRequestPendingCounter;
                }
                if (this.fRequestPendingCounter == 0) {
                    this.fireRequest(false);
                    this.fireRequest(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newCoalescedEventRequest(ITmfEventRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(request.getDataType(), request.getRange(), request.getIndex(), request.getNbRequested(), request.getExecType());
            coalescedRequest.addRequest(request);
            coalescedRequest.setProviderFilter(this);
            if (TmfCoreTracer.isRequestTraced()) {
                TmfCoreTracer.traceRequest(request.getRequestId(), "COALESCED with " + coalescedRequest.getRequestId());
                TmfCoreTracer.traceRequest(coalescedRequest.getRequestId(), "now contains " + coalescedRequest.getSubRequestIds());
            }
            this.coalesceChildrenRequests(coalescedRequest);
            this.fPendingCoalescedRequests.add(coalescedRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coalesceEventRequest(ITmfEventRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            for (TmfCoalescedEventRequest coalescedRequest : this.getPendingRequests()) {
                if (!coalescedRequest.isCompatible(request)) continue;
                coalescedRequest.addRequest(request);
                if (TmfCoreTracer.isRequestTraced()) {
                    TmfCoreTracer.traceRequest(request.getRequestId(), "COALESCED with " + coalescedRequest.getRequestId());
                    TmfCoreTracer.traceRequest(coalescedRequest.getRequestId(), "now contains " + coalescedRequest.getSubRequestIds());
                }
                this.coalesceChildrenRequests(coalescedRequest);
                return;
            }
            this.newCoalescedEventRequest(request);
        }
    }

    private boolean sendWithParent(ITmfEventRequest request) {
        ITmfEventProvider parent = this.getParent();
        if (parent instanceof TmfEventProvider) {
            return ((TmfEventProvider)parent).sendIfCompatible(request);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendIfCompatible(ITmfEventRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            TmfCoalescedEventRequest coalescedRequest;
            Iterator<TmfCoalescedEventRequest> iterator = this.getPendingRequests().iterator();
            do {
                if (iterator.hasNext()) continue;
                return this.sendWithParent(request);
            } while (!(coalescedRequest = iterator.next()).isCompatible(request));
            this.sendRequest(request);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coalesceChildrenRequests(TmfCoalescedEventRequest request) {
        List<TmfEventProvider> list = this.fChildren;
        synchronized (list) {
            for (TmfEventProvider child : this.fChildren) {
                child.coalesceCompatibleRequests(request);
            }
        }
    }

    private void coalesceCompatibleRequests(TmfCoalescedEventRequest request) {
        Iterator<TmfCoalescedEventRequest> iter = this.getPendingRequests().iterator();
        while (iter.hasNext()) {
            TmfCoalescedEventRequest pendingRequest = iter.next();
            if (!request.isCompatible(pendingRequest)) continue;
            request.addRequest(pendingRequest);
            if (TmfCoreTracer.isRequestTraced()) {
                TmfCoreTracer.traceRequest(pendingRequest.getRequestId(), "COALESCED with " + request.getRequestId());
                TmfCoreTracer.traceRequest(request.getRequestId(), "now contains " + request.getSubRequestIds());
            }
            iter.remove();
        }
    }

    protected void queueRequest(ITmfEventRequest request) {
        if (this.fExecutor.isShutdown()) {
            request.cancel();
            return;
        }
        TmfEventThread thread = new TmfEventThread(this, request);
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(request.getRequestId(), "QUEUED");
        }
        this.fExecutor.execute(thread);
    }

    public abstract ITmfContext armRequest(ITmfEventRequest var1);

    public boolean isCompleted(ITmfEventRequest request, ITmfEvent event, int nbRead) {
        boolean requestCompleted = TmfEventProvider.isCompleted2(request, nbRead);
        if (!requestCompleted) {
            ITmfTimestamp endTime = request.getRange().getEndTime();
            return event.getTimestamp().compareTo(endTime) > 0;
        }
        return requestCompleted;
    }

    private static boolean isCompleted2(ITmfEventRequest request, int nbRead) {
        return request.isCompleted() || nbRead >= request.getNbRequested();
    }

    protected boolean executorIsShutdown() {
        return this.fExecutor.isShutdown();
    }

    protected boolean executorIsTerminated() {
        return this.fExecutor.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void startSynch(TmfStartSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            ++this.fSignalDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void endSynch(TmfEndSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            --this.fSignalDepth;
            if (this.fSignalDepth == 0) {
                this.fireRequest(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITmfEventProvider getParent() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fParent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(ITmfEventProvider parent) {
        if (!(parent instanceof TmfEventProvider)) {
            throw new IllegalArgumentException();
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fParent = (TmfEventProvider)parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITmfEventProvider> getChildren() {
        List<TmfEventProvider> list = this.fChildren;
        synchronized (list) {
            ArrayList<ITmfEventProvider> list2 = new ArrayList<ITmfEventProvider>();
            list2.addAll(this.fChildren);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ITmfEventProvider> List<T> getChildren(Class<T> clazz) {
        ArrayList<ITmfEventProvider> list = new ArrayList<ITmfEventProvider>();
        List<TmfEventProvider> list2 = this.fChildren;
        synchronized (list2) {
            for (TmfEventProvider child : this.fChildren) {
                if (!clazz.isAssignableFrom(child.getClass())) continue;
                list.add((ITmfEventProvider)clazz.cast(child));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITmfEventProvider getChild(String name) {
        List<TmfEventProvider> list = this.fChildren;
        synchronized (list) {
            for (TmfEventProvider child : this.fChildren) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public ITmfEventProvider getChild(int index) {
        return (ITmfEventProvider)NonNullUtils.checkNotNull((Object)this.fChildren.get(index));
    }

    @Override
    public void addChild(ITmfEventProvider child) {
        if (!(child instanceof TmfEventProvider)) {
            throw new IllegalArgumentException();
        }
        child.setParent(this);
        this.fChildren.add((TmfEventProvider)child);
    }

    @Override
    public int getNbChildren() {
        return this.fChildren.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean matches(ITmfEvent event) {
        if (event.getTrace() == this) {
            return true;
        }
        if (this.fChildren.size() <= 0) return false;
        Object object = this.fLock;
        synchronized (object) {
            TmfEventProvider child;
            List<TmfEventProvider> children = this.getChildren(TmfEventProvider.class);
            Iterator<TmfEventProvider> iterator = children.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(child = iterator.next()).matches(event));
            return true;
        }
    }

    private List<TmfCoalescedEventRequest> getPendingRequests() {
        return this.fPendingCoalescedRequests;
    }

    private void clearPendingRequests() {
        this.fPendingCoalescedRequests.clear();
    }

    private void setTimerEnabled(Boolean enabled) {
        this.fIsTimerEnabled = enabled;
    }
}

