/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.parsers.custom;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;

public class CustomEventAspects {
    @NonNull
    public static Iterable<ITmfEventAspect> generateAspects(CustomTraceDefinition definition) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        List<CustomTraceDefinition.OutputColumn> outputs = definition.outputs;
        int i = 0;
        while (i < outputs.size()) {
            String name = outputs.get((int)i).name;
            if (name != null) {
                builder.add((Object)new CustomEventFieldAspect(name, i));
            }
            ++i;
        }
        return (Iterable)NonNullUtils.checkNotNull((Object)builder.build());
    }

    private static final class CustomEventFieldAspect
    implements ITmfEventAspect {
        @NonNull
        private final String fName;
        private final int fIndex;

        public CustomEventFieldAspect(@NonNull String name, int idx) {
            this.fName = name;
            this.fIndex = idx;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public String getHelpText() {
            return "";
        }

        @Override
        public String resolve(ITmfEvent event) {
            if (event instanceof CustomEvent) {
                String ret = ((CustomEvent)event).getEventString(this.fIndex);
                return ret == null ? "" : ret;
            }
            return "";
        }
    }
}

