/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.trace;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;

public class StreamInputPacketIndexEntry
implements ICTFPacketDescriptor {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\D*(\\d+)");
    private static final int UNKNOWN = -1;
    private final long fOffsetBits;
    private final long fOffsetBytes;
    private final long fPacketSizeBits;
    private final long fContentSizeBits;
    private final long fTimestampBegin;
    private final long fTimestampEnd;
    private final long fLostEvents;
    private final String fTarget;
    private final long fTargetID;
    private final Map<String, Object> fAttributes = new HashMap<String, Object>();

    public StreamInputPacketIndexEntry(long dataOffsetBits, long fileSizeBytes) {
        this.fContentSizeBits = fileSizeBytes * 8L;
        this.fPacketSizeBits = fileSizeBytes * 8L;
        this.fOffsetBits = dataOffsetBits;
        this.fOffsetBytes = dataOffsetBits / 8L;
        this.fLostEvents = 0L;
        this.fTarget = "";
        this.fTargetID = 0L;
        this.fTimestampBegin = Long.MIN_VALUE;
        this.fTimestampEnd = Long.MAX_VALUE;
    }

    public StreamInputPacketIndexEntry(long dataOffsetBits, StructDefinition streamPacketContextDef, long fileSizeBytes, long lostSoFar) {
        for (String field : streamPacketContextDef.getDeclaration().getFieldsList()) {
            Definition id = streamPacketContextDef.lookupDefinition(field);
            if (id instanceof IntegerDefinition) {
                this.fAttributes.put(field, ((IntegerDefinition)id).getValue());
                continue;
            }
            if (id instanceof FloatDefinition) {
                this.fAttributes.put(field, ((FloatDefinition)id).getValue());
                continue;
            }
            if (id instanceof EnumDefinition) {
                this.fAttributes.put(field, ((EnumDefinition)id).getValue());
                continue;
            }
            if (!(id instanceof StringDefinition)) continue;
            this.fAttributes.put(field, ((StringDefinition)id).getValue());
        }
        Long contentSize = (Long)this.fAttributes.get("content_size");
        Long packetSize = (Long)this.fAttributes.get("packet_size");
        Long tsBegin = (Long)this.fAttributes.get("timestamp_begin");
        Long tsEnd = (Long)this.fAttributes.get("timestamp_end");
        boolean hasDevice = this.fAttributes.containsKey("device");
        Long cpuId = (Long)this.fAttributes.get("cpu_id");
        Long lostEvents = (Long)this.fAttributes.get("events_discarded");
        this.fContentSizeBits = contentSize != null ? contentSize : (packetSize != null ? packetSize : fileSizeBytes * 8L);
        this.fPacketSizeBits = packetSize != null ? packetSize : (this.getContentSizeBits() != 0L ? this.fContentSizeBits : fileSizeBytes * 8L);
        this.fTimestampBegin = tsBegin != null ? tsBegin : Long.MIN_VALUE;
        if (tsEnd != null) {
            if (tsEnd == -1L) {
                tsEnd = Long.MAX_VALUE;
            }
            this.fTimestampEnd = tsEnd;
        } else {
            this.fTimestampEnd = Long.MAX_VALUE;
        }
        Target target = StreamInputPacketIndexEntry.lookupTarget(streamPacketContextDef, hasDevice, cpuId);
        this.fTarget = target.string;
        this.fTargetID = target.number;
        this.fLostEvents = lostEvents != null ? lostEvents - lostSoFar : 0L;
        this.fOffsetBits = dataOffsetBits;
        this.fOffsetBytes = dataOffsetBits / 8L;
    }

    private static Target lookupTarget(StructDefinition streamPacketContextDef, boolean hasDevice, Long cpuId) {
        Target ret = new Target();
        if (hasDevice) {
            Definition def = streamPacketContextDef.lookupDefinition("device");
            if (def instanceof SimpleDatatypeDefinition) {
                SimpleDatatypeDefinition simpleDefinition = (SimpleDatatypeDefinition)def;
                ret.string = simpleDefinition.getStringValue();
                ret.number = simpleDefinition.getIntegerValue();
            } else if (def instanceof StringDefinition) {
                StringDefinition stringDefinition = (StringDefinition)def;
                ret.string = stringDefinition.getValue();
                Matcher matcher = NUMBER_PATTERN.matcher(ret.string);
                if (matcher.matches()) {
                    String number = matcher.group(1);
                    ret.number = Integer.parseInt(number);
                }
            }
        } else if (cpuId != null) {
            ret.string = "CPU" + cpuId.toString();
            ret.number = cpuId;
        }
        return ret;
    }

    @Override
    public boolean includes(long ts) {
        return ts >= this.fTimestampBegin && ts <= this.fTimestampEnd;
    }

    public String toString() {
        return "StreamInputPacketIndexEntry [offsetBits=" + this.fOffsetBits + ", timestampBegin=" + this.fTimestampBegin + ", timestampEnd=" + this.fTimestampEnd + "]";
    }

    @Override
    public long getOffsetBits() {
        return this.fOffsetBits;
    }

    @Override
    public long getPacketSizeBits() {
        return this.fPacketSizeBits;
    }

    @Override
    public long getContentSizeBits() {
        return this.fContentSizeBits;
    }

    @Override
    public long getTimestampBegin() {
        return this.fTimestampBegin;
    }

    @Override
    public long getTimestampEnd() {
        return this.fTimestampEnd;
    }

    @Override
    public long getLostEvents() {
        return this.fLostEvents;
    }

    public void addAttribute(String field, Object value) {
        this.fAttributes.put(field, value);
    }

    @Override
    public Object lookupAttribute(String field) {
        return this.fAttributes.get(field);
    }

    @Override
    public String getTarget() {
        return this.fTarget;
    }

    @Override
    public long getTargetId() {
        return this.fTargetID;
    }

    @Override
    public long getOffsetBytes() {
        return this.fOffsetBytes;
    }

    private static class Target {
        public String string = null;
        public long number = -1L;
    }
}

