/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

public final class EnumDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private final EnumTable fTable = new EnumTable();
    private final IntegerDeclaration fContainerType;
    private final Set<String> fLabels = new HashSet<String>();

    public EnumDeclaration(IntegerDeclaration containerType) {
        this.fContainerType = containerType;
    }

    public IntegerDeclaration getContainerType() {
        return this.fContainerType;
    }

    @Override
    public long getAlignment() {
        return this.getContainerType().getAlignment();
    }

    @Override
    public int getMaximumSize() {
        return this.fContainerType.getMaximumSize();
    }

    @Override
    public EnumDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IntegerDefinition value = this.getContainerType().createDefinition(definitionScope, fieldName, input);
        return new EnumDefinition(this, definitionScope, fieldName, value);
    }

    public boolean add(long low, long high, @Nullable String label) {
        this.fLabels.add(label);
        return this.fTable.add(low, high, label);
    }

    @Nullable
    public String query(long value) {
        return this.fTable.query(value);
    }

    public Map<String, Pair> getEnumTable() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (LabelAndRange range : this.fTable.ranges) {
            builder.put((Object)range.getLabel(), (Object)new Pair(range.low, range.high));
        }
        return builder.build();
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.fLabels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] enum[");
        for (String label : this.fLabels) {
            sb.append("label:").append(label).append(' ');
        }
        sb.append("type:").append(this.fContainerType.toString());
        sb.append(']');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException();
        }
        return string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fContainerType.hashCode();
        for (String label : this.fLabels) {
            result = 31 * result + label.hashCode();
        }
        result = 31 * result + this.fTable.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.equals(other.fContainerType)) {
            return false;
        }
        if (this.fLabels.size() != other.fLabels.size()) {
            return false;
        }
        if (!this.fLabels.containsAll(other.fLabels)) {
            return false;
        }
        return this.fTable.equals(other.fTable);
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.isBinaryEquivalent((IDeclaration)other.fContainerType)) {
            return false;
        }
        if (this.fLabels.size() != other.fLabels.size()) {
            return false;
        }
        if (!this.fLabels.containsAll(other.fLabels)) {
            return false;
        }
        return this.fTable.equals(other.fTable);
    }

    private class EnumTable {
        private final List<LabelAndRange> ranges = new LinkedList<LabelAndRange>();

        public synchronized boolean add(long low, long high, @Nullable String label) {
            LabelAndRange newRange = new LabelAndRange(low, high, label);
            for (LabelAndRange r : this.ranges) {
                if (!r.intersects(newRange)) continue;
                return false;
            }
            this.ranges.add(newRange);
            return true;
        }

        @Nullable
        public synchronized String query(long value) {
            for (LabelAndRange r : this.ranges) {
                if (!r.intersects(value)) continue;
                return r.getLabel();
            }
            return null;
        }

        public synchronized int hashCode() {
            int prime = 31;
            int result = 1;
            for (LabelAndRange range : this.ranges) {
                result = 31 * result + range.hashCode();
            }
            return result;
        }

        public synchronized boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumTable other = (EnumTable)obj;
            if (this.ranges.size() != other.ranges.size()) {
                return false;
            }
            int i = 0;
            while (i < this.ranges.size()) {
                if (!this.ranges.get(i).equals(other.ranges.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class LabelAndRange {
        private final long low;
        private final long high;
        @Nullable
        private final String fLabel;

        @Nullable
        public String getLabel() {
            return this.fLabel;
        }

        public LabelAndRange(long low, long high, @Nullable String str) {
            this.low = low;
            this.high = high;
            this.fLabel = str;
        }

        public boolean intersects(long i) {
            return i >= this.low && i <= this.high;
        }

        public boolean intersects(LabelAndRange other) {
            return this.intersects(other.low) || this.intersects(other.high);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            String label = this.fLabel;
            result = 31 * result + (label == null ? 0 : label.hashCode());
            result = 31 * result + (int)(this.high ^ this.high >>> 32);
            result = 31 * result + (int)(this.low ^ this.low >>> 32);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LabelAndRange other = (LabelAndRange)obj;
            String label = this.fLabel;
            if (label == null ? other.fLabel != null : !label.equals(other.fLabel)) {
                return false;
            }
            if (this.high != other.high) {
                return false;
            }
            return this.low == other.low;
        }
    }

    public static class Pair {
        private final long fFirst;
        private final long fSecond;

        private Pair(long first, long second) {
            this.fFirst = first;
            this.fSecond = second;
        }

        public long getFirst() {
            return this.fFirst;
        }

        public long getSecond() {
            return this.fSecond;
        }
    }
}

