/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.wizards;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class StapNewWizardPage
extends WizardPage {
    private Text fileText;
    private Text containerText;
    private ISelection selection;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.linuxtools.internal.systemtap.ui.ide.wizards.stap_strings");

    public StapNewWizardPage(ISelection selection) {
        super(resourceBundle.getString("StapNewWizardPage.WizardPage"));
        this.setTitle(resourceBundle.getString("StapNewWizardPage.Title"));
        this.setDescription(resourceBundle.getString("StapNewWizardPage.setDescription"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(resourceBundle.getString("StapNewWizardPage.ScriptName"));
        this.fileText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StapNewWizardPage.this.dialogChanged();
            }
        });
        new Label(container, 0);
        label = new Label(container, 0);
        label.setText(resourceBundle.getString("StapNewWizardPage.Project"));
        this.containerText = new Text(container, 2052);
        gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StapNewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(resourceBundle.getString("StapNewWizardPage.Browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StapNewWizardPage.this.handleBrowse();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText(".stp");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, resourceBundle.getString("StapNewWizardPage.SelectProjectMessage"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IPath container = Path.fromOSString((String)this.getContainerName());
        String fileName = this.getFileName();
        if (fileName.length() == 0 || fileName.equals(".stp")) {
            this.updateStatus(resourceBundle.getString("StapNewWizardPage.UpdateStatus1"));
            return;
        }
        if (this.getContainerName().length() == 0) {
            this.updateStatus(resourceBundle.getString("StapNewWizardPage.UpdateStatus2"));
            return;
        }
        if (container == null || !container.isValidPath(this.getContainerName())) {
            this.updateStatus(resourceBundle.getString("StapNewWizardPage.UpdateStatus3"));
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(resourceBundle.getString("StapNewWizardPage.UpdateStatus4"));
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("stp")) {
            this.updateStatus(resourceBundle.getString("StapNewWizardPage.UpdateStatus.5"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

