/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class STPPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String STP_PARTITIONING = "__stp_partitioning";
    public static final String STP_STRING = "__stp_string";
    public static final String STP_COMMENT = "__stp_comment";
    public static final String STP_CONDITIONAL = "__stp_conditional";
    public static final String STP_MULTILINE_COMMENT = "__stp_multiline_comment";
    public static final String[] STP_PARTITION_TYPES = new String[]{"__dftl_partition_content_type", "__stp_comment", "__stp_multiline_comment", "__stp_string", "__stp_conditional"};

    public STPPartitionScanner() {
        Token stpComment = new Token((Object)STP_COMMENT);
        Token stpMultilineComment = new Token((Object)STP_MULTILINE_COMMENT);
        Token stpConditional = new Token((Object)STP_CONDITIONAL);
        Token stpString = new Token((Object)STP_STRING);
        EmptyCommentRule emptyCommentRule = new EmptyCommentRule((IToken)stpComment);
        this.setPredicateRules(new IPredicateRule[]{new EndOfLineRule("//", (IToken)stpComment), new MultiLineRule("/*", "*/", (IToken)stpMultilineComment), new EndOfLineRule("#", (IToken)stpComment), emptyCommentRule, new SingleLineRule("\"", "\"", (IToken)stpString, '\\', false, true), new MultiLineRule("%(", "%)", (IToken)stpConditional)});
    }

    private static class EmptyCommentDetector
    implements IWordDetector {
        private EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    private static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

