/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.systemtap.ui.editor.handlers.file.NewFileHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class IDESessionSettings {
    private static STPEditor activeSTPEditor = null;

    public static STPEditor getActiveSTPEditor() {
        if (activeSTPEditor == null) {
            IEditorReference[] editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            STPEditor stpEditor = null;
            IEditorReference[] iEditorReferenceArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                if (editor.getId().equals("org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor")) {
                    if (stpEditor == null) {
                        stpEditor = (STPEditor)editor.getEditor(true);
                    } else {
                        return null;
                    }
                }
                ++n2;
            }
            activeSTPEditor = stpEditor;
        }
        return activeSTPEditor;
    }

    public static void setActiveSTPEditor(STPEditor editor) {
        activeSTPEditor = editor;
    }

    public static STPEditor getOrAskForActiveSTPEditor(boolean checkCurrent) {
        IEditorPart editor;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        STPEditor stpEditor = checkCurrent ? ((editor = page.getActiveEditor()) instanceof STPEditor ? (STPEditor)editor : IDESessionSettings.askForSTPEditor(window)) : IDESessionSettings.askForSTPEditor(window);
        if (stpEditor != null) {
            page.activate((IWorkbenchPart)stpEditor);
        }
        return stpEditor;
    }

    private static STPEditor askForSTPEditor(IWorkbenchWindow window) {
        LinkedList<STPEditor> allEditors = new LinkedList<STPEditor>();
        IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            if (editor.getId().equals("org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor")) {
                allEditors.add((STPEditor)editor.getEditor(true));
            }
            ++n2;
        }
        switch (allEditors.size()) {
            case 1: {
                MessageDialog messageDialog = new MessageDialog(window.getShell(), Localization.getString("GetEditorAction.DialogTitle"), null, MessageFormat.format(Localization.getString("GetEditorAction.AskBeforeOpenMessage"), ((STPEditor)((Object)allEditors.get(0))).getEditorInput().getName()), 3, new String[]{Localization.getString("GetEditorAction.AskBeforeOpenCancel"), Localization.getString("GetEditorAction.AskBeforeOpenAnother"), Localization.getString("GetEditorAction.AskBeforeOpenYes")}, 2);
                switch (messageDialog.open()) {
                    case 2: {
                        return (STPEditor)((Object)allEditors.get(0));
                    }
                    case 1: {
                        return IDESessionSettings.openNewFile(window);
                    }
                }
                return null;
            }
            case 0: {
                return IDESessionSettings.openNewFile(window);
            }
        }
        return IDESessionSettings.openNewFileFromMultiple(window, allEditors);
    }

    private static STPEditor openNewFileFromMultiple(IWorkbenchWindow window, final List<STPEditor> allEditors) {
        ListDialog listDialog = new ListDialog(window.getShell());
        listDialog.setTitle(Localization.getString("GetEditorAction.DialogTitle"));
        listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                int i = (Integer)element;
                return i != -1 ? ((STPEditor)((Object)allEditors.get(i))).getEditorInput().getName() : Localization.getString("GetEditorAction.OtherFile");
            }
        });
        Integer[] editorIndexes = new Integer[allEditors.size() + 1];
        int i = 0;
        while (i < editorIndexes.length - 1) {
            editorIndexes[i] = i;
            ++i;
        }
        editorIndexes[editorIndexes.length - 1] = -1;
        listDialog.setInput((Object)editorIndexes);
        listDialog.setMessage(Localization.getString("GetEditorAction.SelectEditor"));
        if (listDialog.open() == 0) {
            int result = (Integer)listDialog.getResult()[0];
            return result != -1 ? allEditors.get(result) : IDESessionSettings.openNewFile(window);
        }
        return null;
    }

    private static STPEditor openNewFile(IWorkbenchWindow window) {
        NewFileHandler action = new NewFileHandler();
        action.execute(null);
        if (action.isSuccessful()) {
            return (STPEditor)window.getActivePage().getActiveEditor();
        }
        return null;
    }
}

