/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.channels.FileChannel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.rpm.core.utils.BufferedProcessInputStream;
import org.eclipse.linuxtools.rpm.core.utils.Messages;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.FrameworkUtil;

public class Utils {
    public static BufferedProcessInputStream runCommandToInputStream(String ... command) throws IOException {
        return Utils.runCommandToInputStream(null, command);
    }

    private static BufferedProcessInputStream runCommandToInputStream(IProject project, String ... command) throws IOException {
        Process p = RuntimeProcessFactory.getFactory().exec(command, project);
        return new BufferedProcessInputStream(p);
    }

    public static IStatus runCommand(OutputStream outStream, IProject project, String ... command) throws IOException {
        return Utils.watchProcess(outStream, RuntimeProcessFactory.getFactory().exec(command, project));
    }

    public static IStatus watchProcess(final OutputStream outStream, Process child) {
        final BufferedInputStream in = new BufferedInputStream(new SequenceInputStream(child.getInputStream(), child.getErrorStream()));
        Thread readinJob = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int i;
                    while ((i = in.read()) != -1) {
                        outStream.write(i);
                    }
                    outStream.flush();
                    outStream.close();
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        readinJob.start();
        boolean canceled = false;
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            child.waitFor();
        }
        catch (InterruptedException e) {
            child.destroy();
            canceled = true;
        }
        while (readinJob.isAlive()) {
            try {
                readinJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (canceled) {
            return Status.CANCEL_STATUS;
        }
        if (child.exitValue() != 0) {
            return new Status(4, FrameworkUtil.getBundle(Utils.class).getSymbolicName(), NLS.bind((String)Messages.Utils_NON_ZERO_RETURN_CODE, (Object)child.exitValue()), null);
        }
        return Status.OK_STATUS;
    }

    public static String runCommandToString(String ... command) throws IOException {
        return Utils.runCommandToString(null, command);
    }

    public static String runCommandToString(IProject project, String ... command) throws IOException {
        BufferedProcessInputStream in = Utils.runCommandToInputStream(project, command);
        return Utils.inputStreamToString(in);
    }

    private static String inputStreamToString(InputStream stream) throws IOException {
        int c;
        StringBuilder retStr = new StringBuilder();
        while ((c = stream.read()) != -1) {
            retStr.append((char)c);
        }
        stream.close();
        return retStr.toString();
    }

    public static boolean fileExist(String cmdPath) {
        return new File(cmdPath).exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File in, File out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fin = new FileInputStream(in);
            try {
                block24: {
                    FileChannel inChannel = fin.getChannel();
                    try {
                        block23: {
                            FileOutputStream fos = new FileOutputStream(out);
                            try {
                                try (FileChannel outChannel = fos.getChannel();){
                                    inChannel.transferTo(0L, inChannel.size(), outChannel);
                                }
                                if (fos == null) break block23;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (fos == null) throw throwable;
                                fos.close();
                                throw throwable;
                            }
                            fos.close();
                        }
                        if (inChannel == null) break block24;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (inChannel == null) throw throwable;
                        inChannel.close();
                        throw throwable;
                    }
                    inChannel.close();
                }
                if (fin == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (fin == null) throw throwable;
                fin.close();
                throw throwable;
            }
            fin.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }
}

