#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif

typedef struct pkg_option_t {
    gchar *loption; 
    gchar *parameter;
    gchar *hlp;
    gchar *active;
    //gchar *option; 
    // group...?
}pkg_option_t;

typedef struct pkg_command_t {
    gint flags;     // command flags
    gchar *pkg;     // pkg command 
    gchar *cmd;     // pkg action
    pkg_option_t *pkg_options;
    pkg_option_t *cmd_options;
    gchar *parameter;
    gchar *hlp;     // tooltip help
    gchar *argument;
    gchar *string;
    gchar *icon;

} pkg_command_t;

#define NO_SELECTION            0x01
#define SINGLE_SELECTION        0x02
#define REMOTE_SELECTION        0x04
#define LOCAL_SELECTION		0x08
#define ACCESS_WRITE            0x10
#define ACCESS_READ             0x20
#define INACTIVE                0x40
#define LOCAL_REPO              0x80
#define REMOTE_REPO             0x100
#define OPTIONS                 0x200
#define IN_TERM                 0x400
#define LOCK_DATABASE           0x800
#define NO_VERSION		0x1000
#define SCROLL_UP		0x2000

/*
 * obsolete
#define PKG_ONLY		0x1000
#define ZYPPER_ONLY		0x2000
#define YUM_ONLY		0x4000
#define APT_ONLY		0x8000
*/

#if 0
#ifndef PKG_MENU_STUFF
#define PKG_MENU_STUFF \
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_add",\
	    {0x2001, N_("add"),"xffm/stock_add",\
	    (gpointer) pkg_option, "add",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_annotate",\
	    {0x2001, N_("annotate"),NULL,\
	    (gpointer) pkg_option, "annotate",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_audit",\
	    {0x2001, N_("audit"),NULL,\
	    (gpointer) pkg_option, "audit",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_autoremove",\
	    {0x2001, N_("autoremove"),NULL,\
	    (gpointer) pkg_option, "autoremove",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_backup",\
	    {0x2001, N_("backup"),"xffm/emblem_important",\
	    (gpointer) pkg_option, "backup",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_check",\
	    {0x2001, N_("check"),NULL,\
	    (gpointer) pkg_option, "check",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_clean",\
	    {0x2001, N_("clean"),"xffm/stock_clear",\
	    (gpointer) pkg_option, "clean",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_convert",\
	    {0x2001, N_("convert"),NULL,\
	    (gpointer) pkg_option, "convert",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_create",\
	    {0x2001, N_("create"),NULL,\
	    (gpointer) pkg_option, "create",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_delete",\
	    {0x2001, N_("delete"),"xffm/stock_remove",\
	    (gpointer) pkg_option, "delete",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_fetch",\
	    {0x2001, N_("fetch"),"xffm/emblem_blueball",\
	    (gpointer) pkg_option, "fetch",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_info",\
	    {0x2001, N_("info"),"xffm/stock_about",\
	    (gpointer) pkg_option, "info",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_install",\
	    {0x2001, N_("install"),"xffm/emblem_greenball",\
	    (gpointer) pkg_option, "install",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_lock",\
	    {0x2001, N_("lock"),"xffm/emblem_lock",\
	    (gpointer) pkg_option, "lock",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_plugins",\
	    {0x2001, N_("plugins"),NULL,\
	    (gpointer) pkg_option, "plugins",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_query",\
	    {0x2001, N_("query"),"xffm/emblem_about",\
	    (gpointer) pkg_option, "query",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_register",\
	    {0x2001, N_("register"),NULL,\
	    (gpointer) pkg_option, "register",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_repo",\
	    {0x2001, N_("repo"),NULL,\
	    (gpointer) pkg_option, "repo",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_rquery",\
	    {0x2001, N_("rquery"),NULL,\
	    (gpointer) pkg_option, "rquery",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_search",\
	    {0x2001, N_("search"),"xffm/emblem_find",\
	    (gpointer) pkg_option, "search",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_set",\
	    {0x2001, N_("set"),NULL,\
	    (gpointer) pkg_option, "set",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_shell",\
	    {0x2001, N_("shell"),NULL,\
	    (gpointer) pkg_option, "shell",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_shlib",\
	    {0x2001, N_("shlib"),NULL,\
	    (gpointer) pkg_option, "shlib",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_stats",\
	    {0x2001, N_("stats"),NULL,\
	    (gpointer) pkg_option, "stats",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_unlock",\
	    {0x2001, N_("unlock"),"xffm/emblem_keyhole",\
	    (gpointer) pkg_option, "unlock",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_update",\
	    {0x2001, N_("update"),"xffm/stock_refresh",\
	    (gpointer) pkg_option, "update",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_updating",\
	    {0x2001, N_("updating"),"xffm/emblem_synchronized",\
	    (gpointer) pkg_option, "updating",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_upgrade",\
	    {0x2001, N_("upgrade"),NULL,\
	    (gpointer) pkg_option, "upgrade",0,0}},\
	{NULL_TYPE} 
#endif


#ifndef PKG_PKG_I
#define PKG_PKG_I

static pkg_command_t commands[] = {
    {.flags=INACTIVE|ACCESS_WRITE|REMOTE_SELECTION|LOCK_DATABASE, 
        .cmd="add", .hlp=N_(""), .options="IAfq", .argument="pkg-name/url"},
    {.flags=INACTIVE|NO_SELECTION|LOCK_DATABASE, 
        .cmd="annotate", .hlp=N_(""), .options="", .eoptions="", .argument="" },
    {.flags=INACTIVE|ACCESS_READ, 
        .cmd="audit", .hlp=N_(""), .options="Fqc", .argument="pkg-name" },
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCK_DATABASE, 
        .cmd="autoremove", .hlp=N_(""), .options="nqy" },
    {.flags=NO_SELECTION|ACCESS_WRITE, 
        .cmd="backup", .hlp=N_(""), .eoptions="dr" },
    {.flags=ACCESS_WRITE|NO_SELECTION, 
        .cmd="check", .hlp=N_("") , .options="aBdsrvyn", .aoptions="Cgix"},
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCK_DATABASE, 
        .cmd="clean", .hlp=N_(""), .options="anqy"},
    {.flags=NO_SELECTION, 
        .cmd="convert", .hlp=N_("") , .options="nr", .eoptions="d", .argument=""},
    {.flags=NO_SELECTION|ACCESS_WRITE, 
        .cmd="create", .hlp=N_(""), .options="agxn ", .eoptions="fmMopr", .argument="" },
    {.flags=ACCESS_WRITE|LOCAL_SELECTION|NO_SELECTION|LOCK_DATABASE, 
        .cmd="delete", .hlp=N_(""), .options="aDfnqRy", .aoptions="Cgix", .argument="pkg-name" },
    {.flags=ACCESS_WRITE|REMOTE_SELECTION|NO_SELECTION, 
        .cmd="fetch", .hlp=N_(""), .options="dqUyuCgix", .eoptions="r", .argument="pkg-name" },
    {.flags=NO_SELECTION|LOCAL_SELECTION, 
        .cmd="info", .hlp=N_(""), .options="AbBDdefgiIklOqRrs", .aoptions="Cgix", .argument="pkg-name" },
    {.flags=ACCESS_WRITE|REMOTE_SELECTION|NO_SELECTION|LOCK_DATABASE, 
        .cmd="install", .hlp=N_(""), .options="AfIMnFqRUy", .aoptions="Cgix", .eoptions="r",.argument="pkg-name" },
    {.flags=ACCESS_WRITE|LOCK_DATABASE|LOCAL_SELECTION|NO_SELECTION, 
        .cmd="lock", .hlp=N_(""), .options="aqy", .aoptions="Cgix", .argument="pkg-name" },
    {.flags=INACTIVE|NO_SELECTION, 
        .cmd="plugins", .hlp=N_(""), .options="", .eoptions="", .argument="" },
 // with set arguments is tooltip:
    {.flags=NO_SELECTION|LOCAL_SELECTION, 
        .cmd="query", .hlp=N_(""), .options="aUI", .aoptions="Cgix", .eoptions="er", .argument="<query-format> <pkg-name>" },
    {.flags=NO_SELECTION|LOCK_DATABASE|ACCESS_WRITE, 
        .cmd="register", .hlp=N_(""), .options="AdlOt", .eoptions="fmMi", .argument="" },
    {.flags=INACTIVE|NO_SELECTION, 
        .cmd="repo", .hlp=N_(""), .options="", .eoptions="", .argument="<query-format> <pkg-name>" },
 // with set arguments is tooltip:
    {.flags=NO_SELECTION|LOCAL_SELECTION, 
        .cmd="rquery", .hlp=N_(""), .options="a", .aoptions="Cgix", .eoptions="eF", .argument="" },
    {.flags=ACCESS_READ|REMOTE_SELECTION|NO_SELECTION, 
        .cmd="search", .options="cDdefgiopqR", .eoptions="rSLQ", .argument="pattern/pkg_name", .hlp=N_("") },
    {.flags=NO_SELECTION|LOCAL_SELECTION|ACCESS_WRITE, 
        .cmd="set", .hlp=N_("") , .options="ay", .aoptions="Cgix", .eoptions="Ao", .argument="pkg_name"},
    {.flags=NO_SELECTION|IN_TERM|LOCK_DATABASE, 
        .cmd="shell", .hlp=N_("") , .options="", .eoptions="", .argument=""},
    {.flags=INACTIVE|ACCESS_READ, .cmd="shlib", .hlp=N_(""), .options="PR", .argument="library" },
    {.flags=ACCESS_READ|NO_SELECTION, 
        .cmd="stats", .hlp=N_(""), .options="qlrb"},
    {.flags=ACCESS_WRITE|LOCK_DATABASE|LOCAL_SELECTION|NO_SELECTION, 
        .cmd="unlock", .hlp=N_(""), .options="alqy", .aoptions="Cgix", .argument="pkg-name" },
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCAL_SELECTION, 
        .cmd="update", .hlp=N_(""), .options="fq" },
    {.flags=ACCESS_READ|NO_SELECTION|LOCAL_SELECTION, 
        .cmd="updating", .hlp=N_(""), .options="df", .argument="pkg-name" },
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCK_DATABASE, 
        .cmd="upgrade", .hlp=N_("") , .options="CFfgIinqUy", .eoptions="r"},
    {.cmd=NULL} // no comma after last item
};


#endif
#endif


#if 0


static gchar *
get_aoptions(GtkDialog *dialog, gchar *options, gchar *in_string){
    if (!options || !(*options)) return in_string;
    gchar *p;
    gchar *response_string = g_strdup(in_string);
    g_free(in_string);
    gchar *a = g_strdup("-");
    for (p=options; p && *p; p++){
        gchar *label = g_strdup_printf ("-%c", *p);
        GtkWidget *check =g_object_get_data(G_OBJECT(dialog), label);
        g_free(label);
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check))){
            gchar *g = g_strdup_printf("%s%c", a, *p);
            g_free(a);
            a = g;
        } 
    }
    if (strlen(a) > 1) {
        GtkWidget *entry =g_object_get_data(G_OBJECT(dialog), "alabel-entry");
        const gchar *etext = gtk_entry_get_text(GTK_ENTRY(entry));
        if (etext && *etext){
            gchar *g = g_strconcat(response_string, " ", a, " ", etext, NULL);
            g_free(response_string);
            response_string = g;
        }
    }
    g_free(a);
    return response_string;
}

static gchar *
get_loptions(GtkDialog *dialog, gchar **loptions, gchar *in_string, gint type){
    if (!loptions || !(*loptions)) return in_string;
    gchar **pp;
    gchar *response_string = g_strdup(in_string);
    g_free(in_string);
    for (pp=loptions; pp && *pp; pp++){
        gchar *label = g_strdup_printf ("--%s", *pp);
        GtkWidget *check =g_object_get_data(G_OBJECT(dialog), label);
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check))){
            gchar *g = g_strconcat(response_string, " ", label, NULL);
            g_free(response_string);
            response_string = g;
            if (type & ARGUMENT_OPTION){
                gchar *elabel = g_strconcat(label, "-entry", NULL);
                GtkWidget *entry =g_object_get_data(G_OBJECT(dialog), elabel);
                if (entry) {
                    const gchar *etext = gtk_entry_get_text(GTK_ENTRY(entry));
                    if (etext && *etext && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check))){
                        gchar *g = g_strconcat(response_string, "=", etext, NULL);
                        g_free(response_string);
                        response_string = g;
                    }
                }
                g_free(elabel);
                elabel = g_strconcat(label, "-checkY", NULL);
                GtkWidget *checkY =g_object_get_data(G_OBJECT(dialog), elabel);
                if (checkY){
                    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkY))){
                        gchar *g = g_strconcat(response_string, "=y", NULL);
                        g_free(response_string);
                        response_string = g;
                    } else {
                        gchar *g = g_strconcat(response_string, "=n", NULL);
                        g_free(response_string);
                        response_string = g;
                    }

                }
                g_free(elabel);
            }
        }
        g_free(label);
    }
    return response_string;
}

static void 
content_add_o(const view_t *view_p, GtkBox *content_box, gchar *options, gint type, gchar *aa){
    if (!options || !(*options)) return;
    gchar *p;
    gint i=0;
    GtkWidget *obox;
    GtkWidget *dialog = g_object_get_data(G_OBJECT(content_box), "dialog");
    GtkWidget *tit = gtk_label_new("");
    gchar *markup =  g_strdup_printf("<span color=\"red\">%s</span>", _("XXXXX"));
    gtk_label_set_markup(GTK_LABEL(tit), markup);
    g_free(markup);
    gtk_box_pack_start(GTK_BOX(content_box), tit, FALSE, FALSE, 1);
    gtk_widget_show(tit);

    if (type & ARGUMENT_EXCLUSIVE_OPTION) {
        obox = rfm_hbox_new(FALSE, 1);
        gtk_widget_show(obox);
        gtk_box_pack_start(content_box, obox, FALSE, FALSE, 1);
    }
    for (p=options; p && *p; p++){
        if ((type & ARGUMENT_OPTION) || ((type & PLAIN_OPTION) && (i++ % 5 == 0))){
            obox = rfm_hbox_new(FALSE, 1);
            gtk_widget_show(obox);
            gtk_box_pack_start(content_box, obox, FALSE, FALSE, 1);
        }

        gchar *label = g_strdup_printf ("-%c", *p);
        GtkWidget *check = gtk_check_button_new_with_label(label);
        g_object_set_data(G_OBJECT(dialog), label, check);
        g_object_set_data(G_OBJECT(check), "op", options);
        g_object_set_data(G_OBJECT(check), "type", GINT_TO_POINTER(type));
        gtk_widget_show(check);
        gtk_box_pack_start(GTK_BOX(obox), check, FALSE, FALSE, 1);
        g_signal_connect(G_OBJECT (check), "clicked", G_CALLBACK (update_o), tit);

        if (type & ARGUMENT_OPTION){
            GtkWidget *entry =gtk_entry_new();
            gchar *elabel = g_strconcat(label, "-entry", NULL);
            g_object_set_data(G_OBJECT(dialog), elabel, entry);
            gtk_widget_show(entry);
            g_free(elabel);
            gtk_box_pack_start(GTK_BOX(obox), GTK_WIDGET(entry), FALSE, FALSE, 1);
        }
        g_free(label);
    }
    if (type & ARGUMENT_EXCLUSIVE_OPTION) {
        GtkWidget *entry =gtk_entry_new();
        if (aa && *aa) gtk_entry_set_text(GTK_ENTRY(entry), aa);
        g_object_set_data(G_OBJECT(dialog), "alabel-entry", entry);
        gtk_widget_show(entry);
        gtk_box_pack_start(GTK_BOX(obox), GTK_WIDGET(entry), FALSE, FALSE, 1);
    }

}


static void 
content_add_lo(const view_t *view_p, GtkBox *content_box, gchar **global_lop, int with_argument, const gchar *tag){
    if (!global_lop || !(*global_lop)) return;
    GtkWidget *dialog = g_object_get_data(G_OBJECT(content_box), "dialog");

    GtkWidget *obox = rfm_hbox_new(FALSE, 1);
    GtkWidget *button = gtk_toggle_button_new_with_label(tag);
    g_object_set_data(G_OBJECT(button), "dialog", dialog);
    gtk_box_pack_start(GTK_BOX(content_box), obox, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(obox), button, FALSE, FALSE, 1);
        
    GtkWidget *tit = gtk_label_new("");
    if (with_argument==1){
        gchar *markup =  g_strdup_printf("<i>%s</i>", _("Labeled argument"));
        gtk_label_set_markup(GTK_LABEL(tit), markup);
        g_free(markup);
    }
    gtk_box_pack_start(GTK_BOX(obox), tit, FALSE, FALSE, 1);
    gtk_widget_show(tit);
    
    gtk_widget_show(obox);
    gtk_widget_show(button);

    GtkWidget *scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(content_box), scrolled_window, FALSE, FALSE, 1);
    
    obox = rfm_hbox_new(FALSE, 1);
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>8
    gtk_container_add(GTK_CONTAINER(scrolled_window), obox);
#else
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrolled_window),
                                       obox);
#endif
    gtk_widget_show(obox);
    //gtk_box_pack_start(GTK_BOX(content_box), obox, FALSE, FALSE, 1);

    GtkBox *vbox = GTK_BOX(rfm_vbox_new(FALSE, 1));
    gtk_box_pack_start(GTK_BOX(obox), GTK_WIDGET(vbox), FALSE, FALSE, 1);
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(hideshow), scrolled_window); 
//    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(hideshow), obox); 
    gtk_widget_realize(obox);


    obox = rfm_hbox_new(FALSE, 1);
    gtk_box_pack_start(GTK_BOX(vbox), obox, FALSE, FALSE, 1);

    gchar **pp;
    gint i=0;

    gint width = -1;
    GSList *group = NULL;
    GtkWidget *check;
    for (pp=global_lop; pp && *pp; pp++){
        //if (i++ % 2 == 0)
        {
            obox = rfm_hbox_new(FALSE, 1);
            gtk_box_pack_start(vbox, obox, FALSE, FALSE, 1);
        }

        gchar *label = g_strdup_printf ("--%s", *pp);
        if (with_argument==3){
            check = gtk_radio_button_new_with_label(group, label);
            if (group==NULL){
                gchar *markup = g_strdup_printf("<span color=\"red\">%s</span>", label);
                gtk_label_set_markup(GTK_LABEL(tit), markup);
                g_free(markup);
            }
            group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(check));
            g_signal_connect(G_OBJECT (check), "clicked", G_CALLBACK (update_action), tit);
        } else {
            check = gtk_check_button_new_with_label(label);
        }
        g_object_set_data(G_OBJECT(check), "dialog", dialog);
        g_object_set_data(G_OBJECT(dialog), label, check);
        gtk_box_pack_start(GTK_BOX(obox), check, FALSE, FALSE, 1);
        GtkRequisition minimum;
	if (with_argument==1){
	    GtkWidget *entry = gtk_entry_new();
            g_object_set_data(G_OBJECT(entry), "dialog", dialog);
            g_object_set_data(G_OBJECT(entry), "type", GINT_TO_POINTER(ARGUMENT_OPTION));
            g_object_set_data(G_OBJECT(entry), "lop", global_lop);
            g_signal_connect(G_OBJECT (entry), "key-release-event", G_CALLBACK (entry_update), tit);
            g_signal_connect(G_OBJECT (entry), "button-press-event", G_CALLBACK (entry_update), tit);
            
	    g_object_set_data(G_OBJECT(check), "entry", entry);
	    gchar *elabel = g_strconcat(label, "-entry", NULL);
	    g_object_set_data(G_OBJECT(dialog), elabel, entry);
	    g_free(elabel);
            GtkWidget *lab = gtk_label_new("=");
	    gtk_box_pack_start(GTK_BOX(obox), GTK_WIDGET(lab), FALSE, FALSE, 1);
	    gtk_box_pack_end(GTK_BOX(obox), GTK_WIDGET(entry), TRUE, TRUE, 1);
            gtk_widget_show_all(obox);
            gtk_widget_get_preferred_size(GTK_WIDGET(obox), &minimum, NULL);
            if (minimum.width > width) width = minimum.width;
            gtk_widget_set_sensitive(entry, FALSE);
            g_object_set_data(G_OBJECT(check), "type", GINT_TO_POINTER(ARGUMENT_OPTION));
	} else if (with_argument==2) {
            GtkWidget *lab = gtk_label_new("=");
	    GtkWidget *checkY = gtk_radio_button_new_with_label(NULL, "Y");
            GSList *group = gtk_radio_button_get_group (GTK_RADIO_BUTTON(checkY));
	    gchar *elabel = g_strconcat(label, "-checkY", NULL);
	    g_object_set_data(G_OBJECT(dialog), elabel, checkY);
	    g_object_set_data(G_OBJECT(check), "checkY", checkY);
            g_object_set_data(G_OBJECT(checkY), "dialog", dialog);
            g_object_set_data(G_OBJECT(checkY), "type", GINT_TO_POINTER(ARGUMENT_OPTION));
            g_object_set_data(G_OBJECT(checkY), "lop", global_lop);
            g_signal_connect(G_OBJECT (checkY), "clicked", G_CALLBACK (update_lo), tit);
	    g_free(elabel);
	    GtkWidget *checkN = gtk_radio_button_new_with_label(group, "N");
	    elabel = g_strconcat(label, "-checkN", NULL);
	    g_object_set_data(G_OBJECT(dialog), elabel, checkN);
	    g_object_set_data(G_OBJECT(check), "checkN", checkN);
            g_object_set_data(G_OBJECT(checkN), "dialog", dialog);
            g_object_set_data(G_OBJECT(checkN), "type", GINT_TO_POINTER(ARGUMENT_OPTION));
            g_object_set_data(G_OBJECT(checkN), "lop", global_lop);
            g_signal_connect(G_OBJECT (checkN), "clicked", G_CALLBACK (update_lo), tit);
	    g_free(elabel);
	    gtk_box_pack_end(GTK_BOX(obox), GTK_WIDGET(checkN), FALSE, FALSE, 1);
	    gtk_box_pack_end(GTK_BOX(obox), GTK_WIDGET(checkY), FALSE, FALSE, 1);
	    gtk_box_pack_end(GTK_BOX(obox), GTK_WIDGET(lab), FALSE, FALSE, 1);
            gtk_widget_show_all(obox);
            gtk_widget_get_preferred_size(GTK_WIDGET(obox), &minimum, NULL);
            if (minimum.width > width) width = minimum.width;
            gtk_widget_set_sensitive(checkY, FALSE);
            gtk_widget_set_sensitive(checkN, FALSE);
            g_object_set_data(G_OBJECT(check), "type", GINT_TO_POINTER(ARGUMENT_OPTION));
            
        } else if (with_argument==0){
            g_object_set_data(G_OBJECT(check), "type", GINT_TO_POINTER(PLAIN_OPTION));
        }
        if (with_argument != 3){
            g_object_set_data(G_OBJECT(check), "lop", global_lop);
            g_signal_connect(G_OBJECT (check), "clicked", G_CALLBACK (update_lo), tit);
            g_signal_connect (G_OBJECT (check), "clicked", G_CALLBACK (sensitivize_checks), NULL);
        }
	g_free(label);
    }
    if (width > 0) width +=30; // hack
    gtk_widget_set_size_request(scrolled_window, width, 100);
    gtk_widget_realize(GTK_WIDGET(vbox));
}


static void
update_lo(GtkButton *button, gpointer data){
    GtkDialog *dialog = g_object_get_data(G_OBJECT(button), "dialog");
    gchar **lop = g_object_get_data(G_OBJECT(button), "lop");
    gint type = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(button), "type"));
    gchar *text=g_strdup("");
    text = get_loptions(dialog, lop, text, type);

    GtkLabel *tit = data;
    gchar *markup = g_strdup_printf("<span color=\"red\">%s</span>", text);
    gtk_label_set_markup(tit, markup);
    g_free(markup);
}

static gboolean
entry_update (GtkWidget *widget,
               GdkEvent  *event,
               gpointer   data){

    update_lo((GtkButton *)widget, data);
    return FALSE;
}


static void
update_lo(GtkButton *button, gpointer data){
    GtkDialog *dialog = g_object_get_data(G_OBJECT(button), "dialog");
    gchar **lop = g_object_get_data(G_OBJECT(button), "lop");
    gint type = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(button), "type"));
    gchar *text=g_strdup("");
    text = get_loptions(dialog, lop, text, type);

    GtkLabel *tit = data;
    gchar *markup = g_strdup_printf("<span color=\"red\">%s</span>", text);
    gtk_label_set_markup(tit, markup);
    g_free(markup);
}
static 
void
pkg_option(GtkMenuItem *m, gpointer data){
    gchar *command = data;
    if (!command) return;
    if (!pkg && !zypper && !yum) return;
    gchar *cmd = NULL;
    widgets_t *widgets_p = rfm_get_widget ("widgets_p");
    pkg_command_t *c=NULL;
    if (pkg) c = commands;
    else if (zypper) c = zyppers;
    else if (yum) c= yums;
    gint flags = 0;
    for(; c && c->cmd; c++){
        if (strcmp(command, c->cmd)==0) {
            gchar **response = rfm_context_function(pkg_confirm_f, c);
            gchar *pcr=g_object_get_data(G_OBJECT(widgets_p->paper), "pkg_confirm_response");
            g_free(pcr);
            g_object_set_data(G_OBJECT(widgets_p->paper), "pkg_confirm_response", NULL);
            g_object_set_data(G_OBJECT(widgets_p->paper), "flags", NULL);
            pcr=NULL;
            if (response && response[0]){
                if (strcmp(c->cmd, "search")==0){
                    view_t *view_p = widgets_p->view_p;
                    record_entry_t *en = rfm_copy_entry(view_p->en);
                    g_free (en->path);
                    //en->path = g_strdup_printf("search %s", response[0]);
                    g_strstrip(response[0]);
                    g_strstrip(response[1]);
                    en->path = g_strdup_printf("%s search %s", response[1], response[0]);
                    rodent_refresh (widgets_p, en);
                    // This would open a new window, which annoys me:
                    //  cmd = g_strdup_printf("rodent-plug pkg %s", response);
                } else {
		    const gchar *sudo;
		    if (geteuid() == 0 || (c->flags & ACCESS_READ)) sudo="";
		    else sudo = "sudo -A ";

                    if (pkg) {
                        cmd = g_strdup_printf("%s%s %s %s %s", sudo, pkg, response[1], c->cmd, response[0]);
		        pcr = g_strdup_printf("%s%s %s -y %s", sudo, pkg, c->cmd, response[0]);
                    } else if (zypper){
                        cmd = g_strdup_printf("%s%s %s %s %s", sudo, zypper, response[1], c->cmd, response[0]);
		        pcr = g_strdup_printf("%s%s --non-interactive %s %s %s", sudo, zypper, response[1], c->cmd, response[0]);
                    } else if (yum) {
                        cmd = g_strdup_printf("%s%s %s %s %s", sudo, yum, response[1], c->cmd, response[0]);
		        pcr = g_strdup_printf("%s%s --assumeyes %s %s %s", sudo, yum, response[1], c->cmd, response[0]);
                    }

                    g_object_set_data(G_OBJECT(widgets_p->paper), "pkg_confirm_response", pcr);
                    g_object_set_data(G_OBJECT(widgets_p->paper), "flags", GINT_TO_POINTER(c->flags));
                }
                flags = c->flags;
                DBG("do it --> %s\n", cmd);
                g_strfreev(response);
                break;
            }
        }
    }
    if (!cmd) return;
 
    do_it(widgets_p, cmd, flags);
    g_free(cmd);
    return;
}

static gchar *
get_options(GtkDialog *dialog, gchar *options, gchar *in_string){
    if (!options || !(*options)) return in_string;
    gchar *p;
    gchar *response_string = g_strdup(in_string);
    g_free(in_string);
    for (p=options; p && *p; p++){
        gchar *label = g_strdup_printf ("-%c", *p);
        GtkWidget *check =g_object_get_data(G_OBJECT(dialog), label);
        gint type = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(check), "type"));
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check))){
            gchar *g = g_strconcat(response_string, " ", label, NULL);
            g_free(response_string);
            response_string = g;
            if (type & ARGUMENT_OPTION){
                gchar *elabel = g_strconcat(label, "-entry", NULL);
                GtkWidget *entry =g_object_get_data(G_OBJECT(dialog), elabel);
                const gchar *etext = gtk_entry_get_text(GTK_ENTRY(entry));
                if (etext && *etext && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check))){
                    gchar *g = g_strconcat(response_string, " ", etext, NULL);
                    g_free(response_string);
                    response_string = g;
                }
                g_free(elabel);
            }
        }
        g_free(label);

    }
    return response_string;
}
 
static void
update_o(GtkButton *button, gpointer data){
    GtkDialog *dialog = g_object_get_data(G_OBJECT(button), "dialog");
    gchar *op = g_object_get_data(G_OBJECT(button), "op");
    gchar *text=g_strdup("");
    text = get_options(dialog, op, text);

    GtkLabel *tit = data;
    gchar *markup = g_strdup_printf("<span color=\"red\">%s</span>", text);
    gtk_label_set_markup(tit, markup);
    g_free(markup);
}

#endif
