#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Edscott Wilson Garcia Copyright 2011
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stdout_nmb_resolve (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    view_t *view_p = widgets_p->view_p;
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);

    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    static gchar *ip = NULL;
    if(line[0] == '\n')
        return;

    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
        gchar *string = rfm_diagnostics_exit_string(line);
        rfm_threaded_diagnostics(widgets_p, "xffm/stock_stop", string);
	    g_mutex_lock(smb_data_p->mutex);
	    smb_data_p->condition = TRUE;
	    g_mutex_unlock(smb_data_p->mutex);
	    g_cond_signal(smb_data_p->signal);
	NOOP( "THREAD 0x%x ending resolve thread condition=0x%x\n",
		GPOINTER_TO_INT(g_thread_self()), smb_data_p->condition );
    } else {
#ifdef DEBUG
          rfm_threaded_diagnostics (widgets_p, NULL, g_strconcat(line, NULL));
#endif
	  if (strstr (line, "Looking up status of ")){ 
	      g_free(ip);
	      ip = g_strdup(line + strlen("Looking up status of "));
	      if (strchr(ip,'\n')) *strchr(ip,'\n') = 0;
	      g_strstrip(ip);
	  }
	  else if (strstr (line, "<00>") && strstr (line, "<GROUP>") && strchr(line, ' ')){ 
	      // workgroup name 
	      *strchr(line, ' ') = 0;
	      g_strchug(line);
	  	     //strtok (line, " ");
		rfm_threaded_diagnostics(widgets_p, "xffm_tag/red", g_strconcat(_("Workgroup/domain:"), " ", NULL));
		rfm_threaded_diagnostics(widgets_p, "xffm_tag/green", g_strconcat(line, "\n", NULL));
		g_mutex_lock(workgroup_mutex);
		if (!workgroup_hash){
		    workgroup_hash = 
			g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
		}
		g_hash_table_replace(workgroup_hash, g_strdup(ip), g_strdup(line));
		g_mutex_unlock(workgroup_mutex);
	  } else if (strstr (line, "<20>") && strchr(line, ' ')) {
	      // server name 
	      *strchr(line, ' ') = 0;
	      g_strchug(line);
	      rfm_threaded_diagnostics(widgets_p, "xffm_tag/red", g_strconcat(_("Server name:"), " ", NULL));
	      rfm_threaded_diagnostics(widgets_p, "xffm_tag/green", g_strconcat(line, "\n", NULL));
	      g_mutex_lock(master_mutex);
	      if (!master_hash){
		    master_hash = 
			g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
	      }
	      g_hash_table_replace(master_hash, g_strdup(ip), g_strdup(line));
	      g_mutex_unlock(master_mutex);
	  }
    }
    return;
}


static gboolean 
NMBmastersResolve (smb_data_t *smb_data_p){

  widgets_t *widgets_p = &(smb_data_p->view_p->widgets);
  gchar **arg;
	      
  g_mutex_lock(master_mutex);
  if (!mastersIP || g_slist_length(mastersIP) == 0) {
    g_mutex_unlock(master_mutex);
    return FALSE;
  }
  gint count = g_slist_length(mastersIP)+2+1;
  arg=(gchar **)malloc(count*sizeof(gchar *));
  if (!arg) g_error("malloc: %s", strerror(errno));
  memset(arg,0,count*sizeof(gchar *));
  
  gchar **arg_p = arg;
  *arg_p=  "nmblookup";
  arg_p++;
  *arg_p=  "-A";
  arg_p++;
  GSList *tmp=mastersIP;
  for (; tmp && tmp->data; tmp=tmp->next){
    *arg_p = tmp->data;
    arg_p++;
  }
  g_mutex_unlock(master_mutex);

  rfm_threaded_show_text(widgets_p);
#ifdef DEBUG
  rfm_threaded_diagnostics(widgets_p, NULL, g_strconcat("Solving master browsers IP to NetBIOS names\n", NULL)); 
#endif

  rfm_threaded_diagnostics (widgets_p, "xffm/emblem_network/compositeSE/stock_go-forward", NULL);
  rfm_threaded_diagnostics (widgets_p, "xffm_tag/command", g_strconcat(" nmblookup -A", NULL));
  tmp=mastersIP;
  for (tmp=mastersIP; tmp && tmp->data; tmp=tmp->next){
    rfm_threaded_diagnostics (widgets_p, NULL, g_strconcat(" ", (gchar *)tmp->data, NULL));
  }
  rfm_threaded_diagnostics (widgets_p, NULL, g_strconcat("\n", NULL));


  rfm_thread_run_argv_with_stdout (widgets_p, arg, FALSE, stdout_nmb_resolve);
  
  return FALSE;
}



