#define FUSE_BROADBAND  _("local filesystem")
#define FUSE_COMPUTER _("Computer Name:")
#define FUSE_REMOTE_PATH  _("Remote Path")
#define FUSE_MOUNT_POINT  _("Mount point:")
#define FUSE_URL  _("URL")
#define FUSE_MONITOR  _("Enable file monitoring")
#define FUSE_CAUTION  _("Caution")
#define FUSE_LOGIN  _("Username:")
#define FUSE_SECURE_SHELL_KEY  _("Secure Shell Key")
#define FUSE_ALLOW_EMPTY_PASSPHRASE  _("Allow empty private key passphrase")
#define FUSE_PASSPHRASE  _("Enter your Secure Shell passphrase:")

typedef struct key_options_t {
    GKeyFile *key_file;
    gchar *group;
} key_options_t; 


/////////////////////////////////////////////////////////////////////
//   r-fuse v.0.2 stuff
/////////////////////////////////////////////////////////////////////

typedef struct fuse_data_t {
    gint flag_id;
    gboolean default_state;
    union {
	GtkWidget *dialog;
	widgets_t *widgets_p;
    };
    union {
	const gchar *url;
	const gchar *label;
	const gchar *item_id;
    };
    union {
	group_options_t *options_p;
	const gchar *item_string;
	const gchar *info1;
    };
    union {
	gchar ***options_keys_p;
	const gchar *extra_text;
	const gchar *default_value;
	const gchar *info2;
	const gchar *computer;
    };
    
}fuse_data_t;

#ifdef FUSE_IS_PARENT_MODULE
#define FUSE_init_dialog(X) \
    (GtkWidget *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_init_dialog"))
#define FUSE_get_combo_text(X) \
    (gchar *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_get_combo_text"))
#define FUSE_add_combo(X) \
    (GtkWidget *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_add_combo"))
#define FUSE_add_entry(X) \
    (GtkWidget *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_add_entry"))
#define FUSE_add_check(X) \
    (GtkWidget *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_add_check"))
#define FUSE_add_option_page(X) \
    (rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_add_option_page"))
#define FUSE_reset_url_field(X) \
    (rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_reset_url_field"))
#define FUSE_get_login_info(X) \
    (rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_get_login_info"))
#define FUSE_set_options(X) \
    (rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_set_options"))
#define FUSE_save_keyfile(X) \
    (rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_save_keyfile"))
#define FUSE_data_new(X) \
    (fuse_data_t *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_data_new"))

#define FUSE_xfdir(X) \
    (xfdir_t *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_xfdir"))

#define FUSE_icon(X) \
    (const gchar *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_icon"))

#define FUSE_click(X) \
    (rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_click"))

#define FUSE_popup(X) \
    (rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_popup"))

#define FUSE_get_option_id(X) \
    (gchar *)(rfm_natural(PLUGIN_DIR, "fuse", X, "fuse_get_option_id"))

#define FUSE_check_program(X,Y) \
    (gboolean)(rfm_rational(PLUGIN_DIR, "fuse", X, Y, "fuse_check_program"))


#else
#define FUSE_init_dialog fuse_init_dialog
#define FUSE_get_combo_text fuse_get_combo_text
#define FUSE_add_combo fuse_add_combo
#define FUSE_add_entry fuse_add_entry
#define FUSE_add_check fuse_add_check
#define FUSE_add_option_page fuse_add_option_page
#define FUSE_reset_url_field fuse_reset_url_field
#define FUSE_get_login_info fuse_get_login_info
#define FUSE_set_options fuse_set_options
#define FUSE_save_keyfile fuse_save_keyfile
#define FUSE_data_new fuse_data_new
#define FUSE_check_program fuse_check_program

#define  FUSE_private_popup  fuse_private_popup
#define  FUSE_double_click fuse_double_click
#define  FUSE_icon_id fuse_icon_id
#define  FUSE_xfdir fuse_xfdir
#define  FUSE_icon fuse_icon
#define  FUSE_click fuse_click
#define  FUSE_popup fuse_popup 
#define  FUSE_get_option_id fuse_get_option_id 
    
#endif

void *
fuse_check_program(const gchar *program_to_check);

gchar *
fuse_get_option_id(gchar **argv);

GtkWidget *
fuse_init_dialog(fuse_data_t *fuse_data_p);

gchar *
fuse_get_combo_text(fuse_data_t *fuse_data_p);

GtkWidget *
fuse_add_combo(fuse_data_t *fuse_data_p);

GtkWidget *
fuse_add_entry(fuse_data_t *fuse_data_p);

GtkWidget *
fuse_add_check(fuse_data_t *fuse_data_p);

void *
fuse_add_option_page(fuse_data_t *fuse_data_p) ;
    
void *
fuse_reset_url_field(fuse_data_t *fuse_data_p);

void *
fuse_popup(void **argv);

void *
fuse_get_login_info (fuse_data_t *fuse_data_p);

void *
fuse_set_options(fuse_data_t *fuse_data_p);

gchar *
fuse_save_keyfile(fuse_data_t *fuse_data_p);

fuse_data_t *
fuse_data_new(fuse_data_t *fuse_data_p);

xfdir_t *
fuse_xfdir (void **argv);

const gchar *
fuse_icon (void **argv);

void *
fuse_click(fuse_data_t * (*dialog_f)(const gchar *url), const gchar *url, record_entry_t *en, const gchar *module_name);

gboolean 
fuse_mkdir(const gchar *mount_point);

void *
fuse_test_ini_file(void *p);

GCond *
fuse_hold_monitor(void);

