/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */



#define GRIDVIEW_C

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE 

view_t *create_iconview ( record_entry_t * en);
GtkWidget *create_gridview ( void);

/* private symbols */
static gboolean lp_is_key(GdkEventKey * event);
static gboolean lp_get_active(widgets_t *widgets_p);
static void lp_set_active(widgets_t *widgets_p, gboolean state);
static void status_grab_focus ( view_t * view_p, int keyval);
static gchar *get_current_text ( GtkTextView * textview);
static view_t *create_notebook_page ( GtkWidget * window, record_entry_t * en);

//#define TESTING

#include "gridview-keybindings.i"
#include "gridview-callbacks.i"
#include "gridview-lpterm.i"
#include "gridview-notebook.i"



static 
view_t *
load(record_entry_t *en){
    NOOP("en=0x%x\n", GPOINTER_TO_INT(en));

    view_t *view_p = create_iconview (en);
    
    if(en){
        view_p->module = en->module;
    }
    NOOP ("module=%s", view_p->module);
    view_preferences_t *view_preferences_p = 
	rfm_get_view_preferences (view_p->flags.type, en);
    rfm_set_view_preferences (view_p, view_preferences_p);
    g_free(view_preferences_p);
    TRACE( "load() calling rodent_full_reload_view\n");
#ifndef TESTING
    rodent_full_reload_view (view_p, en);
#endif
    return view_p;
}

/* public symbols (listed in gridview_lib.h) */
GtkWidget *
create_gridview ( void) {
    rfm_global_t *rfm_global_p = rfm_global();
    rfm_global_p->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    rfm_global_p->thread_queue = rfm_thread_queue_new(rodent_queue_f, NULL, 1);
    view_t *view_p = NULL;
    gint type =  __ROOT_TYPE;
    record_entry_t *en = NULL;
    gchar *exec = g_path_get_basename (rfm_global_p->argv[0]);
    gint i;

#ifdef DEBUG_TRACE
    TRACE ("create_gridview(): exec is %s, argc=%d\n",exec,rfm_global_p->argc);
    for (i=0;i<rfm_global_p->argc; i++){
	TRACE("%d: %s\n", i, rfm_global_p->argv[i]);
    }
#endif

#if 10
    if(exec && strcmp (exec, "rodent-plug")==0) {
        const gchar *module_name = rfm_global_p->argv[1];
	if (!rfm_global_p->argv[1] || !strlen(rfm_global_p->argv[1])){
	    g_warning("%s must specify plugin to load\n", exec);
	    exit(1);
	}
        if (!rfm_void(PLUGIN_DIR, module_name, "module_active")){
            g_warning("Module %s is not active\n", module_name);
            exit(1);
        }
        en = rfm_mk_entry (type);
        en->module = rfm_void (PLUGIN_DIR, module_name, "module_name");
	en->path = rfm_void (PLUGIN_DIR, en->module, "module_label");
	if (rfm_global_p->argv[2] != NULL){
	    // Allow modules to specify internals on the command line.
	    NOOP("rfm_global_p->argv[1]=%s\n", rfm_global_p->argv[1]);
	    rfm_rational(PLUGIN_DIR, en->module, en, 
		    rfm_global_p->argv, "module_argv");
	} 
	view_p = load(en);
        g_free(exec);
	return (view_p)?rfm_global_p->window:NULL;
    }
#else
    // deprecated symlinks...
    // <snip>
#endif

    if (rfm_global_p->argc == 1 && strcmp (exec, "rodent-fm")==0) {
        en = rfm_stat_entry (g_get_home_dir(), 0);
    }

    else if(rfm_global_p->argc >= 2  ) {
	NOOP("argv[1]=%s \n",rfm_global_p->argv[1]);
        if(rfm_g_file_test (rfm_global_p->argv[1], G_FILE_TEST_IS_DIR)) {
	    // strip trailing slash (hack)
	    if (strlen(rfm_global_p->argv[1]) > 1 && 
		rfm_global_p->argv[1][strlen(rfm_global_p->argv[1])-1]=='/'){
		rfm_global_p->argv[1][strlen(rfm_global_p->argv[1])-1]=0;
	    }
	    en = rfm_stat_entry (rfm_global_p->argv[1], 0);
	} else { 
	    // specified directory does not exist.
	    if (strcmp (exec, "rodent")==0){ // rodent defaults plugin root
		TRACE ("Rodent defaults to plugin root\n");
	    } else if (strcmp (exec, "rodent-fm")==0){ 
                // rodent-fm, defaults to homedir
		gchar *wd = g_get_current_dir ();
		gchar *path = g_build_filename (wd, rfm_global_p->argv[1], NULL);
		g_free (wd);
		if(!rfm_g_file_test (path, G_FILE_TEST_IS_DIR)) {
		    NOOP (stderr, _("%s does not exist."), path);
		    NOOP (stderr, "\n");
		    en = rfm_stat_entry (g_get_home_dir(), 0);
		} else {
		    en = rfm_stat_entry (path, 0);
		}
		g_free (path);
	    } else {
                g_warning("symlink %s is deprecated. Please remove it.\n",exec);
                exit(1);
            }
	} 
    }

    g_free (exec);
    NOOP(stderr, "loading...\n");
  

    view_p=load(en);
    // This is a hack to get text buffer online.
    rfm_diagnostics(&(view_p->widgets),"rodent", "This is Rodent-",VERSION,"\n", NULL);

    // create extra tabs (if applicable)
    //
    if (view_p && rfm_global_p->argc > 2) {
	for (i=2; i<rfm_global_p->argc; i++){
	    NOOP("tab for %s\n",rfm_global_p->argv[i]);
	    if (rfm_g_file_test(rfm_global_p->argv[i], G_FILE_TEST_EXISTS)){
		record_entry_t *new_en=rfm_stat_entry(rfm_global_p->argv[i], 0);
		new_en->path=g_strdup(rfm_global_p->argv[i]);
		view_count++;
		view_t *v_p = create_notebook_page (rfm_global_p->window, new_en);

		view_preferences_t *view_preferences_p = 
		    rfm_get_view_preferences (v_p->flags.type, en);
		rfm_set_view_preferences (v_p, view_preferences_p);
		g_free(view_preferences_p);
    
		TRACE( "create_gridview() calling rodent_full_reload_view\n");

		rodent_full_reload_view (v_p, new_en);
	    }
	}
    }
    NOOP(stderr, "load done...\n");
    
    return (view_p)?rfm_global_p->window:NULL;
}


#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<20
#else
static void
add_toolbar_button(GtkBox *bb, RodentButtonDefinition *callback_p){
    rfm_global_t *rfm_global_p = rfm_global();
    if (BUTTON_OVERFLOW_ID >= 64){
	g_error ("add_toolbar_button(): too many bit flags\n");
    }
    gint64 toolbar_preferences = DEFAULT_TOOLBAR_BUTTONS;
    const gchar *rfm_toolbar_s = getenv("RFM_TOOLBAR");
    if (rfm_toolbar_s && strlen(rfm_toolbar_s)){
	errno = 0;
	toolbar_preferences = strtoll(rfm_toolbar_s, NULL, 16);
	if (errno){
	    DBG("t_callback(): %s\n", strerror(errno));
	    toolbar_preferences = DEFAULT_TOOLBAR_BUTTONS;
	}
    }
    GtkWidget *button = gtk_toggle_button_new ();
    if (callback_p->button_name && strlen(callback_p->button_name)) {
	g_object_set_data(G_OBJECT(rfm_global_p->window), callback_p->button_name, button);
    }
    GdkPixbuf *pb = NULL;
    if (callback_p->callback.icon) {
	pb = rfm_get_pixbuf (callback_p->callback.icon, 12);
	GtkWidget *image = gtk_image_new_from_pixbuf (pb);
	g_object_unref(pb);
	gtk_widget_show (image);
	gtk_container_add (GTK_CONTAINER (button), image);
    } else if (callback_p->text) {
	GtkWidget *label = gtk_label_new("");
	gchar *markup = g_strdup_printf("<span  foreground=\"black\" background=\"white\" size=\"xx-small\">%s</span>", _(callback_p->text));
	gtk_label_set_markup(GTK_LABEL(label), markup);
	g_free(markup);
	gtk_widget_show (label);
	gtk_container_add (GTK_CONTAINER (button), label);
    }

    rfm_add_custom_tooltip(button, pb, _(callback_p->callback.string));

    g_object_set (button, "can-focus", FALSE, "relief", GTK_RELIEF_NONE, NULL);
    if (toolbar_preferences &(ONE64<<callback_p->id)) gtk_widget_show (button);
    g_signal_connect (G_OBJECT (button), "button-release-event", G_CALLBACK (button_callback), GINT_TO_POINTER(callback_p->callback.function_id));
    gtk_box_pack_start (bb, button, FALSE, FALSE, 0);
  
}
#endif

#if 0
static void
test_pango(void){
    PangoContext *context = pango_context_new();
    PangoFontFamily **families;
    int n_families;
    pango_context_list_families (context,&families, &n_families);
    TRACE( "pango families=%d\n", n_families);
}
#endif
view_t *
create_iconview ( record_entry_t * en) {
    //test_pango();
    rfm_global_t *rfm_global_p = rfm_global();
    NOOP (">> create_iconview\n");
    GtkWidget *window = rfm_global_p->window;
    gtk_widget_set_has_tooltip (window, TRUE);
     
    GtkWidget *vbox1 = rfm_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox1);

// NOTEBOOK creation
    GtkWidget *notebook = gtk_notebook_new ();
    g_object_set_data(G_OBJECT(window), "notebook", notebook);
    //   gtk_notebook_set_tab_pos ((GtkNotebook *)notebook, GTK_POS_BOTTOM);
    gtk_notebook_popup_disable ((GtkNotebook *) notebook);
    gtk_notebook_set_scrollable ((GtkNotebook *) notebook, TRUE);
    g_object_set (notebook,
                  //"enable-popup", TRUE, 
                  "can-focus", FALSE,
                  "scrollable", TRUE, 
                 // "homogeneous", FALSE, 
                  "show-border", FALSE,
                  "show-tabs", 
                  TRUE, "tab-pos",
                  GTK_POS_TOP, NULL);

    //   g_object_set (notebook,  "show-tabs", FALSE, NULL);
    //   g_object_set (notebook,  "homogeneous", TRUE, NULL); 
    //   "tab-label"

    gtk_box_pack_start (GTK_BOX (vbox1), notebook, TRUE, TRUE, 0);
    gtk_widget_show (vbox1);
    gtk_widget_show (notebook);
// end NOTEBOOK creation
//
// add contents to notebook page
//
    view_t *view_p = create_notebook_page (window, en);
    
    rfm_set_widget(&(view_p->widgets), "widgets_p");
    g_signal_connect (notebook, "switch-page", G_CALLBACK (switch_page), window);

    if(getenv ("RFM_TRANSPARENCY") && strlen (getenv ("RFM_TRANSPARENCY"))) {
        errno = 0;
        double value = strtod (getenv ("RFM_TRANSPARENCY"), NULL);
        if(errno != 0 || value < 0.0) {
            value = 0.0;
        } else if(value > 0.75)
            value = 0.75;
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=8
	gtk_widget_set_opacity (GTK_WIDGET(window), 1.00 - value);
#else
	gtk_window_set_opacity (GTK_WINDOW(window), 1.00 - value);
#endif
    }

// NOTEBOOK toolbar buttons
//
//
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<20
    // no buttons available.
#else
    GtkWidget *bb = rfm_hbox_new (FALSE, 0);
    gtk_notebook_set_action_widget (GTK_NOTEBOOK (notebook), bb, GTK_PACK_END);
    gtk_widget_show (bb);

    RodentButtonDefinition *callback_p = rodent_get_button_definitions();
    for (; callback_p && callback_p->id >= 0; callback_p++){
	add_toolbar_button(GTK_BOX(bb), callback_p);
    }
#endif
    

// NOTEBOOK end
    g_signal_connect (G_OBJECT (window), "query-tooltip", G_CALLBACK (rodent_tip_function), NULL);
    g_signal_connect (G_OBJECT (window), "key-press-event", G_CALLBACK (signal_keyboard_event), NULL);
    g_signal_connect (G_OBJECT (window), "destroy_event", G_CALLBACK (signal_destroy_event), NULL);
    g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (signal_destroy_event), NULL);
    /*   g_signal_connect(G_OBJECT(window), "size-allocate",
       G_CALLBACK(signal_on_size_window), view_p); */
    /* pointer events */
    g_signal_connect (G_OBJECT (window), "configure-event", G_CALLBACK (signal_on_configure_window), NULL);


    /* set minimum window size: */
    gtk_widget_set_size_request ((GtkWidget *) window, 1.3 * SMALL_ICON_SIZE, 1.5 * SMALL_ICON_SIZE);

    gtk_widget_grab_focus (view_p->widgets.paper);
    view_geometry_t *iconview_geometry_p = rodent_get_view_geometry_p (view_p);
    if(iconview_geometry_p) {
        gtk_window_set_default_size ((GtkWindow *) window, iconview_geometry_p->w, iconview_geometry_p->h);
        NOOP ("window... default size=%d,%d\n", iconview_geometry_p->w, iconview_geometry_p->h);
	g_free(iconview_geometry_p);
    } else {
        gtk_window_set_default_size ((GtkWindow *) window, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        NOOP ("window... default size=%d,%d\n", DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    gtk_window_set_resizable ((GtkWindow *) window, TRUE);
    gtk_widget_realize (window);
    gtk_widget_show (window);
    g_timeout_add_seconds (1, watch_preferences, window);

    NOOP ("POP_SEM:  sem_init(&(view_p->population_sem),0,1)\n");
    gdk_flush();
#ifndef TESTING
    // fireoff popup creation thread here.
    rodent_create_popup_bythread();
#endif


    return view_p;
}
