#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

    


static void
tab_constructor(struct widgets_t *widgets_p, const char *path);

static view_t *
new_view_p (
    GtkWidget * window,
    record_entry_t * en
) {
    view_t *view_p = rodent_new_view();
    NOOP("new_view_p(): RSS request\n"); 


    /* initializations: */

    view_p->flags.sortcolumn = GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
    view_p->flags.type = ICONVIEW_TYPE;
    view_p->widgets.view_p = view_p;
    view_p->en = rfm_copy_entry (en);
    /* exported functions: */
    view_p->constructor = create_iconview;
    view_p->tab_constructor = tab_constructor;
    view_p->tab_destructor = tab_destructor;

    view_preferences_t *view_preferences_p = rfm_get_view_preferences (ICONVIEW_TYPE, view_p->en);
    rfm_set_view_preferences (view_p, view_preferences_p);
    g_free(view_preferences_p);
    return view_p;
}

#if 0
static gboolean
event_box_button_press (GtkWidget * widget, 
	GdkEventButton * event, 
	gpointer data) {
    TRACE( "event_box_button_press:  button_press 0x%x(%d) x=%lf y=%lf\n", 
	    GPOINTER_TO_INT(event), event->button, event->x, event->y);
    return FALSE;
}
#endif


static view_t *
create_notebook_page (
    GtkWidget * window,
    record_entry_t * en
) {
     rfm_global_t *rfm_global_p = rfm_global();
     if (rfm_global_p->status == STATUS_EXIT) {
         DBG("Aborting notebook page creation on STATUS_EXIT\n");
        return NULL;
    }

   GtkWidget *notebook=g_object_get_data(G_OBJECT(rfm_global_p->window), "notebook");   
    if (!notebook){
	g_error("create_notebook_page():No notebook\n");
    }

    NOOP("create_notebook_page(): RSS request\n"); 
    view_t *view_p = new_view_p (window, en);

    
    //rfm_threadqueue_push(rfm_global_p->thread_queue, ADD_TO_VIEW_LIST, view_p, NULL);
    view_p->widgets.paper = gtk_drawing_area_new ();
    g_object_set_data (G_OBJECT (view_p->widgets.paper), "view_p", view_p);
    g_object_set (view_p->widgets.paper, 
	    "can-focus", TRUE,
	    "has-focus", TRUE, 
            //  "has-default", TRUE,
	    //  "has-focus", TRUE, 
	    //  "is-focus", TRUE,
	    //  "receives-default", TRUE,
	      NULL);
    gtk_widget_add_events (view_p->widgets.paper,
                           GDK_POINTER_MOTION_MASK |
                           GDK_BUTTON_MOTION_MASK |
                           GDK_BUTTON_PRESS_MASK |
                           GDK_BUTTON_RELEASE_MASK | 
			   GDK_ENTER_NOTIFY_MASK | 
			   GDK_LEAVE_NOTIFY_MASK |
			   GDK_SCROLL_MASK |
#if GLIB_MAJOR_VERSION>=3 && GLIB_MINOR_VERSION>4

			   GDK_SMOOTH_SCROLL_MASK |
#endif
			   GDK_EXPOSURE_MASK);
   
    GtkWidget *page_child_box = rfm_vbox_new (FALSE, 0);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "page_child_box", page_child_box);
    g_object_set_data (G_OBJECT (page_child_box), "view_p", view_p);
    g_object_set_data (G_OBJECT (page_child_box), "widgets_p", &(view_p->widgets));

    GtkWidget *page_label_box = rfm_hbox_new (FALSE, 0);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "page_label_box", page_label_box);
    GtkWidget *page_label_icon_box = rfm_hbox_new (FALSE, 0);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "page_label_icon_box", page_label_icon_box);
    GtkWidget *page_label = gtk_label_new (_("Loading folder..."));
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "page_label", page_label);
    GtkWidget *page_label_button = gtk_button_new ();
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "page_label_button", page_label_button);



    GtkWidget *menu_label_box = rfm_hbox_new(FALSE, 0);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "menu_label_box", menu_label_box);
    GtkWidget *menu_label = gtk_label_new ("menu_label");
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "menu_label", menu_label);
    GtkWidget *menu_image = gtk_image_new ();
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "menu_image", menu_image);

    // Add image to close tab button: page_label_button
    GdkPixbuf *pb = rfm_get_pixbuf ("xffm/stock_close", 8);
    GtkWidget *image = gtk_image_new_from_pixbuf (pb);
    g_object_unref(pb);
    gtk_widget_show (image);
    gtk_container_add (GTK_CONTAINER (page_label_button), image);
    g_object_set (page_label_button, "image", image, "relief", GTK_RELIEF_NONE, NULL);
    g_signal_connect (page_label_button, "clicked", G_CALLBACK (rmpage), view_p);

    rfm_add_custom_tooltip(page_label_button, pb, _("Close tab"));
    //gtk_widget_set_tooltip_text(page_label_button, _("Close tab"));

    // Note: reference to pb is kept in pixbuf hash table.
    //       This is to use the same pixbuf to generate the image
    //       in multiple tabs.

    // Add widgets to page_label_box:
    gtk_box_pack_start (GTK_BOX (page_label_box), page_label_icon_box, TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (page_label_box), page_label, TRUE, TRUE, 0);

    gtk_box_pack_end (GTK_BOX (page_label_box), page_label_button, TRUE, TRUE, 0);
    gtk_widget_show_all (page_label_box);
    gtk_widget_hide (page_label_button);


    // Add widgets to menu_label_box:
    gtk_box_pack_start (GTK_BOX (menu_label_box), menu_image, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (menu_label_box), menu_label, FALSE, FALSE, 0);
    gtk_widget_show_all (menu_label_box);
    

#if GTK_MAJOR_VERSION>=3
    /****************** New: path bar... */
    GtkWidget *pathbar = rodent_new_pathbar();
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "pathbar", pathbar);
    gtk_widget_show(pathbar);
    gtk_box_pack_start (GTK_BOX (page_child_box), pathbar, FALSE, FALSE, 0);
#endif

    // Create child_box widgets:
    //
    // Vpane to separate icon area from lpterminal output area.

    GtkWidget *vpane = rfm_vpaned_new (); 
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "vpane", vpane);
    gtk_box_pack_start (GTK_BOX (page_child_box), vpane, TRUE, TRUE, 0);
    gtk_paned_set_position (GTK_PANED (vpane), 1000);
    gtk_widget_show (vpane);

    // Icon area:
    //   1. Scrolled window to contain drawing area.
    GtkScrolledWindow *scrolled_window = GTK_SCROLLED_WINDOW(gtk_scrolled_window_new (NULL, NULL));
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "scrolled_window", scrolled_window);
    gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    gtk_paned_pack1 (GTK_PANED (vpane), GTK_WIDGET (scrolled_window), FALSE, TRUE);
    gtk_widget_show (GTK_WIDGET (scrolled_window));

    //    2. Drawing area (paper)  goes into scrolled_window. 
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=8
    gtk_container_add(GTK_CONTAINER(scrolled_window), view_p->widgets.paper);

#else
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), view_p->widgets.paper);
#endif

    // Lpterminal output area:

#ifndef TESTING
    //  1. Scrolled window (lpterm_scrolled_window)
    GtkWidget *lpterm_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "lpterm_scrolled_window", lpterm_scrolled_window);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (lpterm_scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_paned_pack2 (GTK_PANED (vpane), lpterm_scrolled_window, TRUE, TRUE);
    //  2. Text view (diagnostics)
    view_p->widgets.diagnostics = gtk_text_view_new ();
    gtk_widget_set_can_focus(view_p->widgets.diagnostics, FALSE);
    gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (view_p->widgets.diagnostics), GTK_WRAP_WORD);
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (view_p->widgets.diagnostics), FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (view_p->widgets.diagnostics), 2);
    gint size = 10;
    PangoFontDescription *font_desc = pango_font_description_new ();
    pango_font_description_set_family (font_desc, "monospace");
    pango_font_description_set_size (font_desc, size * PANGO_SCALE);
#if GTK_MAJOR_VERSION==2
    gtk_widget_modify_font ((view_p->widgets.diagnostics), font_desc);
#else
    gtk_widget_override_font ((view_p->widgets.diagnostics), font_desc);
#endif
    g_object_set_data(G_OBJECT((view_p->widgets.diagnostics)), "font_desc", font_desc);
    pango_font_description_free (font_desc);
    gtk_container_add (GTK_CONTAINER (lpterm_scrolled_window), view_p->widgets.diagnostics);
    gtk_widget_show (lpterm_scrolled_window);
    gtk_widget_show (view_p->widgets.diagnostics);
#endif

    // Process task bar (little run buttons)
    view_p->widgets.button_space = rfm_hbox_new (FALSE, 0);
    gtk_widget_show (view_p->widgets.button_space);
    gtk_box_pack_start (GTK_BOX (page_child_box), view_p->widgets.button_space, FALSE, FALSE, 0);


#ifndef TESTING
    // Status/lpterminal-input text view.
    view_p->widgets.status = gtk_text_view_new ();
    gtk_widget_show (view_p->widgets.status);
    gtk_box_pack_start (GTK_BOX (view_p->widgets.button_space), view_p->widgets.status, TRUE, TRUE, 3);
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (view_p->widgets.status), FALSE);
    //gtk_widget_set_can_focus(view_p->widgets.status, TRUE);
    gtk_text_view_set_editable (GTK_TEXT_VIEW (view_p->widgets.status), TRUE);
    rfm_text_view_set_wrap_mode (GTK_TEXT_VIEW (view_p->widgets.status), GTK_WRAP_CHAR);
    g_signal_connect (G_OBJECT (view_p->widgets.status), "key_press_event", G_CALLBACK (on_status_key_press), &(view_p->widgets));
    g_signal_connect (G_OBJECT (view_p->widgets.status), "button-release-event", G_CALLBACK (on_button_release), &(view_p->widgets));
    g_signal_connect (G_OBJECT (view_p->widgets.status), "button-press-event", G_CALLBACK (on_button_press), &(view_p->widgets));
    g_signal_connect (G_OBJECT (view_p->widgets.status), "motion-notify-event", G_CALLBACK (on_motion_event), &(view_p->widgets));
    /*  g_signal_connect(G_OBJECT(view_p->widgets.status), "focus",
       G_CALLBACK(on_status_key_press), &(view_p->widgets)); */
    g_object_set_data (G_OBJECT (view_p->widgets.status), "clean", GINT_TO_POINTER(0x01));
#endif

#ifndef TESTING

#ifdef SHOW_SIZE_SCALE
    // Size scale
    GtkWidget *size_scale;
#if 0
    // use full scale... whatever...
    if (rfm_void(RFM_MODULE_DIR, "icons", "module_active")){
	size_scale = rfm_hscale_new_with_range (0.0, 96.0, 12.0);
    } else {
	size_scale = rfm_hscale_new_with_range (0.0, 48.0, 12.0);
    }
#endif
    size_scale = rfm_hscale_new_with_range (0.0, 96.0, 12.0);

    g_object_set_data(G_OBJECT(view_p->widgets.paper), "size_scale", size_scale);

    gtk_scale_set_draw_value (GTK_SCALE(size_scale), FALSE);
    gtk_widget_set_can_focus (size_scale, FALSE);
    gtk_widget_set_size_request (size_scale, 75, 30);
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    // this is deprecated and there is no replacement. 
    // That's a pity...
    gtk_range_set_update_policy (GTK_RANGE(size_scale), GTK_UPDATE_DISCONTINUOUS);
#endif
     
    gtk_box_pack_end (GTK_BOX (view_p->widgets.button_space), size_scale, FALSE, FALSE, 0);
    gtk_widget_show (size_scale);
    g_signal_connect (G_OBJECT (size_scale), 
	    "value-changed", G_CALLBACK (size_scale_callback), &(view_p->widgets));
    g_signal_connect (G_OBJECT (size_scale), "scroll-event", 
	    G_CALLBACK (scroll_event_callback2), &(view_p->widgets));
#endif

    // clear diagnostics area button
    view_p->widgets.clear_button = rfm_mk_little_button (
	    "xffm/stock_clear", 
	    (void *) rfm_clear_text_window, 
	    (void *) (&(view_p->widgets)), _("Clear"));
    gtk_box_pack_end (GTK_BOX (view_p->widgets.button_space), 
	    view_p->widgets.clear_button, FALSE, FALSE, 0);
    gtk_widget_show (view_p->widgets.clear_button);
#endif

    /* events */

    g_signal_connect (G_OBJECT (gtk_scrolled_window_get_vadjustment (scrolled_window)),
	    "value-changed", G_CALLBACK (adjustment_changed), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "size-allocate", G_CALLBACK (signal_on_size_paper), view_p);
  
#if GTK_MAJOR_VERSION==2
    g_signal_connect (G_OBJECT (vpane), 
	    "expose-event", G_CALLBACK (signal_on_configure_vpane), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "expose-event", G_CALLBACK (rodent_expose), view_p);
#endif
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION<=8
    // This stopped working in 3.10
    g_signal_connect (G_OBJECT (vpane), 
	    "draw", G_CALLBACK (signal_on_configure_vpane), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "draw", G_CALLBACK (rodent_draw), view_p);
#endif 
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=10
    // draw event no longer received by paper.
    // This works in 3.12 and also in 3.4, but not in 3.8... figure that out...
    g_signal_connect (G_OBJECT (scrolled_window), 
	    "draw", G_CALLBACK (signal_on_draw_scrolled_window), view_p);
    g_signal_connect (G_OBJECT (vpane), 
	    "draw", G_CALLBACK (signal_on_draw_vpane), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "draw", G_CALLBACK (signal_on_draw_paper), view_p);
#endif
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION==9
    // I haven't tested this unstable gtk version.
#error "gtk+-3.9.x not supported. go for 3.10 or greater. Or even 3.8 or less."
#endif

    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "configure-event", G_CALLBACK (signal_on_configure_paper), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "button-press-event", G_CALLBACK (rodent_signal_on_button_press), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "button-release-event", G_CALLBACK (rodent_signal_on_button_release), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "enter-notify-event", G_CALLBACK (signal_on_enter), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "motion-notify-event", G_CALLBACK (rodent_signal_on_motion), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "leave-notify-event", G_CALLBACK (signal_on_leave_paper), view_p);
    
    view_p->signal_handlers[0] = 
	g_signal_connect (G_OBJECT (rfm_global_p->window), 
		"leave-notify-event", G_CALLBACK (signal_on_leave), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "scroll-event", G_CALLBACK (scroll_event_callback), &(view_p->widgets));

    /* drag and drop events */
    rodent_create_target_list (view_p);


    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "drag-data-received", G_CALLBACK (rodent_signal_drag_data), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "drag-data-get", G_CALLBACK (rodent_signal_drag_data_get), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "drag-motion", G_CALLBACK (rodent_signal_drag_motion), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "drag-end", G_CALLBACK (rodent_signal_drag_end), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "drag-begin", G_CALLBACK (rodent_signal_drag_begin), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "drag-leave", G_CALLBACK (rodent_signal_drag_leave), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), 
	    "drag-data-delete", G_CALLBACK (rodent_signal_drag_delete), view_p);


    // Insert page into notebook:
    gtk_widget_show (page_child_box);
    gint position=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook))+1;
    //gtk_notebook_insert_page_menu (GTK_NOTEBOOK(notebook), page_child_box, page_label, menu_label_box, position);
    gtk_notebook_insert_page_menu (GTK_NOTEBOOK(notebook), page_child_box, page_label_box, menu_label_box, position);
    //gtk_notebook_insert_page_menu (GTK_NOTEBOOK(notebook), page_child_box, NULL, menu_label_box, position);
    gtk_notebook_set_tab_reorderable (GTK_NOTEBOOK(notebook), page_child_box, TRUE);



    gtk_widget_queue_draw (view_p->widgets.paper);//??
    rfm_layout_set_root_parameters(view_p);

    gtk_widget_realize (view_p->widgets.paper);


    gtk_widget_show (view_p->widgets.paper);
    rfm_hide_text(&(view_p->widgets));
    // set vpane allocation.
    rfm_layout_set_vpane_allocation(view_p);

    gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook), position);
    rfm_add_view(view_p);
    rfm_view_thread_create(view_p, rfm_load_sh_command_history, (gpointer) view_p, "rfm_load_sh_command_history");
    
    return view_p;

}

