#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;  */

/////////////////////////////////////////////////////////////////
//////////     main thread callbacks ////////////////////////////
/////////////////////////////////////////////////////////////////
static gint view_count = 1; // Initial startup value.

/* basic callback functions used to set up the iconview 
 *
 * */
#define SHOW_SIZE_SCALE
static gboolean
scroll_event_callback2 (GtkWidget *paper, GdkEventScroll  *event, gpointer data){
    NOOP (stderr, ">>  scroll_event_callback button: %d\n", event->direction);
    gint direction = event->direction;
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=4
    if (event->direction==GDK_SCROLL_SMOOTH) {
	gdouble delta_x;
	gdouble delta_y;
	gdk_event_get_scroll_deltas((GdkEvent *)event, &delta_x,&delta_y);
	NOOP(stderr, "deltax=%lf, deltay=%lf\n",delta_x,delta_y);
	if (delta_y < 0) direction = 0; 
	else if (delta_y > 0) direction = 1;
    }
#endif
    //widgets_t *widgets_p = data;

    if (direction==0) {
	    rodent_menu_callback(NULL, GINT_TO_POINTER(PLUS_ICONSIZE_ACTIVATE));
    } else if (direction==1) {
	    rodent_menu_callback(NULL, GINT_TO_POINTER(MINUS_ICONSIZE_ACTIVATE));
    }

    // 0=up
    // 1=down
    // 2=left
    // 3=right
    return TRUE;
}

static gboolean
scroll_event_callback (GtkWidget *paper, GdkEventScroll  *event, gpointer data){
    NOOP (stderr, ">>  scroll_event_callback button: %d\n",
	    event->direction);
    if(event->state & GDK_CONTROL_MASK) {
	return scroll_event_callback2(paper, event, data);
    }

    return FALSE;
} 
static void
adjustment_changed (
    GtkAdjustment * adjustment,
    gpointer data
) {
    view_t *view_p = (view_t *) data;
    
    /*GtkScrolledWindow *scrolled_window = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), "scrolled_window");
    GtkAdjustment *adjustment = gtk_scrolled_window_get_vadjustment (scrolled_window);*/
    /*
    gdouble origin = gtk_adjustment_get_value(adjustment);
    gdouble page=gtk_adjustment_get_page_size (adjustment);
    gint cellheight = rfm_layout_get_cellheight(view_p);
    gint low_row = floor(origin/(double)cellheight);
    gint high_row = floor((page+origin)/(double)cellheight);
    */

    NOOP (stderr, ">>> geometry: adjustment_changed to %lf (%lf) rows %d,%d\n",
	    origin,page,low_row,high_row );

    if (view_p->widgets.rename) {
	rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(DONE_WITH_RENAME), "callback");
    }


    rodent_save_local_view_geometry_p (view_p);
    rodent_hide_tip();
    rodent_unsaturate_icon (view_p);
    rodent_unsaturate_label (view_p);
}


static gboolean
signal_destroy_event (
    GtkWidget * window,
    GdkEvent * event,
    gpointer data
) {
    rfm_rational(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(QUIT_ACTIVATE), NULL, "callback");
    return TRUE;
}

static void
signal_on_size_paper (
    GtkWidget * widget,
    GtkAllocation * allocation_p,
    gpointer user_data
) {
     rfm_global_t *rfm_global_p = rfm_global();
   TRACE ( "paper size-allocate signal -->  signal_on_size_paper()\n");
    GtkAllocation allocation;
    gtk_widget_get_allocation (rfm_global_p->window,&allocation);
    rfm_set_allocation(&allocation);

    view_t *view_p = (view_t *) user_data;
    NOOP(stderr, "signal_on_size_paper() view=0x%x\n", GPOINTER_TO_INT(view_p));
  
    rfm_layout_set_vpane_allocation(view_p);
    if (!g_object_get_data(G_OBJECT(widget), "paper_setup")) {
	TRACE(">>>>>> paper not setup yet...\n");
	return;
    } else {
	TRACE(">>>>>> paper setup OK...\n");
	// Has window been resized? If yes, then we must do a reload.
	if (rfm_layout_set_window_size(view_p, allocation.width, allocation.height)) {
	    // This will be an event generated reload. 
	    // We will also hide the text area for consistent behavior.
	    rodent_save_local_view_geometry_p(view_p);
	    rodent_save_root_view_geometry_p(view_p);

	    rfm_hide_text(&(view_p->widgets));
	    rodent_trigger_reload(view_p);
	    //rodent_set_scroll_position (view_p);
	}
    }
    return;
}
#if GTK_MAJOR_VERSION>2
// rework for gtk-3.12 nasty behavior with draw signal only sent to 
// vpane(not to window nor drawing area)
static gboolean
signal_on_draw_scrolled_window ( GtkWidget * widget,
    cairo_t *cr,
    gpointer data
) {
    
    //view_t *view_p = data;
    GdkRectangle rect;
    gint result = gdk_cairo_get_clip_rectangle (cr, &rect);
    /*static gint i=0; DBG( "*signal_on_draw_scrolled_window(%d) %d,%d,%d,%d --> %d\n",
            ++i,
            rect.x, rect.y, rect.width,rect.height, result);*/
    //rodent_draw(widget, cr, data);
    return FALSE;
}

static gboolean
signal_on_draw_window ( GtkWidget * widget,
    cairo_t *cr,
    gpointer data
) {
    /*
    //view_t *view_p = data;
    GdkRectangle rect;
    gint result = gdk_cairo_get_clip_rectangle (cr, &rect);
    static gint i=0; DBG( "*signal_on_draw_window(%d) %d,%d,%d,%d --> %d\n",
            ++i,
            rect.x, rect.y, rect.width,rect.height, result);*/
    return FALSE;
}
static gboolean
signal_on_draw_paper ( GtkWidget * widget,
    cairo_t *cr,
    gpointer data
) {
    /*
    //view_t *view_p = data;
    GdkRectangle rect;
    gint result = gdk_cairo_get_clip_rectangle (cr, &rect);
    static gint i=0; DBG( "-signal_on_draw_paper(%d) %d,%d,%d,%d --> %d\n",
            ++i,
            rect.x, rect.y, rect.width,rect.height, result);
  //  rodent_draw(widget, cr, data);
    */
    return TRUE;
}

// In deference to gtk-3.12, draw action is in vpane draw callback.
// (the only widget which gets the event)
static gboolean
signal_on_draw_vpane (
    GtkWidget * widget,
    cairo_t *cr,
    gpointer data
) {
    view_t *view_p = data;
    widgets_t *widgets_p = &(view_p->widgets);


    
    GtkPaned *vpane = g_object_get_data(G_OBJECT(view_p->widgets.paper), "vpane");
    gint position = gtk_paned_get_position (vpane);
    GdkRectangle rect;
    gint result = gdk_cairo_get_clip_rectangle (cr, &rect);
    // Are we within bounds?
    if (rect.y >= position) return FALSE; // no.


    cairo_t *gdk_context = gdk_cairo_create(gtk_widget_get_window(widgets_p->paper));
    // clip...
    gint rodent_set_draw_clip(view_t *, cairo_t *);
    // Trim off whatever is not in the drawing area.
    rodent_set_draw_clip(view_p, gdk_context);
    
    rodent_draw(widget, gdk_context, data);
    cairo_destroy(gdk_context);
    
   return FALSE;
}
#endif

static gboolean
signal_on_configure_vpane (
    GtkWidget * widget,
    GdkEvent * event,
    gpointer data
) {
    view_t *view_p = data;
    rfm_layout_set_vpane_allocation(view_p);
    //static gint i=0; DBG( ">>> vpane: signal_on_configure_vpane(%d)\n", ++i);
    //gtk_widget_get_allocation (view_p->widgets.vpane, &(view_p->widgets.vpane_allocation));
    
    return FALSE;
}

static gboolean
signal_on_configure_paper (
    GtkWidget * widget,
    GdkEventConfigure * event,
    gpointer data
) {
    //DBG( "*** paper: configure-event signal --> signal_on_configure_paper()\n");
    return FALSE;
   // return TRUE;
}

static gboolean
signal_on_configure_window (
    GtkWidget * window,
    GdkEventConfigure * event,
    gpointer data
) {
     rfm_global_t *rfm_global_p = rfm_global();
   //DBG(">>> window: configure-event --> signal_on_configure_window()\n");

    view_t *view_p = rodent_get_current_view (window);
    if (!view_p) return FALSE;
   
    GtkAllocation allocation;
    gtk_widget_get_allocation (rfm_global_p->window,&allocation);
    rfm_set_allocation(&allocation);

    NOOP("window  w: %d, H:%d\n", allocation.width, allocation.height);
    static gint w = 0;
    static gint h = 0;
    if(view_p->widgets.rename && (w != allocation.width || h !=allocation.height)) {
        w = allocation.width;
        h = allocation.height;
        rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(DONE_WITH_RENAME), "callback");
    }
    /*if (view_p->widgets.vpane){
	gtk_paned_set_position(GTK_PANED(view_p->widgets.vpane), 10000);
    }*/
    return FALSE;
}

static gboolean
signal_on_enter (GtkWidget * widget, GdkEventCrossing * event, gpointer data) {
    NOOP ("rodent_mouse: on_enter\n");
    //view_t *view_p = (view_t *)data;   
    return TRUE;
}

static gboolean
signal_on_leave_paper (GtkWidget * widget, GdkEventCrossing * event, gpointer data) {
    NOOP ("rodent_mouse: on_leave_paper\n");
    view_t *view_p = (view_t *) data;
    return rodent_on_leave_paper(view_p);
}


static gchar *
get_text_to_cursor ( GtkTextView * textview) {
    // get current text
    GtkTextIter start, end;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer (textview);
    gint cursor_position;
    g_object_get (G_OBJECT (buffer), "cursor-position", &cursor_position, NULL);
    
    gtk_text_buffer_get_iter_at_offset (buffer, &start, 0);
    gtk_text_buffer_get_iter_at_offset (buffer, &end, cursor_position);
    gchar *t = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);
    g_strchug(t);
    NOOP ("TO cursor position=%d %s\n", cursor_position, t);
    return t;
}


static gchar *
get_current_text ( GtkTextView * textview) {
    // get current text
    GtkTextIter start, end;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer (textview);

    gtk_text_buffer_get_bounds (buffer, &start, &end);
    gchar *t = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);
    g_strchug(t);
    return t;
   /* gchar *tt = t;
    while(*tt == ' ')
        tt++;
    gchar *ttt = g_strdup (tt);
    g_free (t);
    return ttt;*/
}

static void
status_grab_focus ( view_t * view_p, int keyval) {
    widgets_t *widgets_p = &(view_p->widgets);
    if(g_object_get_data (G_OBJECT (widgets_p->status), "clean")) {
        rfm_status (widgets_p, "xffm/emblem_terminal", NULL);
	view_p->sh_command_counter=g_list_length(view_p->sh_command)-1;
    } else {
        gchar *t = get_current_text ((GtkTextView *) widgets_p->status);
        rfm_status (widgets_p, "xffm/emblem_terminal", t, NULL);
        // keep unclean status...
        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        g_free (t);
    }
    gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW  (widgets_p->status), TRUE);
    gtk_widget_grab_focus (widgets_p->status);

    return;
}


// mod2 is numlock
// mod5 is alt-gr
//

static gboolean
signal_keyboard_event (
    GtkWidget * window,
    GdkEventKey * event,
    gpointer data
) {
    TRACE(">> signal_keyboard_event: 0x%x\n", event->keyval);

    /* asian Input methods */
    if(event->keyval == GDK_KEY_space && (event->state & (GDK_MOD1_MASK | GDK_SHIFT_MASK))) {
        return FALSE;
    }
    gint ignore[]={
        GDK_KEY_Control_L,
        GDK_KEY_Control_R,
        GDK_KEY_Shift_L,
        GDK_KEY_Shift_R,
        GDK_KEY_Shift_Lock,
        GDK_KEY_Caps_Lock,
        GDK_KEY_Meta_L,
        GDK_KEY_Meta_R,
        GDK_KEY_Alt_L,
        GDK_KEY_Alt_R,
        GDK_KEY_Super_L,
        GDK_KEY_Super_R,
        GDK_KEY_Hyper_L,
        GDK_KEY_Hyper_R,
	GDK_KEY_ISO_Lock,
	GDK_KEY_ISO_Level2_Latch,
	GDK_KEY_ISO_Level3_Shift,
	GDK_KEY_ISO_Level3_Latch,
	GDK_KEY_ISO_Level3_Lock,
	GDK_KEY_ISO_Level5_Shift,
	GDK_KEY_ISO_Level5_Latch,
	GDK_KEY_ISO_Level5_Lock,
        0
    };

    gint i;
    for (i=0; ignore[i]; i++) {
        if(event->keyval ==  ignore[i]) {
	    TRACE("key ignored\n");
            return TRUE;
        }
    }
    widgets_t *widgets_p = rfm_get_widget("widgets_p");

    TRACE("signal_keyboard_event(): lp_get_active = %d\n", lp_get_active(widgets_p));


    if (!lp_get_active(widgets_p)) {
	if (event->keyval == GDK_KEY_Tab){
	    event->keyval = GDK_KEY_Escape;
	}
    }

    if (lp_get_active(widgets_p)){
	if (event->keyval == GDK_KEY_Escape){
	    iconview_key(widgets_p, event);
	    return TRUE;
	}
	// Send to status keycallback.
	
	if (event->keyval == GDK_KEY_Delete){
	    return FALSE;
	}
	if (event->keyval != GDK_KEY_Return && event->keyval != GDK_KEY_KP_Enter
		&& iconview_key(widgets_p, event)) {
	    TRACE("key is for iconview and is ignored\n");
	    return TRUE;
	}
    }

    if (rodent_do_callback(event->keyval, event->state)) {
        TRACE("signal_keyboard_event(): Tried callback with keyval!\n");
        return TRUE;
    }
    
    if (!lp_get_active(widgets_p)){
	if (iconview_key(widgets_p, event)) {
            TRACE("signal_keyboard_event(): ran iconview_key() with keyval!\n");
            return TRUE;
        }
    }

    if ((event->state & GDK_CONTROL_MASK) && !lp_is_key(event)) return TRUE;

    view_t *view_p = widgets_p->view_p;
    if (view_p->selection_list) {
	// selection list must be redefined...
	update_reselect_list(widgets_p);
	TRACE( "Selection---> %p\n", view_p->selection_list);	
    }
    //False defaults to status line keybinding signal callback
    return FALSE;
}
    
//////////////  child thread functions
static void *
newpage_f (view_t *view_p, gchar *path) {
     rfm_global_t *rfm_global_p = rfm_global();
   TRACE( "newpage_f()...\n");
    view_count++;

    record_entry_t *en;
    if (path) {
	en=rfm_stat_entry (path, 0);
	g_free(path);
    } else {
	en = rfm_copy_entry (view_p->en);
    }

    //GtkWidget *notebook=g_object_get_data(G_OBJECT(rfm_global_p->window), "notebook");   
    view_t *v_p = create_notebook_page (rfm_global_p->window, en);
    v_p->module = view_p->module;
    //TRACE( "reloading ... %s\n", en->path);
    rfm_layout_set_icon_size(v_p, ICON_SIZE_ID(view_p));
    rfm_layout_set_vpane_allocation(v_p);
    rfm_layout_configure(v_p, MAX_ELEMENTS(view_p));    

    // This will set current tab title to bold.
    rodent_full_reload_view (v_p, en);
    return NULL;
}


static void *
rmpage_f(void *data){
     rfm_global_t *rfm_global_p = rfm_global();
   view_t *view_p = data;
    TRACE("rmpage_f()...ZZZ \n");
    view_count--;

    g_mutex_lock(view_p->mutexes.status_mutex);
    view_p->flags.status = STATUS_EXIT;
    g_mutex_unlock(view_p->mutexes.status_mutex);
    
    //widgets_t *widgets_p = &(view_p->widgets);
    xfdir_exit_monitor (view_p);


   // First, hide all widgets.
    if (view_count == 0) {
	if (rfm_global_p->window) gtk_widget_hide(rfm_global_p->window);
    }

    else {
	GtkNotebook *notebook=g_object_get_data(G_OBJECT(rfm_global_p->window), "notebook");   
	gint page_num = gtk_notebook_get_current_page(notebook);
	TRACE("removing page %d\n", page_num);
	gtk_notebook_remove_page (notebook, page_num); 
	gint n = gtk_notebook_get_current_page(notebook);
	TRACE( "current page %d\n", n);
	GtkWidget *new_child =gtk_notebook_get_nth_page(notebook, n);
	view_t *new_view_p = g_object_get_data (G_OBJECT (new_child), "view_p");
	rfm_set_widget(&(new_view_p->widgets), "widgets_p");
	TRACE( "widgets_p = 0x%x\n", GPOINTER_TO_INT(&(new_view_p->widgets)));
    }

    // Tag view for cleanup by janitor.
    // Janitor will remove from view list after
    // referenced threads have finished.
   
    // Janitor signal (This wakes up the janitor).
    g_cond_signal(rfm_global_p->janitor_signal);
    
    return NULL;
}

static void *
switch_page_f(view_t *view_p){
    //return NULL;
    //widgets_t *widgets_p = &(view_p->widgets);
    rfm_global_t *rfm_global_p = rfm_global();
    GtkNotebook *notebook = GTK_NOTEBOOK (g_object_get_data(G_OBJECT(rfm_global_p->window), "notebook"));
   TRACE( "switch_page_f(%d)... view_count = %d\n", gtk_notebook_get_current_page(notebook, view_count));
    if (view_count == 0) return NULL;

    g_mutex_lock(rfm_global_p->status_mutex);
    gint status = rfm_global_p->status;
    g_mutex_unlock(rfm_global_p->status_mutex);
    if (status == STATUS_EXIT) {
        return NULL;
    }

    GSList **list_p = rfm_view_list_lock(NULL, "switch_page_f");
    if (!list_p) return NULL;
/*    GSList **list_p = rfm_view_list_lock(view_p);
    if (!list_p) {
	DBG( "view 0x%x is no longer active\n", GPOINTER_TO_INT(view_p));
        return NULL;
    } */
	
    rfm_set_widget(&(view_p->widgets), "widgets_p");
 
    gchar *label_text;
    GSList *list = *list_p;
    gboolean view_is_new = TRUE;

    // turn buttons off, alternate way:
    // foreach notebook page, get paper, use that instead of v_p stuff

    gint last_page = gtk_notebook_get_n_pages(notebook);
    gint page_count;
    for (page_count=0; page_count < last_page; page_count++){
       GtkWidget *page_child_box = gtk_notebook_get_nth_page(notebook, page_count);
       if (!page_child_box) continue;
       widgets_t *widgets_p = g_object_get_data(G_OBJECT(page_child_box), "widgets_p");
       if (!widgets_p) continue;
	view_t *v_p = g_object_get_data(G_OBJECT(page_child_box), "view_p");
       if (!view_p) continue;
	GtkWidget *page_label=g_object_get_data(G_OBJECT(widgets_p->paper), "page_label");   
	GtkWidget *page_label_button=g_object_get_data(G_OBJECT(widgets_p->paper), "page_label_button");

	if (page_label_button && GTK_IS_WIDGET(page_label_button)){
	    gtk_widget_hide (page_label_button);
            TRACE("hidding page_label_button for view %p\n", v_p);
	} else {
            DBG("This is wrong, cannot find page_label_button for page\n");
        }
        const gchar *weight="weight=\"ultralight\"";
        const gchar *color="background=\"#9e9a91\" foreground=\"#444444\"";
	if (v_p == view_p) {
            view_is_new = FALSE;
            weight="";
	    color="background=\"white\" foreground=\"black\"";
        }
#if 0
	const gchar *path=NULL;
        label_text = (v_p->en)?rodent_get_tabname(v_p->en->path): g_strdup(g_get_host_name());

	gchar *markup = g_strdup_printf("<span %s %s>%s</span>", weight, color, label_text);
        TRACE(   "1. markup=%s\n", markup);
	gtk_label_set_markup(GTK_LABEL (page_label), markup);
	g_free(markup);
	g_free(label_text);
	GtkLabel *menu_label = g_object_get_data(G_OBJECT(v_p->widgets.paper), "menu_label");
	if (menu_label) {
	    path = (v_p->en)?v_p->en->path:g_get_host_name();
	    gchar *chopped_path=g_strdup(path);
	    rfm_chop_excess (chopped_path);
	    gchar *utf_path=rfm_utf_string(chopped_path);
	    g_free(chopped_path);
	    markup = g_strdup_printf("<span %s %s>%s</span>", weight, color, utf_path);
            TRACE(  "2. markup=%s\n", markup);
	    gtk_label_set_markup(menu_label, markup);
	    g_free (markup);
	    g_free (utf_path);
	}
#endif

    }

    if(view_count > 1 || view_is_new) { 
	GtkWidget *page_label_button=g_object_get_data(G_OBJECT(view_p->widgets.paper), "page_label_button");   
	gtk_widget_show (page_label_button);
    }
    if (lp_get_active(&(view_p->widgets))) {
	gtk_widget_grab_focus (view_p->widgets.status);
	//    status_grab_focus (view_p, 0);
    } else {
	gtk_widget_grab_focus (view_p->widgets.paper);
    }

    rodent_set_view_icon (view_p);
    rodent_set_view_title (view_p);
    xfdir_monitor_control_greenlight(&(view_p->widgets));
    rfm_view_list_unlock("switch_page_f");
    return NULL;
}


static void
rmpage ( GtkButton * button, gpointer data) {
    view_t *view_p = data;
    rmpage_f(view_p);
}

static void
switch_page (
    GtkNotebook * notebook,
    GtkWidget * page,
    guint npage,
    gpointer data
) {
    GtkWidget *child =gtk_notebook_get_nth_page(notebook, npage);
    if (!child) return;
    view_t *view_p = g_object_get_data (G_OBJECT (child), "view_p");

    NOOP(stderr, "npage --> %d\n", npage);
    switch_page_f(view_p);
    if (rfm_layout_is_setup(view_p)) rodent_set_toggle_buttons(view_p);
    return;
}

static void
tab_constructor(struct widgets_t *widgets_p, const char *path){
    TRACE("tab constructor = %s\n", path);
    view_t *view_p = widgets_p->view_p;
    newpage_f(view_p, g_strdup(path));
    return;
}

static void
tab_destructor(view_t *view_p){
    rmpage(NULL, view_p);
    return;
}

static gchar *window_color = NULL;
static double window_transparency = 0.0;
static gchar *rfm_default_icon_size=NULL;
static gint64 rfm_toolbar_settings=DEFAULT_TOOLBAR_BUTTONS;
static void *

// Gridview monitor:
watch_preferences_f (void) {
    //return NULL;
    rfm_global_t *rfm_global_p = rfm_global();
    TRACE("gridview: watch_preferences_f\n");
    gint64 rfm_toolbar = DEFAULT_TOOLBAR_BUTTONS;
    const gchar *rfm_toolbar_s = getenv("RFM_TOOLBAR");
    if (rfm_toolbar_s && strlen(rfm_toolbar_s)){
	errno = 0;
	rfm_toolbar = strtoll(rfm_toolbar_s, NULL, 16);
	if (errno){
	    DBG("t_callback(): %s\n", strerror(errno));
	    rfm_toolbar = DEFAULT_TOOLBAR_BUTTONS;
	}
    }
    if (rfm_toolbar_settings != rfm_toolbar){
	rfm_toolbar_settings = rfm_toolbar;
	gint i;
        RodentButtonDefinition *button_callback_p = 
            rodent_get_button_definitions();
	for (i=0; i<BUTTON_OVERFLOW_ID; i++){
	    GtkWidget *button =
		g_object_get_data(G_OBJECT(rfm_global_p->window), (button_callback_p+i)->button_name);
	    if (!button) continue;
	    if (rfm_toolbar &(ONE64<<(button_callback_p+i)->id)) {
		
		gtk_widget_show(button);
	    } else {
		gtk_widget_hide(button);
	    }
	}
    }


    const gchar *RFM_TRANSPARENCY = getenv ("RFM_TRANSPARENCY");
    const gchar *P_SERIAL = getenv ("RFM_PASTEBOARD_SERIAL");
    const gchar *I_COLOR = getenv ("RFM_ICONVIEW_COLOR");
    const gchar *I_SIZE = getenv ("RFM_DEFAULT_ICON_SIZE");
    if (!rfm_default_icon_size) {
	rfm_default_icon_size = g_strdup(I_SIZE);
    }

    //XXX keybindings load should be in this file
    rodent_load_keybindings();
    // thread safe:
    rodent_icontheme_test();
    TRACE("watch_preferences_f\n");
    GSList **list_p = rfm_view_list_lock(NULL, "watch_preferences_f");
    if (!list_p) return NULL;
    g_mutex_lock(rfm_global_p->status_mutex);
    gint status = rfm_global_p->status;
    g_mutex_unlock(rfm_global_p->status_mutex);
    if (status == STATUS_EXIT) {
        rfm_view_list_unlock("watch_preferences_f");
        return NULL;
    }

    GSList *view_list = *list_p;

    for(; view_list; view_list = view_list->next) {
        if (rfm_global_p->status == STATUS_EXIT) continue;
        view_t *view_p = view_list->data;
//fixme also shorten tab title just as tab menu item is...
	gboolean status = view_p->flags.status;
	if (status == STATUS_EXIT) {
            continue;
        }

	//if (view_p->flags.no_expose) continue;
		
	if (rfm_diagnostics_is_visible (&(view_p->widgets)) ) {
	    gtk_widget_show(view_p->widgets.clear_button);
	} else {
	    gtk_widget_hide(view_p->widgets.clear_button);
	}
	
        if(I_COLOR && strlen (I_COLOR)) {
            if(!window_color || strcmp (window_color, I_COLOR)) {
                TRACE ("Reloading RFM_ICONVIEW_COLOR %s\n", I_COLOR);
                g_free (window_color);
                window_color = g_strdup (I_COLOR);
		rodent_expose_all(view_p);
            }
        }
        if(P_SERIAL && strlen (P_SERIAL)) {
	    NOOP("Pasteboard serial=%s\n",P_SERIAL);
            errno = 0;
            long value = strtol (P_SERIAL, NULL, 0);
            if(errno != 0 || value != view_p->flags.pasteboard_serial) {
	        TRACE("Pasteboard serial= %d --> %s\n",
			view_p->flags.pasteboard_serial, P_SERIAL);
                view_p->flags.pasteboard_serial = value;
		// thread safe...
                rfm_update_pasteboard (view_p);
		// This is thread safe. An expose signal may be generated, 
		// but the signal is done in its own thread.
                rodent_update_cut_icons (view_p);
            }
        }
        if(I_SIZE && I_SIZE) {
	    if (strcmp(I_SIZE, rfm_default_icon_size)!=0)
	    {
		g_free(rfm_default_icon_size);
		rfm_default_icon_size=
		    g_strdup(I_SIZE);
		TRACE("Default icon size changed to %s\n", 
			rfm_default_icon_size);
	    }
        }

	//This needs to be done for all views
	//so that icons will be updated correctly:
	// This is thread safe. An expose signal may be generated,
	// but the signal is done in a thread.
	//rfm_view_thread_create (view_p, rodent_bookmark_monitor, view_p, "rodent_bookmark_monitor");
	rfm_threadqueue_push(rfm_global_p->thread_queue, BOOKMARK_MONITOR, view_p, NULL);
    }


    if(RFM_TRANSPARENCY && strlen (RFM_TRANSPARENCY)) {
        errno = 0;
        double value = strtod (RFM_TRANSPARENCY, NULL);
        if(errno != 0 || value < 0.0) {
            value = 0.0;
        } else if(value > 0.75)
            value = 0.75;
        if(value != window_transparency) {
            window_transparency = value;
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=8
            gtk_widget_set_opacity (GTK_WIDGET(rfm_global_p->window), 1.00 - window_transparency);
#else
            gtk_window_set_opacity (GTK_WINDOW(rfm_global_p->window), 1.00 - window_transparency);
#endif
        }
    }
    rfm_view_list_unlock("watch_preferences_f");
    return NULL;
}



// Gridview_monitor:
// This queues to the thread pool...
static gboolean
watch_preferences ( gpointer data) {
    rfm_global_t *rfm_global_p = rfm_global();
    if (!rfm_rw_lock_reader_trylock (&(rfm_global_p->setup_lock))){
	TRACE("watch_preferences: setup_lock not available yet...\n");
	return TRUE;
    }
    rfm_rw_lock_reader_unlock (&(rfm_global_p->setup_lock));
    g_mutex_lock(rfm_global_p->status_mutex);
    gint status = rfm_global_p->status;
    g_mutex_unlock(rfm_global_p->status_mutex);
    if (status == STATUS_EXIT) return FALSE;
    watch_preferences_f();
    return TRUE;
}

static gboolean
signal_on_leave (GtkWidget * widget, GdkEventCrossing * event, gpointer data) {
    NOOP ("signal_on_leave...\n");
    rodent_on_leave(data);
    return FALSE;
}

static gboolean
button_callback(GtkWidget *button, GdkEvent  *event, gpointer data) {
    rfm_rational(RFM_MODULE_DIR, "callbacks", data, NULL, "callback");
    return TRUE;
}

#ifdef SHOW_SIZE_SCALE
static void  
size_scale_callback (GtkRange *range,  gpointer  data){
    // This module function will only reload if iconsize changes.
    widgets_t *widgets_p = data;
    NOOP(stderr, "size_scale_callback...\n");
    if (g_object_get_data(G_OBJECT(widgets_p->paper), "size_scale_disabled")) {	
	rfm_reset_tooltip(GTK_WIDGET(range));
	return;
    }
    gdouble value = gtk_range_get_value (range);
    //gint ivalue = floor(value);
    gint ivalue;
    if (value < TINY_ICON_SIZE/2) ivalue = LIST_ICON_SIZE;
    else if (value < SMALL_ICON_SIZE-(SMALL_ICON_SIZE-TINY_ICON_SIZE)/2)
	ivalue = TINY_ICON_SIZE;
    else if (value < MEDIUM_ICON_SIZE-(MEDIUM_ICON_SIZE-SMALL_ICON_SIZE)/2)
	ivalue = SMALL_ICON_SIZE;
    else if (value < BIG_ICON_SIZE-(BIG_ICON_SIZE-MEDIUM_ICON_SIZE)/2)
	ivalue = MEDIUM_ICON_SIZE;
    else ivalue = BIG_ICON_SIZE;

    NOOP("size_scale_callback...%d OK\n",ivalue);

    gint oldvalue = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(range), "oldvalue"));
    if (ivalue != oldvalue){
	g_object_set_data(G_OBJECT(range), "oldvalue", GINT_TO_POINTER(ivalue));
        while (ivalue != oldvalue) {
            NOOP("size_scale_callback...old->new %d->%d OK\n",oldvalue, ivalue);
            if (ivalue > oldvalue){
	        rodent_menu_callback(NULL, GINT_TO_POINTER(PLUS_ICONSIZE_ACTIVATE));
                oldvalue +=24;
            } else {
	        rodent_menu_callback(NULL, GINT_TO_POINTER(MINUS_ICONSIZE_ACTIVATE));
                oldvalue -=24;
            }
        }
    }

}
#endif

